use ExtUtils::MakeMaker;
use strict;

WriteMakefile1(
    NAME            => 'Module::Load::Conditional',
    VERSION_FROM    => 'lib/Module/Load/Conditional.pm', # finds $VERSION
    dist            => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' },
    PREREQ_PM       => {    'Test::More'                => 0,
                            'Params::Check'             => 0,
                            'Module::Load'              => '0.11',
                            'Locale::Maketext::Simple'  => 0,
                            ### XXX version.pm 0.69 pure perl fails
                            ### tests under 5.6.2. XS version is OK
                            ### see t/02_Parse_Version.t for details
                            'version'                   => '0.69',
                            ### We need 2.22 for is_deprecated()
                            'Module::CoreList'          => '2.22',
                            ### We need 1.000_005 for new_from_handle()
                            'Module::Metadata'          => '1.000005',
                    },
    INSTALLDIRS     => ( $] >= 5.009005 and $] < 5.012 ? 'perl' : 'site' ),
    AUTHOR          => 'Jos Boumans <kane[at]cpan.org>',
    ABSTRACT        => 'Looking up module information / loading at runtime',
    LICENSE => 'perl',
    META_MERGE => {
        resources => {
            repository => 'https://github.com/jib/module-load-conditional',
        },
    },
    #BUILD_REQUIRES => {
    #},
);

sub WriteMakefile1 {  #Written by Alexandr Ciornii, version 0.21. Added by eumm-upgrade.
    my %params=@_;
    my $eumm_version=$ExtUtils::MakeMaker::VERSION;
    $eumm_version=eval $eumm_version;
    die "EXTRA_META is deprecated" if exists $params{EXTRA_META};
    die "License not specified" if not exists $params{LICENSE};
    if ($params{BUILD_REQUIRES} and $eumm_version < 6.5503) {
        #EUMM 6.5502 has problems with BUILD_REQUIRES
        $params{PREREQ_PM}={ %{$params{PREREQ_PM} || {}} , %{$params{BUILD_REQUIRES}} };
        delete $params{BUILD_REQUIRES};
    }
    delete $params{CONFIGURE_REQUIRES} if $eumm_version < 6.52;
    delete $params{MIN_PERL_VERSION} if $eumm_version < 6.48;
    delete $params{META_MERGE} if $eumm_version < 6.46;
    delete $params{META_ADD} if $eumm_version < 6.46;
    delete $params{LICENSE} if $eumm_version < 6.31;
    delete $params{AUTHOR} if $] < 5.005;
    delete $params{ABSTRACT_FROM} if $] < 5.005;
    delete $params{BINARY_LOCATION} if $] < 5.005;

    WriteMakefile(%params);
}

