# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package JobAd::GEN::Job;

use strict;

use base 'JobAd';

use JobAd::Model::job qw(
    $JOB
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Job' );

    my $retval = {
        headings       => [
            'Title',
            'Description',
        ],
        header_options => [
            {
                text => 'Add',
                link => $self->location() . "/add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $JOB->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->title,
                    $row->description,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $self->location() . "/edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $self->location() . "/delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $JOB->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'title',
                label => 'Title',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'description',
                label => 'Description',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'travel_percent',
                label => 'Travel Percent',
                type => 'text',
                is => 'varchar',
            },
            {
                options => [
                    { label => 'On-Site', value => 'onsite' },
                    { label => 'Partial Telecommute', value => 'parttele' },
                    { label => 'Telecommute', value => 'tele' },
                ],
                name => 'on_site',
                label => 'On Site',
                type => 'select',
                is => 'varchar',
            },
            {
                options => [
                    { label => 'Full Time', value => 'fulltime' },
                    { label => 'Part Time', value => 'parttime' },
                    { label => 'Contract', value => 'contract' },
                ],
                name => 'time_percent',
                label => 'Time Percent',
                type => 'select',
                is => 'varchar',
            },
        ],
    };
} # END form


1;

=head1 NAME

JobAd::GEN::Job - generated support module for JobAd::Job

=head1 SYNOPSIS

In JobAd::Job:

    use JobAd::GEN::Job qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in JobAd::Job to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

