#!/usr/bin/perl

use Text::FormatTable;

my @mods =  (qw(
		QWizard::Generator::HTML
		QWizard::Generator::Gtk2
		QWizard::Generator::Tk
		QWizard::Generator::ReadLine
	       ));

print_header();

#
# print general support matrix
#
my %types;
foreach my $name (@mods) {
    my $g = eval "require $name;
                  new ${name}();";
    if (!$g || ref($g) ne $name) {
	next;
    }
    map {
	$types{$name}{$_} = 'X';
	$types{'all'}{$_} = 'X';
    } $g->get_supported_tags();
}

my $table = Text::FormatTable->new('  |' . 'l|' x ($#mods+2));
my @smnames = @mods;
map { s/.*:://; } @smnames;
$table->rule('-');
$table->head(' ', @smnames);
$table->rule('-');
foreach my $tag (sort keys(%{$types{'all'}})) {
    my @row = $tag;
    map { push @row, $types{$_}{$tag} } @mods;
    $table->row(@row);
}
$table->rule('-');
my $tabletxt = $table->render(75);
$tabletxt =~ s/^--/  /gm;
print "$tabletxt\n";

print "\n\n=head1 THE GENERATORS\n\n";

#
# print detailed args
#
foreach my $name (qw(
		     QWizard::Generator::HTML
		     QWizard::Generator::Gtk2
		     QWizard::Generator::Tk
		     QWizard::Generator::ReadLine
		    )) {
    my $g = eval "require $name;
                  new ${name}();";
    if (!$g || ref($g) ne $name) {
	next;
    }
    print "=head2 $name

These are the question types known to the $name generator class:

\=over

";
    $g->print_handler_tags("=item %s => %s %s %s\n\n",
			   "=item %s\n\n=over\n\n", "=back\n\n");
    print "=back\n\n";
    print "\n\n";
}

print_trailer();



sub print_header {

    print '

=pod

=head1 NAME

QWizard_Widgets - Describes the Widgets available to QWizard Generators

=head1 OVERVIEW

This document describes the various QWizard backend widgets that can
be produced and what tags they support, and what the values of those
tags are expected to produce (either by direct value such as

  tag => "string"

or as a result of a code execution like 

  tag => sub { return "string" }

or even:

  tag => [sub { return $_[$#_] }, "string"]

=head2 Tag Value Expectations

The documentation to follow will reference a number of different value
types for various tags.  These possible values are described below:

=over

=item single

A single value is expected for this tag.  If a subroutine returns
multiple values only the first will be used.

=item multi

The tag expects or can accept multiple values.  These values should be
specified in the form of an array reference.

=item norecuse

This is a special form of "multi"...  I need to go look at the code
again to remember exactly what it does.

=item values,labels

This is a special tag to indicate the widget needs both values and
labels associated with the multiple sub-widgets it can display (radio
boxes, menu items, check boxes, ...).  The values tag (an array ref)
will indicate which values are used within the program.  The labels
clause will map those values to human strings.  The labels clause can
be either a hash mapping values to labels, or an array where the even
elements of the array (0, 2, 4, ...) will be the values and the odd
elements (1, 3, 5, ...) will be the labels to associate with them.  An
array reference for labels allows the order of label presentation to
be specified, where as a hash will display the labels/sub-widgets in a
somewhat random order.

If the labels clause is left out, the values themselves will be
present to the user.

If the values clause is left out, the values will be pulled from the labels.

It is likely a rare case that you need to specify both.  This special
tag name specifically indicates you can specify both.

=item forced

This is a value which is forced for a particular tag for internal use
and can\'t be manipulated by the programmer.  It\'s documented here
anyway for completeness.

=head2 Notes about this document.

=over

=item 1)

This file is automatically generated from the Generator\'s own
expect ions of their supported widgets and the requirements.  Thus,
not all widgets in all generators are perfectly equal.  Some
generators have better support for extra options for certain widgets,
for example.

=item 2)

This document does not specify some of the other tags that every
question is allowed to have, such as "name", "text", "helpddesc",
"check_value", ...  It only discusses the tags that the back end
generators make use of.

=head1 WIDGET SUPPORT SUMMARY MATRIX

';

}

sub print_trailer {
    print '

=head1 AUTHOR

Wes Hardaker, hardaker@users.sourceforge.net

=head1 SEE ALSO

QWizard, perl(1)

Net-Policy: http://net-policy.sourceforge.net/

=cut

';

}
