use ExtUtils::MakeMaker;

require 5.006;

unless( $^O =~ m/darwin/ )
	{
	warn "OS unsupported. This module only works on Mac OS X.\n";
	exit 0;
	}

eval "use Test::Manifest 1.21";

WriteMakefile(
	'NAME'	       => 'Mac::OSVersion',
	'ABSTRACT'     => 'Get the Mac OS X system version',
	'VERSION_FROM' => 'lib/Mac/OSVersion.pm',
	'LICENSE'      => 'perl',
	'AUTHOR'       => 'brian d foy <bdfoy@cpan.org>',
	
	'BUILD_REQUIRES' => {
		'Test::More'   => '0',
		},

	'RECOMMENDS' => {
		# This needs Mac::Carbon, which doesn't work on 64-bit systems
		'Mac::Gestalt' => '0',
		},

	clean  => { FILES    => q|Mac-OSVersion-*| },
	);
