/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.stack;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.stack.NonProjective;
import org.maltparser.parser.algorithm.stack.StackFactory;
import org.maltparser.parser.algorithm.stack.SwapEagerOracle;
import org.maltparser.parser.guide.OracleGuide;
import org.maltparser.parser.history.GuideUserHistory;

public class StackSwapEagerFactory
extends StackFactory {
    public StackSwapEagerFactory(Algorithm algorithm) {
        super(algorithm);
    }

    public TransitionSystem makeTransitionSystem() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Transition system    : Non-Projective\n");
        }
        NonProjective ts = new NonProjective();
        ts.setPropagationManager(this.manager.getPropagationManager());
        return ts;
    }

    public OracleGuide makeOracleGuide(GuideUserHistory history) throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Oracle               : Swap-Eager\n");
        }
        return new SwapEagerOracle(this.manager, history);
    }
}

