/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TLongHash;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TLongObjectHashMap
extends TLongHash
implements Serializable {
    protected transient Object[] _values;

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(long key, Object value) {
        Object previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldKeys = this._set;
        Object[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            long o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public Object get(long key) {
        int index = this.index(key);
        return index < 0 ? null : this._values[index];
    }

    public void clear() {
        super.clear();
        long[] keys = this._set;
        Object[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0L;
            vals[i] = null;
            states[i] = 0;
        }
    }

    public Object remove(long key) {
        Object prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongObjectHashMap)) {
            return false;
        }
        TLongObjectHashMap that = (TLongObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = null;
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public long[] keys() {
        long[] keys = new long[this.size()];
        long[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(Object val) {
        byte[] states = this._states;
        Object[] vals = this._values;
        if (val == null) {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        byte[] states = this._states;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongObjectProcedure procedure) {
        byte[] states = this._states;
        long[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TObjectFunction function) {
        byte[] states = this._states;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        class WriteProcedure
        implements TLongObjectProcedure {
            IOException e;
            private final /* synthetic */ TLongObjectHashMap this$0;
            private final /* synthetic */ ObjectOutputStream val$stream;

            public boolean execute(long key, Object value) {
                try {
                    this.val$stream.writeLong(key);
                    this.val$stream.writeObject(value);
                }
                catch (IOException ioe) {
                    this.e = ioe;
                    return false;
                }
                return true;
            }

            /* synthetic */ WriteProcedure(TLongObjectHashMap this$0, ObjectOutputStream val$stream) {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TLongObjectHashMap tLongObjectHashMap) {
            }
        }
        WriteProcedure writeProcedure = new WriteProcedure(this, stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.e;
        }
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = stream.readLong();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    public TLongObjectHashMap() {
    }

    public TLongObjectHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TLongObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    private static final class EqProcedure
    implements TLongObjectProcedure {
        private final TLongObjectHashMap _otherMap;

        public final boolean execute(long key, Object value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }

        EqProcedure(TLongObjectHashMap otherMap) {
            this._otherMap = otherMap;
        }
    }
}

