package Software::Release::Watch::Source::WebPage;

use 5.010;
use Moo::Role;

our $VERSION = '0.01'; # VERSION

requires "url";
requires "parse_html";

sub list_releases {
    my $self = shift;

    my $w    = $self->watcher;
    my $resp = $w->get_url($self->url);

    my $ct = $resp->content_type;
    die [542, "URL not a web (HTML) page ($ct)", undef] unless $ct =~ /html/;
    $self->parse_html($resp->content);
}

1;
# ABSTRACT: Get releases from web page


__END__
=pod

=head1 NAME

Software::Release::Watch::Source::WebPage - Get releases from web page

=head1 VERSION

version 0.01

=for Pod::Coverage list_releases

=head1 DESCRIPTION


This module has L<Rinci> metadata.

=head1 FUNCTIONS


None are exported by default, but they are exportable.

=head1 AUTHOR

Steven Haryanto <stevenharyanto@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Steven Haryanto.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

