
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'go from "file" names to things',
  'AUTHOR' => 'Ricardo Signes <rjbs@cpan.org>',
  'BUILD_REQUIRES' => {
    'Data::Section' => '0',
    'Test::More' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.31'
  },
  'DISTNAME' => 'Path-Resolver',
  'EXE_FILES' => [],
  'LICENSE' => 'perl',
  'NAME' => 'Path::Resolver',
  'PREREQ_PM' => {
    'Archive::Tar' => '0',
    'Carp' => '0',
    'Cwd' => '0',
    'Data::Section' => '0',
    'File::ShareDir' => '1',
    'File::Spec' => '0',
    'File::Spec::Unix' => '0',
    'Moose' => '0.90',
    'Moose::Role' => '0',
    'Moose::Util::TypeConstraints' => '0',
    'MooseX::AttributeHelpers' => '0',
    'MooseX::Types' => '0',
    'MooseX::Types::Moose' => '0',
    'Path::Class' => '0',
    'Path::Class::File' => '0',
    'autodie' => '0',
    'namespace::autoclean' => '0'
  },
  'VERSION' => '3.100451',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



