/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Tag;
import java.util.HashMap;

final class SpecialTag {
    private String description;
    private String name;
    private String startDelimiter;
    private String endDelimiter;
    private boolean serverTag;
    private boolean hasEndTag;
    private boolean identifierCharacterAllowedAfterName;
    public static final SpecialTag COMMENT = new SpecialTag("comment", "!--", "<!--", "-->", false, false);
    public static final SpecialTag DOCTYPE = new SpecialTag("document type declaration", "!doctype", "<!doctype", ">", false, false);
    public static final SpecialTag PROCESSING_INSTRUCTION = new SpecialTag("processing instruction", "?", "<?", "?>", false, false);
    public static final SpecialTag XML_DECLARATION = new SpecialTag("XML declaration", "?xml", "<?xml", "?>", false, false);
    public static final SpecialTag PHP_TAG = new SpecialTag("PHP tag", "?php", "<?php", "?>", true, false);
    public static final SpecialTag COMMON_SERVER_TAG = new SpecialTag("common server tag", Tag.SERVER_COMMON, "<%", "%>", true, false);
    public static final SpecialTag MASON_COMPONENT_CALL = new SpecialTag("mason component call", "&", "<&", "&>", true, false);
    public static final SpecialTag MASON_COMPONENT_CALLED_WITH_CONTENT = new SpecialTag("mason component called with content", "&|", "<&|", "&>", true, true);
    public static final SpecialTag MASON_NAMED_BLOCK = new SpecialTag("mason named block", Tag.SERVER_MASON_NAMED_BLOCK, "<%", ">", true, true);
    private static SpecialTag[] mappedSpecialTags = new SpecialTag[]{COMMENT, DOCTYPE, PROCESSING_INSTRUCTION, XML_DECLARATION, PHP_TAG, COMMON_SERVER_TAG, MASON_COMPONENT_CALL, MASON_COMPONENT_CALLED_WITH_CONTENT};
    private static HashMap map = new HashMap();

    private SpecialTag(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.description = string;
        this.name = string2;
        this.startDelimiter = string3;
        this.endDelimiter = string4;
        this.serverTag = bl;
        this.hasEndTag = bl2;
        this.identifierCharacterAllowedAfterName = !Character.isLetter(string2.charAt(string2.length() - 1));
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public boolean isServerTag() {
        return this.serverTag;
    }

    public boolean hasEndTag() {
        return this.hasEndTag;
    }

    public boolean isIdentifierCharacterAllowedAfterName() {
        return this.identifierCharacterAllowedAfterName;
    }

    public static SpecialTag get(String string) {
        if (string == SpecialTag.MASON_NAMED_BLOCK.name) {
            return MASON_NAMED_BLOCK;
        }
        return (SpecialTag)map.get(string.toLowerCase());
    }

    public static SpecialTag get(Source source, int n) {
        String string = source.getParseTextLowerCase();
        char c = string.charAt(n);
        switch (c) {
            case '!': {
                if (string.startsWith(COMMENT.getName(), n)) {
                    return COMMENT;
                }
                if (string.startsWith("!doctype", n)) {
                    return DOCTYPE;
                }
                return null;
            }
            case '?': {
                if (string.startsWith("?xml", n)) {
                    return XML_DECLARATION;
                }
                if (string.startsWith("?php", n)) {
                    return PHP_TAG;
                }
                return PROCESSING_INSTRUCTION;
            }
            case '%': {
                return COMMON_SERVER_TAG;
            }
            case '&': {
                if (string.charAt(n + 1) == '|') {
                    return MASON_COMPONENT_CALLED_WITH_CONTENT;
                }
                return MASON_COMPONENT_CALL;
            }
        }
        return null;
    }

    static {
        for (int i = 0; i < mappedSpecialTags.length; ++i) {
            map.put(SpecialTag.mappedSpecialTags[i].name, mappedSpecialTags[i]);
        }
    }
}

