# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.
BEGIN { require 5.008; }
use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;

my %WriteMakefileArgs = (
  'ABSTRACT' => 'Wrapper Class for the various JSON classes.',
  'AUTHOR' => 'Chris Thompson <cthom@cpan.org>, Chris Prather <chris@prather.org>, Robin Berjon <robin@berjon.com>, Marc Mims <marc@questright.com>, Tomas Doran <bobtfish@bobtfish.net>',
  'BUILD_REQUIRES' => {},
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'JSON-Any',
  'EXE_FILES' => [],
  'LICENSE' => 'perl',
  'NAME' => 'JSON::Any',
  'PREREQ_PM' => {},
  'VERSION' => '1.30',
  'test' => {
    'TESTS' => 't/*.t'
  }
);
;

  
    sub has_json () {
        our @order = qw(XS JSON DWIW);
        foreach my $testmod (@order) {
            $testmod = "JSON::$testmod" unless $testmod eq "JSON";
            eval "require $testmod";
            return 1 unless $@;
        }
        return 0;
    }

    if (has_json) {
        # we have some kind of supported JSON module, we're good
    }
    else {

        # we need to have a version of JSON, go with JSON.pm as a sane default
        $WriteMakefileArgs{PREREQ_PM}{JSON} = '2.02';
    }
    
  


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

