#! perl

use strict;
use warnings;
use Test::More tests => 2;
use MIDI::Tweaks;
-d "t" && chdir "t";
require "tools.pl";

# Actually, this is more a verification of MIDI functionality that
# we're going to rely on.

my $id = "02-trivial";
my @cln = ( "$id.mid.dmp", "$id.out.dmp");

# Cleanup.
unlink(@cln);

my $data = do { local $/; <DATA> };

my $op = eval $data;
ok($op, "load from DATA");

# Dump it.
$op->dump_to_file("$id.mid.dmp");

# Dump ref copy.
string_to_file($data, "$id.out.dmp");

# Compare the dumps.
is(differ("$id.mid.dmp", "$id.out.dmp", 1), 0, "compare");

# Cleanup.
unlink(@cln);

__DATA__
MIDI::Tweaks::Opus->new({
  'format' => 1,
  'ticks'  => 256,
  'tracks' => [   # 3 tracks...

    # Track #0 ...
    MIDI::Track->new({
      'type' => 'MTrk',
      'events' => [  # 4 events.
        ['time_signature', 0, 4, 2, 24, 8],
        ['key_signature', 0, 0, 0],
        ['set_tempo', 0, 600000],
        ['text_event', 1, ''],
      ]
    }),
    
    # Track #1 ...
    MIDI::Track->new({
      'type' => 'MTrk',
      'events' => [  # 347 events.
        ['control_change', 0, 0, 0, 0],
        ['control_change', 0, 0, 32, 0],
        ['patch_change', 0, 0, 52],
        ['lyric', 128, '1.If '],
        ['note_on', 0, 0, 70, 68],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'ev'],
        ['note_on', 0, 0, 70, 75],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, '\'ry'],
        ['note_on', 0, 0, 70, 80],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'bo'],
        ['note_on', 0, 0, 70, 77],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'dy '],
        ['note_on', 0, 0, 70, 75],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'had '],
        ['note_on', 0, 0, 69, 76],
        ['note_on', 128, 0, 69, 0],
        ['lyric', 0, 'an '],
        ['note_on', 0, 0, 69, 78],
        ['note_on', 128, 0, 69, 0],
        ['lyric', 0, 'o'],
        ['note_on', 0, 0, 67, 67],
        ['note_on', 384, 0, 67, 0],
        ['lyric', 0, 'cean '],
        ['note_on', 0, 0, 62, 64],
        ['note_on', 640, 0, 62, 0],
        ['lyric', 128, 'a'],
        ['note_on', 0, 0, 70, 71],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'cross '],
        ['note_on', 0, 0, 70, 75],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'the '],
        ['note_on', 0, 0, 70, 74],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'U. '],
        ['note_on', 0, 0, 70, 77],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'S. '],
        ['note_on', 0, 0, 69, 74],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 0, 69, 78],
        ['note_on', 128, 0, 69, 0],
        ['note_on', 0, 0, 67, 69],
        ['note_on', 768, 0, 67, 0],
        ['lyric', 384, 'then '],
        ['note_on', 0, 0, 70, 68],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'ev\' '],
        ['note_on', 0, 0, 70, 75],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'ry'],
        ['note_on', 0, 0, 70, 77],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'bo'],
        ['note_on', 0, 0, 70, 74],
        ['lyric', 128, 'dy\'d '],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'be '],
        ['note_on', 0, 0, 69, 70],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'sur'],
        ['note_on', 0, 0, 67, 73],
        ['note_on', 384, 0, 67, 0],
        ['lyric', 0, 'fin\' '],
        ['note_on', 0, 0, 62, 65],
        ['note_on', 640, 0, 62, 0],
        ['lyric', 128, 'like '],
        ['note_on', 0, 0, 70, 68],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'Ca'],
        ['note_on', 0, 0, 70, 73],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'li'],
        ['note_on', 0, 0, 70, 71],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'for'],
        ['note_on', 0, 0, 70, 78],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'ni'],
        ['note_on', 0, 0, 69, 74],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'a '],
        ['note_on', 0, 0, 69, 82],
        ['note_on', 128, 0, 69, 0],
        ['note_on', 0, 0, 67, 71],
        ['note_on', 768, 0, 67, 0],
        ['lyric', 384, 'You\'d '],
        ['note_on', 0, 0, 72, 67],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'see '],
        ['note_on', 0, 0, 72, 78],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'them '],
        ['note_on', 0, 0, 72, 74],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'wear'],
        ['note_on', 0, 0, 72, 77],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'in\' '],
        ['note_on', 0, 0, 72, 78],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'their '],
        ['note_on', 0, 0, 72, 73],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'bag'],
        ['note_on', 0, 0, 72, 76],
        ['note_on', 512, 0, 72, 0],
        ['lyric', 0, 'gies '],
        ['note_on', 0, 0, 65, 63],
        ['note_on', 640, 0, 65, 0],
        ['lyric', 128, 'huar'],
        ['note_on', 0, 0, 69, 69],
        ['note_on', 128, 0, 69, 0],
        ['lyric', 0, 'a'],
        ['note_on', 0, 0, 70, 79],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'chi '],
        ['note_on', 0, 0, 71, 80],
        ['note_on', 128, 0, 71, 0],
        ['lyric', 0, 'san'],
        ['note_on', 0, 0, 72, 83],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'dals '],
        ['note_on', 0, 0, 72, 77],
        ['note_on', 256, 0, 72, 0],
        ['lyric', 0, 'too, '],
        ['note_on', 0, 0, 67, 70],
        ['note_on', 128, 0, 67, 0],
        ['note_on', 0, 0, 69, 77],
        ['note_on', 128, 0, 69, 0],
        ['note_on', 0, 0, 67, 73],
        ['note_on', 640, 0, 67, 0],
        ['lyric', 384, 'a '],
        ['note_on', 0, 0, 70, 65],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'bus'],
        ['note_on', 0, 0, 70, 73],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'hy '],
        ['note_on', 0, 0, 70, 79],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'bus'],
        ['note_on', 0, 0, 70, 75],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'hy '],
        ['note_on', 0, 0, 70, 75],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'blonde '],
        ['note_on', 0, 0, 69, 76],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'hair'],
        ['note_on', 0, 0, 67, 72],
        ['note_on', 384, 0, 67, 0],
        ['lyric', 0, 'do, '],
        ['note_on', 0, 0, 62, 65],
        ['note_on', 640, 0, 62, 0],
        ['lyric', 256, 'sur'],
        ['note_on', 0, 0, 65, 72],
        ['note_on', 0, 0, 69, 72],
        ['note_on', 128, 0, 65, 0],
        ['note_on', 0, 0, 69, 0],
        ['lyric', 0, 'fin\' '],
        ['note_on', 0, 0, 65, 77],
        ['note_on', 0, 0, 69, 77],
        ['note_on', 128, 0, 65, 0],
        ['note_on', 0, 0, 69, 0],
        ['lyric', 0, 'U. '],
        ['note_on', 0, 0, 64, 71],
        ['note_on', 0, 0, 67, 71],
        ['note_on', 128, 0, 64, 0],
        ['note_on', 0, 0, 67, 0],
        ['lyric', 0, 'S. '],
        ['note_on', 0, 0, 62, 68],
        ['note_on', 0, 0, 65, 68],
        ['note_on', 256, 0, 62, 0],
        ['note_on', 0, 0, 65, 0],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 0, 60, 74],
        ['note_on', 0, 0, 64, 74],
        ['note_on', 1152, 0, 60, 0],
        ['note_on', 0, 0, 64, 0],
        ['lyric', 128, 'You\'ll '],
        ['note_on', 0, 0, 70, 67],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'catch '],
        ['note_on', 0, 0, 70, 78],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'them '],
        ['note_on', 0, 0, 70, 75],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'sur'],
        ['note_on', 0, 0, 70, 79],
        ['lyric', 128, 'fin '],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'at '],
        ['note_on', 0, 0, 69, 72],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'Del'],
        ['note_on', 0, 0, 67, 71],
        ['note_on', 384, 0, 67, 0],
        ['lyric', 0, 'mar '],
        ['note_on', 0, 0, 62, 67],
        ['note_on', 640, 0, 62, 0],
        ['lyric', 128, 'Ven'],
        ['note_on', 0, 0, 67, 71],
        ['note_on', 128, 0, 67, 0],
        ['lyric', 0, 'tu'],
        ['note_on', 0, 0, 69, 80],
        ['note_on', 128, 0, 69, 0],
        ['lyric', 0, 'ra '],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 0, 67, 72],
        ['note_on', 128, 0, 67, 0],
        ['lyric', 0, 'Coun'],
        ['note_on', 0, 0, 70, 78],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'try '],
        ['note_on', 0, 0, 69, 73],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'Line '],
        ['note_on', 0, 0, 69, 78],
        ['note_on', 128, 0, 69, 0],
        ['note_on', 0, 0, 67, 69],
        ['note_on', 768, 0, 67, 0],
        ['lyric', 512, 'San'],
        ['note_on', 0, 0, 70, 66],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'ta '],
        ['note_on', 0, 0, 70, 72],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'Cruz '],
        ['note_on', 0, 0, 70, 72],
        ['note_on', 256, 0, 70, 0],
        ['lyric', 0, 'and '],
        ['note_on', 0, 0, 69, 75],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'Tres'],
        ['note_on', 0, 0, 67, 73],
        ['note_on', 384, 0, 67, 0],
        ['lyric', 0, 'sels '],
        ['note_on', 0, 0, 62, 62],
        ['note_on', 640, 0, 62, 0],
        ['lyric', 128, 'Aus'],
        ['note_on', 0, 0, 67, 69],
        ['note_on', 128, 0, 67, 0],
        ['lyric', 0, 'tra'],
        ['note_on', 0, 0, 69, 82],
        ['note_on', 128, 0, 69, 0],
        ['lyric', 0, 'lia\'s '],
        ['note_on', 0, 0, 67, 69],
        ['note_on', 128, 0, 67, 0],
        ['lyric', 0, 'Na'],
        ['note_on', 0, 0, 70, 83],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'ra'],
        ['note_on', 0, 0, 69, 73],
        ['note_on', 256, 0, 69, 0],
        ['lyric', 0, 'bine '],
        ['note_on', 0, 0, 67, 67],
        ['note_on', 128, 0, 67, 0],
        ['note_on', 0, 0, 69, 76],
        ['note_on', 128, 0, 69, 0],
        ['note_on', 0, 0, 67, 74],
        ['note_on', 640, 0, 67, 0],
        ['lyric', 512, 'All '],
        ['note_on', 0, 0, 74, 67],
        ['note_on', 128, 0, 74, 0],
        ['lyric', 0, 'o'],
        ['note_on', 0, 0, 72, 72],
        ['note_on', 256, 0, 72, 0],
        ['lyric', 0, 'ver '],
        ['note_on', 0, 0, 72, 78],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'Man'],
        ['note_on', 0, 0, 72, 77],
        ['note_on', 256, 0, 72, 0],
        ['lyric', 0, 'hat'],
        ['note_on', 0, 0, 72, 73],
        ['note_on', 384, 0, 72, 0],
        ['lyric', 0, 'tan '],
        ['note_on', 0, 0, 65, 63],
        ['note_on', 640, 0, 65, 0],
        ['lyric', 128, 'and '],
        ['note_on', 0, 0, 69, 70],
        ['note_on', 128, 0, 69, 0],
        ['lyric', 0, 'down '],
        ['note_on', 0, 0, 70, 81],
        ['note_on', 128, 0, 70, 0],
        ['lyric', 0, 'Do'],
        ['note_on', 0, 0, 71, 75],
        ['note_on', 128, 0, 71, 0],
        ['lyric', 0, 'he'],
        ['note_on', 0, 0, 72, 80],
        ['note_on', 128, 0, 72, 0],
        ['lyric', 0, 'ny '],
        ['note_on', 0, 0, 72, 76],
        ['note_on', 256, 0, 72, 0],
        ['lyric', 0, 'way '],
        ['note_on', 0, 0, 67, 63],
        ['note_on', 128, 0, 67, 0],
        ['note_on', 0, 0, 69, 82],
        ['note_on', 128, 0, 69, 0],
        ['note_on', 0, 0, 67, 72],
        ['note_on', 640, 0, 67, 0],
        ['lyric', 512, 'Ev'],
        ['note_on', 0, 0, 60, 71],
        ['note_on', 128, 0, 60, 0],
        ['lyric', 0, '\'ry'],
        ['note_on', 0, 0, 60, 75],
        ['note_on', 128, 0, 60, 0],
        ['lyric', 0, 'bo'],
        ['note_on', 0, 0, 64, 86],
        ['note_on', 128, 0, 64, 0],
        ['lyric', 0, 'dy\'s '],
        ['note_on', 0, 0, 64, 77],
        ['note_on', 128, 0, 64, 0],
        ['lyric', 0, 'gone '],
        ['note_on', 0, 0, 67, 84],
        ['note_on', 256, 0, 67, 0],
        ['lyric', 0, 'sur'],
        ['note_on', 0, 0, 65, 72],
        ['note_on', 384, 0, 65, 0],
        ['lyric', 0, 'fin\' '],
        ['note_on', 0, 0, 62, 68],
        ['note_on', 640, 0, 62, 0],
        ['lyric', 256, 'sur'],
        ['note_on', 0, 0, 65, 67],
        ['note_on', 128, 0, 65, 0],
        ['lyric', 0, 'fin\' '],
        ['note_on', 0, 0, 65, 73],
        ['note_on', 128, 0, 65, 0],
        ['lyric', 0, 'U.'],
        ['note_on', 0, 0, 64, 68],
        ['note_on', 128, 0, 64, 0],
        ['lyric', 0, 'S.'],
        ['note_on', 0, 0, 62, 70],
        ['note_on', 256, 0, 62, 0],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 0, 64, 78],
        ['note_on', 1152, 0, 64, 0],
        ['text_event', 1, ''],
      ]
    }),
    
    # Track #2 ...
    MIDI::Track->new({
      'type' => 'MTrk',
      'events' => [  # 357 events.
        ['control_change', 0, 1, 0, 0],
        ['control_change', 0, 1, 32, 0],
        ['patch_change', 0, 1, 52],
        ['lyric', 1024, 'oooh '],
        ['note_on', 0, 1, 59, 64],
        ['note_on', 0, 1, 62, 64],
        ['note_on', 0, 1, 67, 64],
        ['note_on', 1024, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 1024, 'oooh '],
        ['note_on', 0, 1, 60, 70],
        ['note_on', 0, 1, 64, 70],
        ['note_on', 0, 1, 67, 70],
        ['note_on', 1024, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 1024, 'oooh '],
        ['note_on', 0, 1, 59, 71],
        ['note_on', 0, 1, 62, 71],
        ['note_on', 0, 1, 65, 71],
        ['note_on', 1024, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 1024, 'oooh '],
        ['note_on', 0, 1, 60, 69],
        ['note_on', 0, 1, 64, 69],
        ['note_on', 0, 1, 67, 69],
        ['note_on', 1024, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 1024, 'oooh '],
        ['note_on', 0, 1, 60, 80],
        ['note_on', 0, 1, 65, 80],
        ['note_on', 0, 1, 69, 80],
        ['note_on', 1024, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 1024, 'oooh '],
        ['note_on', 0, 1, 60, 72],
        ['note_on', 0, 1, 64, 72],
        ['note_on', 0, 1, 67, 72],
        ['note_on', 1024, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 1024, 'oooh '],
        ['note_on', 0, 1, 59, 72],
        ['note_on', 0, 1, 62, 72],
        ['note_on', 0, 1, 65, 72],
        ['note_on', 1024, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 1024, 'ooo'],
        ['note_on', 0, 1, 60, 79],
        ['note_on', 0, 1, 64, 79],
        ['note_on', 0, 1, 67, 79],
        ['lyric', 1024, 'oooh '],
        ['note_on', 1024, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'in'],
        ['note_on', 0, 1, 59, 80],
        ['note_on', 0, 1, 62, 80],
        ['note_on', 0, 1, 67, 80],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side, '],
        ['note_on', 0, 1, 59, 72],
        ['note_on', 0, 1, 62, 72],
        ['note_on', 0, 1, 67, 72],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'out'],
        ['note_on', 0, 1, 59, 79],
        ['note_on', 0, 1, 62, 79],
        ['note_on', 0, 1, 67, 79],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side '],
        ['note_on', 0, 1, 59, 76],
        ['note_on', 0, 1, 62, 76],
        ['note_on', 0, 1, 67, 76],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'U. '],
        ['note_on', 0, 1, 59, 76],
        ['note_on', 0, 1, 62, 76],
        ['note_on', 0, 1, 67, 76],
        ['note_on', 128, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'S. '],
        ['note_on', 0, 1, 59, 73],
        ['note_on', 0, 1, 62, 73],
        ['note_on', 0, 1, 67, 73],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['note_on', 0, 1, 59, 76],
        ['note_on', 0, 1, 62, 76],
        ['note_on', 0, 1, 67, 76],
        ['note_on', 384, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 256, 'in'],
        ['note_on', 0, 1, 60, 73],
        ['note_on', 0, 1, 64, 73],
        ['note_on', 0, 1, 67, 73],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side, '],
        ['note_on', 0, 1, 60, 72],
        ['note_on', 0, 1, 64, 72],
        ['note_on', 0, 1, 67, 72],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'out'],
        ['note_on', 0, 1, 60, 75],
        ['note_on', 0, 1, 64, 75],
        ['note_on', 0, 1, 67, 75],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side '],
        ['note_on', 0, 1, 60, 76],
        ['note_on', 0, 1, 64, 76],
        ['note_on', 0, 1, 67, 76],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'U. '],
        ['note_on', 0, 1, 60, 75],
        ['note_on', 0, 1, 64, 75],
        ['note_on', 0, 1, 67, 75],
        ['note_on', 128, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'S. '],
        ['note_on', 0, 1, 60, 81],
        ['note_on', 0, 1, 64, 81],
        ['note_on', 0, 1, 67, 81],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 1, 60, 78],
        ['note_on', 0, 1, 64, 78],
        ['note_on', 0, 1, 67, 78],
        ['note_on', 384, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 256, 'in'],
        ['note_on', 0, 1, 59, 67],
        ['note_on', 0, 1, 62, 67],
        ['note_on', 0, 1, 65, 67],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 0, 'side, '],
        ['note_on', 0, 1, 59, 74],
        ['note_on', 0, 1, 62, 74],
        ['note_on', 0, 1, 65, 74],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 0, 'out'],
        ['note_on', 0, 1, 59, 75],
        ['note_on', 0, 1, 62, 75],
        ['note_on', 0, 1, 65, 75],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 0, 'side '],
        ['note_on', 0, 1, 59, 75],
        ['note_on', 0, 1, 62, 75],
        ['note_on', 0, 1, 65, 75],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 0, 'U. '],
        ['note_on', 0, 1, 59, 75],
        ['note_on', 0, 1, 62, 75],
        ['note_on', 0, 1, 65, 75],
        ['note_on', 128, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 0, 'S. '],
        ['note_on', 0, 1, 59, 78],
        ['note_on', 0, 1, 62, 78],
        ['note_on', 0, 1, 65, 78],
        ['note_on', 256, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 1, 59, 81],
        ['note_on', 0, 1, 62, 81],
        ['note_on', 0, 1, 65, 81],
        ['note_on', 384, 1, 59, 0],
        ['note_on', 0, 1, 62, 0],
        ['note_on', 0, 1, 65, 0],
        ['lyric', 256, 'in'],
        ['note_on', 0, 1, 60, 68],
        ['note_on', 0, 1, 64, 68],
        ['note_on', 0, 1, 67, 68],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side, '],
        ['note_on', 0, 1, 60, 76],
        ['note_on', 0, 1, 64, 76],
        ['note_on', 0, 1, 67, 76],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'out'],
        ['note_on', 0, 1, 60, 81],
        ['note_on', 0, 1, 64, 81],
        ['note_on', 0, 1, 67, 81],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side '],
        ['note_on', 0, 1, 60, 74],
        ['note_on', 0, 1, 64, 74],
        ['note_on', 0, 1, 67, 74],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'U. '],
        ['note_on', 0, 1, 60, 75],
        ['note_on', 0, 1, 64, 75],
        ['note_on', 0, 1, 67, 75],
        ['note_on', 128, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'S. '],
        ['note_on', 0, 1, 60, 74],
        ['note_on', 0, 1, 64, 74],
        ['note_on', 0, 1, 67, 74],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 1, 60, 76],
        ['note_on', 0, 1, 64, 76],
        ['note_on', 0, 1, 67, 76],
        ['note_on', 384, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 256, 'in'],
        ['note_on', 0, 1, 60, 69],
        ['note_on', 0, 1, 65, 69],
        ['note_on', 0, 1, 69, 69],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 0, 'side, '],
        ['note_on', 0, 1, 60, 78],
        ['note_on', 0, 1, 65, 78],
        ['note_on', 0, 1, 69, 78],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 0, 'out'],
        ['note_on', 0, 1, 60, 72],
        ['note_on', 0, 1, 65, 72],
        ['note_on', 0, 1, 69, 72],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 0, 'side '],
        ['note_on', 0, 1, 60, 74],
        ['note_on', 0, 1, 65, 74],
        ['note_on', 0, 1, 69, 74],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 0, 'U. '],
        ['note_on', 0, 1, 60, 77],
        ['note_on', 0, 1, 65, 77],
        ['note_on', 0, 1, 69, 77],
        ['note_on', 128, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 0, 'S. '],
        ['note_on', 0, 1, 60, 76],
        ['note_on', 0, 1, 65, 76],
        ['note_on', 0, 1, 69, 76],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 0, 'A. '],
        ['note_on', 0, 1, 60, 76],
        ['note_on', 0, 1, 65, 76],
        ['note_on', 0, 1, 69, 76],
        ['note_on', 384, 1, 60, 0],
        ['note_on', 0, 1, 65, 0],
        ['note_on', 0, 1, 69, 0],
        ['lyric', 256, 'in'],
        ['note_on', 0, 1, 60, 71],
        ['note_on', 0, 1, 64, 71],
        ['note_on', 0, 1, 67, 71],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side, '],
        ['note_on', 0, 1, 60, 74],
        ['note_on', 0, 1, 64, 74],
        ['note_on', 0, 1, 67, 74],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'out'],
        ['note_on', 0, 1, 60, 76],
        ['note_on', 0, 1, 64, 76],
        ['note_on', 0, 1, 67, 76],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['lyric', 0, 'side '],
        ['note_on', 0, 1, 60, 77],
        ['note_on', 0, 1, 64, 77],
        ['note_on', 0, 1, 67, 77],
        ['note_on', 256, 1, 60, 0],
        ['note_on', 0, 1, 64, 0],
        ['note_on', 0, 1, 67, 0],
        ['note_on', 256, 1, 60, 71],
        ['note_on', 128, 1, 60, 0],
        ['note_on', 0, 1, 60, 76],
        ['note_on', 128, 1, 60, 0],
        ['note_on', 0, 1, 64, 82],
        ['note_on', 128, 1, 64, 0],
        ['note_on', 0, 1, 64, 79],
        ['note_on', 128, 1, 64, 0],
        ['note_on', 0, 1, 67, 82],
        ['note_on', 256, 1, 67, 0],
        ['note_on', 0, 1, 65, 76],
        ['note_on', 384, 1, 65, 0],
        ['note_on', 0, 1, 62, 70],
        ['note_on', 640, 1, 62, 0],
        ['note_on', 256, 1, 65, 71],
        ['note_on', 128, 1, 65, 0],
        ['note_on', 0, 1, 65, 73],
        ['note_on', 128, 1, 65, 0],
        ['note_on', 0, 1, 64, 69],
        ['note_on', 128, 1, 64, 0],
        ['note_on', 0, 1, 62, 68],
        ['note_on', 256, 1, 62, 0],
        ['note_on', 0, 1, 60, 69],
        ['note_on', 1152, 1, 60, 0],
        ['text_event', 1, ''],
      ]
    }),
    
  ]
});
