#
# Create BAD_demo.pm
# - needed since we allow bad pixel handling to be switched off
#
 
use strict;
 
use Config;
use File::Basename qw(&basename &dirname);
 
# check for bad value support
use PDL::Config;
my $bvalflag = $PDL::Config{WITH_BADVAL} || 0;
 
# This forces PL files to create target in same directory as PL file.
# This is so that make depend always knows where to find PL derivatives.
chdir(dirname($0));
my $file;
($file = basename($0)) =~ s/\.PL$//;
$file =~ s/\.pl$//
        if ($Config{'osname'} eq 'VMS' or
            $Config{'osname'} eq 'OS2');  # "case-forgiving"
open OUT,">$file" or die "Can't create $file: $!";
 
if ( $bvalflag ) {
    print "Extracting $file (WITH bad value support)\n";
} else {
    print "Extracting $file (NO bad value support)\n";
}
chmod 0644, $file;
 
print OUT <<'!NO!SUBS!';
#
# Created by BAD_demo.pm.PL
#  ** DO NOT EDIT THIS FILE **
#
package PDL::Demos::BAD_demo;
use PDL;

PDL::Demos::Routines->import();
sub comment($);
sub act($);
sub output;

sub run {

!NO!SUBS!

    if ( ! $bvalflag ) {
	print OUT <<'!NO!SUBS!';

comment q|

    Your version of PDL has been compiled without support for bad
    values, hence this demo doesn't do anything.

|;

!NO!SUBS!

#'

} else {
    print OUT <<'!NO!SUBS!';

comment q|
    Welcome to this tour of the bad value support in PDL

    Each piddle contains a flag - accessible via the badflag() method - 
    which indicates whether:

       the piddle contains no bad values (flag equals 0)
       the piddle *MAY* contain bad values (flag equals 1)

    If the flag is set, then the routines (well, those that have been
    converted) will process these bad values correctly, otherwise they 
    are ignored. 

    The code has been written so as to provide as little overhead as
    possible; therefore there should be almost no difference in the
    time it takes to process piddles which do not have their bad flag 
    set.

|;

act q|

    # There are 2 ways to see whether bad-value support has been
    # compiled into your perldl:
    print("You can use bad values.\n") if $PDL::Bad::Status;

    # or
    use PDL::Config;
    print("You can stil use bad values.\n") if $PDL::Config{WITH_BADVAL};

    # note that PDL::Bad is included by default when you use 
    # 'use PDL', 'use PDL::Lite', or 'use PDL::LiteF'

|;

act q|

    # create a piddle
    $a = byte(1,2,3);
    print( "Bad flag (a) == ", $a->badflag(), "\n" );

    # set bad flag, even though all the data is good
    $a->badflag(1);
    print( "Bad flag (a) == ", $a->badflag(), "\n" );

    # note the bad flag is infectious
    $b = 2 * $a;
    print( "Bad flag (b) == ", $b->badflag(), "\n\n" );

|;

act q|

    # the badflag is also included in the state info of
    # piddle
    #
    $c = pdl(2,3); # just a piddle without the badflag set

    print "   Type   Dimension        State          Mem\n";
    print "-------------------------------------------------\n";
    print "a ", $a->info("%-6T %-15D   %-5S  %12M"), "\n";
    print "b ", $b->info("%-6T %-15D   %-5S  %12M"), "\n";
    print "c ", $c->info("%-6T %-15D   %-5S  %12M"), "\n\n";
|;

act q|

    print "No bad values:   $a\n";
    # set the middle value bad
    $a->setbadat(1);

    # now print out
    print "Some bad values: $a\n";
    print "b contains:      $b\n";
    $c = $a + $b;
    print "so a + b =       $c\n\n";

|;

act q|

    # The module PDL::Bad contains a number of routines designed
    # to make using bad values easy.
    print "a contains ", $a->nbad, " bad elements.\n";
    print "The bad value for type #",$a->get_datatype," is ",$a->badvalue,"\n";
    print "It is easy to find whether a value is good: ", isgood($a), "\n\n";

    print "or to remove the bad values\n";
    $a->inplace->setbadtoval(23);
    print "a = $a and \$a->badflag == ", $a->badflag, "\n\n";

|;

act q|

    print "We can even label certain values as bad!\n";
    $a = sequence(3,3);
    $a = $a->setbadif( $a % 2 ); # unfortunately can not be done inplace
    print $a;

|;

act q|

    # the issue of how to cope with dataflow is not fully resolved. At
    # present, if you change the badflag of a piddle, all its children
    # are also changed:
    $a = sequence( byte, 2, 3 );
    $a = $a->setbadif( $a == 3 );
    $b = $a->slice("(1),:");
    print "b = $b\tbadflag = ", $b->badflag, "\n";

    $a->inplace->setbadtoval(3);
    print "b = $b\tbadflag = ", $b->badflag, "\n\n";

|;

act q|

    # Note that "boolean" operators return a bad value if either of the
    # operands are bad: one way around this is to replace all bad values
    # by 0 or 1. 

    $a = sequence(3,3); $a = $a->setbadif( $a % 2 );
    print $a > 5;
    print setbadtoval($a > 5,0);  # set all bad values to false

|;

act q|
    # One area that is likely to cause confusion is the return value from
    # comparison operators (e.g. all and any) when ALL elements are bad.

    # Currently, the bad value is returned; however most code will not
    # be aware of this and just see it as a true or false value (depending
    # on the numerical value used to store bad values).

    # There is also the fact that the bad value need not relate to the
    # type of the input piddle (due to internal conversion to an 'int +').
    
    $a = ones(3); $a = $a->setbadif( $a == 1 );
    print "Any returns: ", any( $a > 2 ), "\n";
    print "which is the bad value of 'long' (", long->badvalue, ").\n";

    print "Whereas the bad value for \$a is: ", $a->badvalue, "\n";

|;

comment q|
    Many of the 'core' routines have been converted to handle bad values.
    However, some (including most of the additional modules) have not,
    either because it does not make sense or its too much work to do! 

    To find out the status of a particular routine, use the 'badinfo'
    command in perldl (this information is also included when you do
    'help'), or the '-b' switch of pdldoc.

|;

!NO!SUBS!

} # if: $bvalflag

print OUT <<'!NO!SUBS!';

}

1;

!NO!SUBS!

# end
