use Forks::Super ':test_config';
use POSIX ':sys_wait_h';
use Test::More tests => 15;
use strict;
use warnings;
$| = 1;

#
# test that a "natural" fork call behaves the same way
# as the Perl system fork call.
#

# verify every step of the life-cycle of a child process

my $pid = fork;
ok(defined $pid, "pid defined after fork") if $$==$Forks::Super::MAIN_PID;

if ($pid == 0) {
  sleep 2;
  Forks::Super::child_exit 1;
}
ok(isValidPid($pid), "pid $pid shows child proc");
ok($$ == $Forks::Super::MAIN_PID, "parent pid $$ is current pid");
my $job = Forks::Super::Job::get($pid);
ok(defined $job, "got Forks::Super::Job object $job");
ok($job->{style} eq "natural", "natural style");
ok($job->{state} eq "ACTIVE", "active state");
my $waitpid = waitpid($pid,WNOHANG);
ok(-1 == $waitpid, "non-blocking wait succeeds");
ok(! defined $job->{status}, "no job status");
Forks::Super::pause(3);
ok($job->{state} eq "COMPLETE", "job state is COMPLETE");
ok(defined $job->{status}, "job status defined");
ok($? != $job->{status}, "job status not available yet");
my $p = waitpid $pid,0;
ok($job->{state} eq "REAPED", "job status REAPED after waitpid");
ok($p == $pid, "reaped correct pid");
ok($? == 256, "system status is correct");
ok($? == $job->{status}, "captured correct job status");

#########################################################

# run Forks::Super::CONFIG on some values that we might use.
# Whether these items are configured or not will be displayed
# with the test output.
# it doesn't matter whether any of these fail,

Forks::Super::CONFIG("Time::HiRes");
Forks::Super::CONFIG("Win32");
Forks::Super::CONFIG("SIGUSR1");
Forks::Super::CONFIG("getpgrp");
Forks::Super::CONFIG("alarm");
Forks::Super::CONFIG("filehandles");
Forks::Super::CONFIG("/bin/taskset");
Forks::Super::CONFIG("BSD::Process::Affinity");

__END__
-------------------------------------------------------

Feature:	ordinary fork

What to test:	behavior is the same as CORE::fork()
		child process has different $$

-------------------------------------------------------
