use strict;
use warnings;

package Perl::Critic::Tics;

=head1 NAME

Perl::Critic::Tics - policies for things that make me wince

=head1 VERSION

version 0.005

=cut

our $VERSION = '0.005';

=head1 DESCRIPTION

The Perl-Critic-Tics distribution includes extra policies for Perl::Critic to
address a fairly random assortment of things that make me (rjbs) wince.

=head1 WHY TICS?

Take your pick:

=over

=item B<T>hings B<I> B<C>an't B<S>tand

=item They set off my nervous tic.

=back

=head1 SEE ALSO

L<Perl::Critic>, the driving force behind it all.  L<Perl::Critic::Lax>, the
other half of things I don't like: things I don't like about core Perl::Critic
rules.

Other people have released their own tics:

=over

=item * L<Perl::Critic::Bangs>

=item * L<Perl::Critic::Swift>

=back

=head1 AUTHOR

Ricardo SIGNES <rjbs@cpan.org>

=head1 COPYRIGHT

Copyright (c) 2007 Ricardo SIGNES.

This program is free software; you can redistribute it and/or modify it under
the same terms as Perl itself.

=cut

1;
