/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2205 from the
 * contents of API.xs. Do not edit this file, edit API.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "API.xs"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <stdio.h>

#include "ppport.h"

#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#if LUA_VERSION_NUM < 501

#error "This requires at least version 5.1 of Lua"

#endif

#include "const-c.inc"

#define MY_CXT_KEY "Lua::API::_guts" XS_VERSION

typedef struct {
    HV *OOB;
} my_cxt_t;

START_MY_CXT


/*-------------------------------------------------------------------*/
/* Support for out-of-band data

   Lua interfaces to C functions, not Perl ones, and they must be
   declared at compile time (can't create them on the fly) so we
   use trampoline C functions to call Perl.  Sometimes its possible
   to attach routing information (via Lua C closures) so that the
   trampoline knows which Perl function to call.  Sometimes its not.

   In the latter case, for certain classes of uses (such as hooks) we
   can deduce which Perl function to call based upon some extra piece
   of data needs to be stored somewhere.  This provides that facility.

   We keep track of the out-of-band data in a Perl hash, keyed off of
   a pointer address (like an inside-out object). We could
   have created a LuaInterpreter Object which contains both the
   lua_State pointer and any other instance specific data, but that
   makes using the automated XS calling of Lua functions much more
   messy.

*/

/* The OOB hash stores data keyed off of a pointer.  Its values are
   hashes */

static
HV* get_oob_entry( void *ptr )
{
    dMY_CXT;
    HV* oob;

    {
	SV ** svp = hv_fetch( MY_CXT.OOB, (const char*) &ptr, sizeof(ptr), 1 );
	if ( svp == NULL )
	    croak( "Perl Lua::API: error getting OOB hash\n" );

	/* if not defined, has not yet been created; do so */
	if ( ! SvOK( *svp) )
	{
	    HV *t_hv = newHV();
	    SV *t_rv = newRV_inc( (SV*) t_hv );
	    svp = hv_store( MY_CXT.OOB, (const char*) &ptr, sizeof(ptr), t_rv, 0);
	}

	oob = (HV*) SvRV(*svp);

	if ( SVt_PVHV != SvTYPE(oob) )
	    croak( "Perl Lua::API: OOB entry  %p is not a hash\n", (void *) ptr );
    }

    return oob;
}

static
SV * delete_oob_entry( void *ptr )
{
    dMY_CXT;

    return hv_delete( MY_CXT.OOB, (const char*) &ptr, sizeof(ptr), 0 );
}


/*-------------------------------------------------------------------*/
/* Mapping lua_State* to Lua::API::State objects

   When Lua calls the trampolines, its passes in a lua_State*.  Perl,
   however, wants a Lua::API::State object.  We could create them on the
   fly from the lua_State* (since there's nothing in the Lua::API::State
   object but a lua_State*), but then Lua::API::State::DESTROY would get
   called whenever the temporary objects are destroyed, which
   is not good.

   Instead, we keep track of the original Lua::API::State object in the OOB
   hash.
 */

static
SV* get_Perl_object( void *ptr )
{
    SV** svp = hv_fetch( get_oob_entry( ptr ), "object", 5, 0 );
    if ( svp == NULL )
	croak( "Perl Lua::API::get_Perl_object: error getting object\n" );

    return *svp;
}

static
void set_Perl_object( void *ptr, SV* object )
{
    HV* oob = get_oob_entry( ptr );
    SV** svp = hv_fetch( oob, "object", 5, 1 );

    if ( svp == NULL )
	croak( "Perl Lua::API::set_Perl_object: error getting object\n" );

    sv_setsv( *svp, object );
}

/*-------------------------------------------------------------------*/
/* Support for hooks */


static
void set_hook( lua_State *L, SV* func )
{
    HV* oob = get_oob_entry( L );
    SV** svp = hv_fetch( oob, "hook", 4, 1 );

    if ( svp == NULL )
	croak( "Perl Lua::API: error getting hook\n" );

    if ( SvOK(func) )
    {
	sv_setsv( *svp, func );
    }

    else
    {
	hv_delete( oob, "hook", 4, G_DISCARD );
    }
}

/* trampoline */
static
void l2p_hook( lua_State *L, lua_Debug *ar )
{
    SV** svp;
    HV* oob = get_oob_entry( L );
    SV* hook;
    SV* rv;
    SV* sv;
    dSP;

    svp = hv_fetch( oob, "hook", 4, 0 );
    if ( svp == NULL )
	croak( "Perl Lua::API: error getting hook\n" );
    hook = *svp;

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);

    XPUSHs(get_Perl_object(L));
    XPUSHs(get_Perl_object(ar));

    PUTBACK;

    call_sv( hook, G_DISCARD );

    FREETMPS;
    LEAVE;
}


/*-------------------------------------------------------------------*/
/* Support for pushcfunction and pushcclosure.
 *
 * The SV pointer is stored as the *last* upvalue for the trampoline
 * routine.  Perl routines which use lua_Debug.nups to get the number
 * of upvalues must decrement it by one to get their true upvalue
 * count.
 *
 */

static
int l2p_closure( lua_State *L )
{
    dSP;
    SV *func;
    int count;
    lua_Debug ar;

    lua_getstack( L, 0, &ar );

    lua_getinfo( L, "u", &ar );

    func = (SV*) lua_touserdata( L, lua_upvalueindex( ar.nups ) );

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);

    XPUSHs(get_Perl_object(L));

    PUTBACK;

    count = call_sv( func, G_SCALAR);

    FREETMPS;
    LEAVE;

    return count;
}

/*-------------------------------------------------------------------*/
/* Support for lua_cpcall.
 *
 * lua_cpcall calls a C function directly with a lightuserdata value
 * on the stack. We can't use a closure to wrap the Perl SV, so, we
 * wrap it explicitly in a structure.  This is the trampoline routine
 * which unwraps it and calls the Perl routine
 *
 */

typedef struct {
    SV *sv;    /* Perl function to call */
    void *ud;  /* user data pointer */
} CPCallData;

static
int l2p_cpcall( lua_State *L ) {
    dSP;
    int count;
    CPCallData *data;


    /* grab our structure... */
    data = (CPCallData *) lua_touserdata( L, -1 );

    /* ...remove it from the stack */
    lua_pop( L, 1 );

    /* ...and replace it with the user data */
    lua_pushlightuserdata( L, data->ud );

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);

    XPUSHs(get_Perl_object(L));
    PUTBACK;

    count = call_sv( (SV*) data->sv, G_DISCARD);

    FREETMPS;
    LEAVE;

    return count;
}


/*-------------------------------------------------------------------*/

#line 284 "API.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 336 "API.c"

/* INCLUDE:  Including 'const-xs.inc' from 'API.xs' */


XS(XS_Lua__API_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API_constant)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 4 "./const-xs.inc"
#ifdef dXSTARG
	dXSTARG; /* Faster if we have it.  */
#else
	dTARGET;
#endif
	STRLEN		len;
        int		type;
	IV		iv;
	/* NV		nv;	Uncomment this if you need to return NVs */
	/* const char	*pv;	Uncomment this if you need to return PVs */
#line 365 "API.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
#line 18 "./const-xs.inc"
        /* Change this to constant(aTHX_ s, len, &iv, &nv);
           if you need to return both NVs and IVs */
	type = constant(aTHX_ s, len, &iv);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv =
	    sv_2mortal(newSVpvf("%s is not a valid Lua::API macro", s));
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined Lua::API macro %s, used",
				   s));
          PUSHs(sv);
          break;
        case PERL_constant_ISIV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHi(iv);
          break;
	/* Uncomment this if you need to return NOs
        case PERL_constant_ISNO:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_no);
          break; */
	/* Uncomment this if you need to return NVs
        case PERL_constant_ISNV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHn(nv);
          break; */
	/* Uncomment this if you need to return PVs
        case PERL_constant_ISPV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, strlen(pv));
          break; */
	/* Uncomment this if you need to return PVNs
        case PERL_constant_ISPVN:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, iv);
          break; */
	/* Uncomment this if you need to return SVs
        case PERL_constant_ISSV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break; */
	/* Uncomment this if you need to return UNDEFs
        case PERL_constant_ISUNDEF:
          break; */
	/* Uncomment this if you need to return UVs
        case PERL_constant_ISUV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHu((UV)iv);
          break; */
	/* Uncomment this if you need to return YESs
        case PERL_constant_ISYES:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_yes);
          break; */
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing Lua::API macro %s, used",
               type, s));
          PUSHs(sv);
        }
#line 442 "API.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'API.xs' from 'const-xs.inc' */


XS(XS_Lua__API_RELEASE); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API_RELEASE)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;
#line 289 "API.xs"
        RETVAL = LUA_RELEASE;
#line 467 "API.c"
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API_COPYRIGHT); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API_COPYRIGHT)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;
#line 296 "API.xs"
        RETVAL = LUA_COPYRIGHT;
#line 489 "API.c"
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_atpanic); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_atpanic)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, panicf");
    {
	lua_State *	L;
	lua_CFunction	panicf;
	lua_CFunction	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::atpanic",
                        "L", "Lua::API::State");

	if (sv_derived_from(ST(1), "lua_CFunction")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    panicf = INT2PTR(lua_CFunction,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Lua::API::State::atpanic",
			"panicf", "lua_CFunction");

	RETVAL = lua_atpanic(L, panicf);
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "lua_CFunction", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_call); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_call)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, nargs, nresults");
    {
	lua_State *	L;
	int	nargs = (int)SvIV(ST(1));
	int	nresults = (int)SvIV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::call",
                        "L", "Lua::API::State");

	lua_call(L, nargs, nresults);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_checkstack); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checkstack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "L, sz, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	lua_State *	L;
	int	sz = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checkstack",
                        "L", "Lua::API::State");
#line 320 "API.xs"
	  /* call lua_checkstack */
	  if ( items == 0 )
	  {
	    int status = lua_checkstack( L, sz );
            EXTEND(SP, 1);
            PUSHs(sv_2mortal(newSViv(status)));
	  }
	  /* call luaL_checkstack */
	  else if ( items == 1 )
	  {
	    const char *msg = (const char*) SvPV_nolen(ST(2));
	    luaL_checkstack( L, sz, msg );
	  }
	  else
	  {
	    croak_xs_usage( cv, "L,sz,[msg]" );
	  }
#line 609 "API.c"
	PUTBACK;
	return;
    }
}


XS(XS_Lua__API__State_concat); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_concat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, n");
    {
	lua_State *	L;
	int	n = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::concat",
                        "L", "Lua::API::State");

	lua_concat(L, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_cpcall); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_cpcall)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, func, ud");
    {
	lua_State *	L;
	SV *	func = ST(1);
	SV *	ud = ST(2);
#line 354 "API.xs"
	CPCallData data = { func, ud };
#line 661 "API.c"
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::cpcall",
                        "L", "Lua::API::State");
#line 356 "API.xs"
	RETVAL = lua_cpcall( L, l2p_cpcall, &data );
#line 675 "API.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_createtable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_createtable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, narr, nrec");
    {
	lua_State *	L;
	int	narr = (int)SvIV(ST(1));
	int	nrec = (int)SvIV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::createtable",
                        "L", "Lua::API::State");

	lua_createtable(L, narr, nrec);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_equal); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_equal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx1, idx2");
    {
	lua_State *	L;
	int	idx1 = (int)SvIV(ST(1));
	int	idx2 = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::equal",
                        "L", "Lua::API::State");

	RETVAL = lua_equal(L, idx1, idx2);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_gc); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_gc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, what, data");
    {
	lua_State *	L;
	int	what = (int)SvIV(ST(1));
	int	data = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::gc",
                        "L", "Lua::API::State");

	RETVAL = lua_gc(L, what, data);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getallocf); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getallocf)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, ud");
    {
	lua_State *	L;
	void **	ud;
	lua_Alloc	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getallocf",
                        "L", "Lua::API::State");

	if (sv_derived_from(ST(1), "voidPtrPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    ud = INT2PTR(void **,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Lua::API::State::getallocf",
			"ud", "voidPtrPtr");

	RETVAL = lua_getallocf(L, ud);
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "lua_Alloc", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getfenv); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getfenv)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getfenv",
                        "L", "Lua::API::State");

	lua_getfenv(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_getfield); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getfield)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx, k");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	const char *	k = (const char *)SvPV_nolen(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getfield",
                        "L", "Lua::API::State");

	lua_getfield(L, idx, k);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_getgccount); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getgccount)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getgccount",
                        "L", "Lua::API::State");

	RETVAL = lua_getgccount(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getglobal); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getglobal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, name");
    {
	lua_State *	L;
	const char *	name = (const char *)SvPV_nolen(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getglobal",
                        "L", "Lua::API::State");

	lua_getglobal(L, name);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_gethook); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_gethook)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	lua_Hook	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::gethook",
                        "L", "Lua::API::State");

	RETVAL = lua_gethook(L);
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "lua_Hook", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_gethookcount); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_gethookcount)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::gethookcount",
                        "L", "Lua::API::State");

	RETVAL = lua_gethookcount(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_gethookmask); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_gethookmask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::gethookmask",
                        "L", "Lua::API::State");

	RETVAL = lua_gethookmask(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getinfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getinfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, what, ar");
    {
	lua_State *	L;
	const char *	what = (const char *)SvPV_nolen(ST(1));
	lua_Debug *	ar;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getinfo",
                        "L", "Lua::API::State");

	if (sv_derived_from(ST(2), "Lua::API::State")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(2)), len);

	    if (len != sizeof(ar))
		croak("Size %d of packed data != expected %d",
			len, sizeof(ar));
	    ar = *(lua_Debug * *)s;
	}
	else
	    croak("ar is not of type Lua::API::State");

	RETVAL = lua_getinfo(L, what, ar);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getlocal); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getlocal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, ar, n");
    {
	lua_State *	L;
	const lua_Debug *	ar;
	int	n = (int)SvIV(ST(2));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getlocal",
                        "L", "Lua::API::State");

	if (sv_derived_from(ST(1), "Lua::API::State")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(1)), len);

	    if (len != sizeof(ar))
		croak("Size %d of packed data != expected %d",
			len, sizeof(ar));
	    ar = *(const lua_Debug * *)s;
	}
	else
	    croak("ar is not of type Lua::API::State");

	RETVAL = lua_getlocal(L, ar, n);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getmetatable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getmetatable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "L, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	lua_State *	L;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getmetatable",
                        "L", "Lua::API::State");
#line 440 "API.xs"
	if ( items != 1 )
	    croak_xs_usage( cv, "L,(objindex|name)" );
	if ( looks_like_number( ST(1) ) )
	{
	    int	objindex = (int)SvIV(ST(1));
	    int RETVAL = lua_getmetatable(L, objindex);
	    EXTEND(SP,1);
	    PUSHs(sv_2mortal(newSViv(RETVAL)));
	}
        else
	{
	    const char *n = (const char *)SvPV_nolen(ST(1));
	    luaL_getmetatable(L, n);
	    XSRETURN_EMPTY;
	}
#line 1160 "API.c"
	PUTBACK;
	return;
    }
}


XS(XS_Lua__API__State_getregistry); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getregistry)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getregistry",
                        "L", "Lua::API::State");

	lua_getregistry(L);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_getstack); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getstack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, level, ar");
    {
	lua_State *	L;
	int	level = (int)SvIV(ST(1));
	lua_Debug *	ar;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getstack",
                        "L", "Lua::API::State");

	if (sv_derived_from(ST(2), "Lua::API::State")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(2)), len);

	    if (len != sizeof(ar))
		croak("Size %d of packed data != expected %d",
			len, sizeof(ar));
	    ar = *(lua_Debug * *)s;
	}
	else
	    croak("ar is not of type Lua::API::State");

	RETVAL = lua_getstack(L, level, ar);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_gettable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_gettable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::gettable",
                        "L", "Lua::API::State");

	lua_gettable(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_gettop); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_gettop)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::gettop",
                        "L", "Lua::API::State");

	RETVAL = lua_gettop(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getupvalue); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getupvalue)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, funcindex, n");
    {
	lua_State *	L;
	int	funcindex = (int)SvIV(ST(1));
	int	n = (int)SvIV(ST(2));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getupvalue",
                        "L", "Lua::API::State");

	RETVAL = lua_getupvalue(L, funcindex, n);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_insert); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_insert)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::insert",
                        "L", "Lua::API::State");

	lua_insert(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_isboolean); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isboolean)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isboolean",
                        "L", "Lua::API::State");

	RETVAL = lua_isboolean(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_iscfunction); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_iscfunction)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::iscfunction",
                        "L", "Lua::API::State");

	RETVAL = lua_iscfunction(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isfunction); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isfunction)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isfunction",
                        "L", "Lua::API::State");

	RETVAL = lua_isfunction(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_islightuserdata); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_islightuserdata)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::islightuserdata",
                        "L", "Lua::API::State");

	RETVAL = lua_islightuserdata(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isnil); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isnil)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isnil",
                        "L", "Lua::API::State");

	RETVAL = lua_isnil(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isnone); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isnone)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isnone",
                        "L", "Lua::API::State");

	RETVAL = lua_isnone(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isnoneornil); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isnoneornil)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isnoneornil",
                        "L", "Lua::API::State");

	RETVAL = lua_isnoneornil(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isnumber); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isnumber)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isnumber",
                        "L", "Lua::API::State");

	RETVAL = lua_isnumber(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isstring",
                        "L", "Lua::API::State");

	RETVAL = lua_isstring(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_istable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_istable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::istable",
                        "L", "Lua::API::State");

	RETVAL = lua_istable(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isthread); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isthread)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isthread",
                        "L", "Lua::API::State");

	RETVAL = lua_isthread(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_isuserdata); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_isuserdata)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::isuserdata",
                        "L", "Lua::API::State");

	RETVAL = lua_isuserdata(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_lessthan); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_lessthan)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx1, idx2");
    {
	lua_State *	L;
	int	idx1 = (int)SvIV(ST(1));
	int	idx2 = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::lessthan",
                        "L", "Lua::API::State");

	RETVAL = lua_lessthan(L, idx1, idx2);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_newtable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_newtable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::newtable",
                        "L", "Lua::API::State");

	lua_newtable(L);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_newthread); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_newthread)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	lua_State *	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::newthread",
                        "L", "Lua::API::State");

	RETVAL = lua_newthread(L);
	ST(0) = sv_newmortal();
        sv_setref_iv(ST(0), "Lua::API::State", PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_newuserdata); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_newuserdata)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, sz");
    {
	lua_State *	L;
	size_t	sz = (size_t)SvUV(ST(1));
	void *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::newuserdata",
                        "L", "Lua::API::State");

	RETVAL = lua_newuserdata(L, sz);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_next); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_next)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::next",
                        "L", "Lua::API::State");

	RETVAL = lua_next(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_objlen); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_objlen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	size_t	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::objlen",
                        "L", "Lua::API::State");

	RETVAL = lua_objlen(L, idx);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_pcall); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pcall)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, nargs, nresults, errfunc");
    {
	lua_State *	L;
	int	nargs = (int)SvIV(ST(1));
	int	nresults = (int)SvIV(ST(2));
	int	errfunc = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pcall",
                        "L", "Lua::API::State");

	RETVAL = lua_pcall(L, nargs, nresults, errfunc);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_pop); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pop)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pop",
                        "L", "Lua::API::State");

	lua_pop(L, index);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushboolean); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushboolean)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, b");
    {
	lua_State *	L;
	int	b = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushboolean",
                        "L", "Lua::API::State");

	lua_pushboolean(L, b);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushcclosure); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushcclosure)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, fn, n");
    {
	lua_State *	L;
	SV *	fn = ST(1);
	int	n = (int)SvIV(ST(2));
#line 620 "API.xs"
	SV *sv_c = newSVsv(fn);
#line 2042 "API.c"

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushcclosure",
                        "L", "Lua::API::State");
#line 622 "API.xs"
        lua_pushlightuserdata(L, sv_c );
        lua_pushcclosure(L, l2p_closure, n+1 );
#line 2055 "API.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushcfunction); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushcfunction)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, f");
    {
	lua_State *	L;
	SV *	f = ST(1);
#line 630 "API.xs"
	SV *sv_c = newSVsv(f);
#line 2076 "API.c"

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushcfunction",
                        "L", "Lua::API::State");
#line 632 "API.xs"
        lua_pushlightuserdata(L, sv_c );
        lua_pushcclosure(L, l2p_closure, 1 );
#line 2089 "API.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushinteger); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushinteger)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, n");
    {
	lua_State *	L;
	lua_Integer	n = (lua_Integer)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushinteger",
                        "L", "Lua::API::State");

	lua_pushinteger(L, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushlightuserdata); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushlightuserdata)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, p");
    {
	lua_State *	L;
	void *	p = INT2PTR(void *,SvIV(ST(1)));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushlightuserdata",
                        "L", "Lua::API::State");

	lua_pushlightuserdata(L, p);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushlstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushlstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, s, l");
    {
	lua_State *	L;
	const char *	s = (const char *)SvPV_nolen(ST(1));
	size_t	l = (size_t)SvUV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushlstring",
                        "L", "Lua::API::State");

	lua_pushlstring(L, s, l);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushliteral); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushliteral)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, s");
    {
	lua_State *	L;
	const char *	s = (const char *)SvPV_nolen(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushliteral",
                        "L", "Lua::API::State");
#line 663 "API.xs"
         lua_pushlstring(L,s,strlen(s));
#line 2207 "API.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushnil); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushnil)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushnil",
                        "L", "Lua::API::State");

	lua_pushnil(L);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushnumber); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushnumber)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, n");
    {
	lua_State *	L;
	lua_Number	n = (double)SvNV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushnumber",
                        "L", "Lua::API::State");

	lua_pushnumber(L, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, s");
    {
	lua_State *	L;
	const char *	s = (const char *)SvPV_nolen(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushstring",
                        "L", "Lua::API::State");

	lua_pushstring(L, s);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_pushthread); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushthread)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushthread",
                        "L", "Lua::API::State");

	RETVAL = lua_pushthread(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_pushvalue); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_pushvalue)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::pushvalue",
                        "L", "Lua::API::State");

	lua_pushvalue(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_rawequal); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_rawequal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx1, idx2");
    {
	lua_State *	L;
	int	idx1 = (int)SvIV(ST(1));
	int	idx2 = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::rawequal",
                        "L", "Lua::API::State");

	RETVAL = lua_rawequal(L, idx1, idx2);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_rawget); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_rawget)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::rawget",
                        "L", "Lua::API::State");

	lua_rawget(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_rawgeti); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_rawgeti)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx, n");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	n = (int)SvIV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::rawgeti",
                        "L", "Lua::API::State");

	lua_rawgeti(L, idx, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_rawset); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_rawset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::rawset",
                        "L", "Lua::API::State");

	lua_rawset(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_rawseti); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_rawseti)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx, n");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	n = (int)SvIV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::rawseti",
                        "L", "Lua::API::State");

	lua_rawseti(L, idx, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_remove); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_remove)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::remove",
                        "L", "Lua::API::State");

	lua_remove(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_replace); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_replace)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::replace",
                        "L", "Lua::API::State");

	lua_replace(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_resume); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_resume)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, narg");
    {
	lua_State *	L;
	int	narg = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::resume",
                        "L", "Lua::API::State");

	RETVAL = lua_resume(L, narg);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_setfenv); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_setfenv)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setfenv",
                        "L", "Lua::API::State");

	RETVAL = lua_setfenv(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_setfield); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_setfield)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx, k");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	const char *	k = (const char *)SvPV_nolen(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setfield",
                        "L", "Lua::API::State");

	lua_setfield(L, idx, k);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_setglobal); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_setglobal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, s");
    {
	lua_State *	L;
	const char *	s = (const char *)SvPV_nolen(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setglobal",
                        "L", "Lua::API::State");

	lua_setglobal(L, s);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_sethook); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_sethook)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, func, mask, count");
    {
	lua_State *	L;
	SV *	func = ST(1);
	int	mask = (int)SvIV(ST(2));
	int	count = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::sethook",
                        "L", "Lua::API::State");
#line 770 "API.xs"
        set_hook( L, func );
	RETVAL = lua_sethook( L, SvOK(func) ? l2p_hook : NULL, mask, count );
#line 2720 "API.c"
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_setlevel); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_setlevel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "from, to");
    {
	lua_State *	from;
	lua_State *	to;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            from = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setlevel",
                        "from", "Lua::API::State");

        if (sv_derived_from(ST(1), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(1)));
            to = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setlevel",
                        "to", "Lua::API::State");

	lua_setlevel(from, to);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_setlocal); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_setlocal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, ar, n");
    {
	lua_State *	L;
	const lua_Debug *	ar;
	int	n = (int)SvIV(ST(2));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setlocal",
                        "L", "Lua::API::State");

	if (sv_derived_from(ST(1), "Lua::API::State")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(1)), len);

	    if (len != sizeof(ar))
		croak("Size %d of packed data != expected %d",
			len, sizeof(ar));
	    ar = *(const lua_Debug * *)s;
	}
	else
	    croak("ar is not of type Lua::API::State");

	RETVAL = lua_setlocal(L, ar, n);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_setmetatable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_setmetatable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, objindex");
    {
	lua_State *	L;
	int	objindex = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setmetatable",
                        "L", "Lua::API::State");

	RETVAL = lua_setmetatable(L, objindex);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_settable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_settable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::settable",
                        "L", "Lua::API::State");

	lua_settable(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_settop); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_settop)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::settop",
                        "L", "Lua::API::State");

	lua_settop(L, idx);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_setupvalue); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_setupvalue)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, funcindex, n");
    {
	lua_State *	L;
	int	funcindex = (int)SvIV(ST(1));
	int	n = (int)SvIV(ST(2));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::setupvalue",
                        "L", "Lua::API::State");

	RETVAL = lua_setupvalue(L, funcindex, n);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_status); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_status)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::status",
                        "L", "Lua::API::State");

	RETVAL = lua_status(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_strlen); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_strlen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	size_t	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::strlen",
                        "L", "Lua::API::State");

	RETVAL = lua_strlen(L, index);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_toboolean); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_toboolean)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::toboolean",
                        "L", "Lua::API::State");

	RETVAL = lua_toboolean(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_tocfunction); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_tocfunction)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	lua_CFunction	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::tocfunction",
                        "L", "Lua::API::State");

	RETVAL = lua_tocfunction(L, idx);
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "lua_CFunction", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_tointeger); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_tointeger)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	lua_Integer	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::tointeger",
                        "L", "Lua::API::State");

	RETVAL = lua_tointeger(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_tolstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_tolstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, idx, len");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	size_t	len = (size_t)SvUV(ST(2));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::tolstring",
                        "L", "Lua::API::State");

	RETVAL = lua_tolstring(L, idx, &len);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_tonumber); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_tonumber)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	lua_Number	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::tonumber",
                        "L", "Lua::API::State");

	RETVAL = lua_tonumber(L, idx);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_topointer); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_topointer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	const void *	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::topointer",
                        "L", "Lua::API::State");

	RETVAL = lua_topointer(L, idx);
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "const voidPtr", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_tostring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_tostring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::tostring",
                        "L", "Lua::API::State");

	RETVAL = lua_tostring(L, index);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_tothread); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_tothread)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	lua_State *	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::tothread",
                        "L", "Lua::API::State");

	RETVAL = lua_tothread(L, idx);
	ST(0) = sv_newmortal();
        sv_setref_iv(ST(0), "Lua::API::State", PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_touserdata); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_touserdata)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	SV *	RETVAL;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::touserdata",
                        "L", "Lua::API::State");

	RETVAL = lua_touserdata(L, idx);
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_type); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_type)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, idx");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::type",
                        "L", "Lua::API::State");

	RETVAL = lua_type(L, idx);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_typename); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_typename)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, tp");
    {
	lua_State *	L;
	int	tp = (int)SvIV(ST(1));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::typename",
                        "L", "Lua::API::State");

	RETVAL = lua_typename(L, tp);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_xmove); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_xmove)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "from, to, n");
    {
	lua_State *	from;
	lua_State *	to;
	int	n = (int)SvIV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            from = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::xmove",
                        "from", "Lua::API::State");

        if (sv_derived_from(ST(1), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(1)));
            to = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::xmove",
                        "to", "Lua::API::State");

	lua_xmove(from, to, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_yield); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_yield)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, nresults");
    {
	lua_State *	L;
	int	nresults = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::yield",
                        "L", "Lua::API::State");

	RETVAL = lua_yield(L, nresults);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_base); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_base)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_base",
                        "L", "Lua::API::State");

	RETVAL = luaopen_base(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_debug); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_debug)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_debug",
                        "L", "Lua::API::State");

	RETVAL = luaopen_debug(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_io); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_io)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_io",
                        "L", "Lua::API::State");

	RETVAL = luaopen_io(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_math); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_math)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_math",
                        "L", "Lua::API::State");

	RETVAL = luaopen_math(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_os); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_os)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_os",
                        "L", "Lua::API::State");

	RETVAL = luaopen_os(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_package); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_package)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_package",
                        "L", "Lua::API::State");

	RETVAL = luaopen_package(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_string); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_string)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_string",
                        "L", "Lua::API::State");

	RETVAL = luaopen_string(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaopen_table); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaopen_table)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaopen_table",
                        "L", "Lua::API::State");

	RETVAL = luaopen_table(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_openlibs); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_openlibs)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::openlibs",
                        "L", "Lua::API::State");

	luaL_openlibs(L);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_argcheck); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_argcheck)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, cond, numarg, extramsg");
    {
	lua_State *	L;
	int	cond = (int)SvIV(ST(1));
	int	numarg = (int)SvIV(ST(2));
	const char *	extramsg = (const char *)SvPV_nolen(ST(3));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::argcheck",
                        "L", "Lua::API::State");

	luaL_argcheck(L, cond, numarg, extramsg);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_argerror); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_argerror)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, numarg, extramsg");
    {
	lua_State *	L;
	int	numarg = (int)SvIV(ST(1));
	const char *	extramsg = (const char *)SvPV_nolen(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::argerror",
                        "L", "Lua::API::State");

	RETVAL = luaL_argerror(L, numarg, extramsg);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_buffinit); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_buffinit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, B");
    {
	lua_State *	L;
	luaL_Buffer *	B;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::buffinit",
                        "L", "Lua::API::State");

	if (sv_derived_from(ST(1), "Lua::API::State")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(1)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::State");

	luaL_buffinit(L, B);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_callmeta); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_callmeta)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, obj, e");
    {
	lua_State *	L;
	int	obj = (int)SvIV(ST(1));
	const char *	e = (const char *)SvPV_nolen(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::callmeta",
                        "L", "Lua::API::State");

	RETVAL = luaL_callmeta(L, obj, e);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checkany); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checkany)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, narg");
    {
	lua_State *	L;
	int	narg = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checkany",
                        "L", "Lua::API::State");

	luaL_checkany(L, narg);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_checkint); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checkint)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, n");
    {
	lua_State *	L;
	int	n = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checkint",
                        "L", "Lua::API::State");

	RETVAL = luaL_checkint(L, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checkinteger); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checkinteger)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, numArg");
    {
	lua_State *	L;
	int	numArg = (int)SvIV(ST(1));
	lua_Integer	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checkinteger",
                        "L", "Lua::API::State");

	RETVAL = luaL_checkinteger(L, numArg);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checklong); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checklong)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, n");
    {
	lua_State *	L;
	int	n = (int)SvIV(ST(1));
	long	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checklong",
                        "L", "Lua::API::State");

	RETVAL = luaL_checklong(L, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checklstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checklstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, numArg, l");
    {
	lua_State *	L;
	int	numArg = (int)SvIV(ST(1));
	size_t	l = (size_t)SvUV(ST(2));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checklstring",
                        "L", "Lua::API::State");

	RETVAL = luaL_checklstring(L, numArg, &l);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checknumber); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checknumber)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, numArg");
    {
	lua_State *	L;
	int	numArg = (int)SvIV(ST(1));
	lua_Number	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checknumber",
                        "L", "Lua::API::State");

	RETVAL = luaL_checknumber(L, numArg);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checkoption); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checkoption)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, narg, def, lst");
    {
	lua_State *	L;
	int	narg = (int)SvIV(ST(1));
	const char *	def = (const char *)SvPV_nolen(ST(2));
	const char * const *	lst = (const char * const *)SvPV_nolen(ST(3));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checkoption",
                        "L", "Lua::API::State");

	RETVAL = luaL_checkoption(L, narg, def, lst);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checkstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checkstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, n");
    {
	lua_State *	L;
	int	n = (int)SvIV(ST(1));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checkstring",
                        "L", "Lua::API::State");

	RETVAL = luaL_checkstring(L, n);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_checktype); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checktype)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, narg, t");
    {
	lua_State *	L;
	int	narg = (int)SvIV(ST(1));
	int	t = (int)SvIV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checktype",
                        "L", "Lua::API::State");

	luaL_checktype(L, narg, t);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_checkudata); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_checkudata)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, ud, tname");
    {
	lua_State *	L;
	int	ud = (int)SvIV(ST(1));
	const char *	tname = (const char *)SvPV_nolen(ST(2));
	void *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::checkudata",
                        "L", "Lua::API::State");

	RETVAL = luaL_checkudata(L, ud, tname);
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_dofile); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_dofile)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, fn");
    {
	lua_State *	L;
	const char *	fn = (const char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::dofile",
                        "L", "Lua::API::State");

	RETVAL = luaL_dofile(L, fn);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_dostring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_dostring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, s");
    {
	lua_State *	L;
	const char *	s = (const char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::dostring",
                        "L", "Lua::API::State");

	RETVAL = luaL_dostring(L, s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_findtable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_findtable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, idx, fname, szhint");
    {
	lua_State *	L;
	int	idx = (int)SvIV(ST(1));
	const char *	fname = (const char *)SvPV_nolen(ST(2));
	int	szhint = (int)SvIV(ST(3));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::findtable",
                        "L", "Lua::API::State");

	RETVAL = luaL_findtable(L, idx, fname, szhint);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_getmetafield); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_getmetafield)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, obj, e");
    {
	lua_State *	L;
	int	obj = (int)SvIV(ST(1));
	const char *	e = (const char *)SvPV_nolen(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::getmetafield",
                        "L", "Lua::API::State");

	RETVAL = luaL_getmetafield(L, obj, e);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_gsub); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_gsub)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, s, p, r");
    {
	lua_State *	L;
	const char *	s = (const char *)SvPV_nolen(ST(1));
	const char *	p = (const char *)SvPV_nolen(ST(2));
	const char *	r = (const char *)SvPV_nolen(ST(3));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::gsub",
                        "L", "Lua::API::State");

	RETVAL = luaL_gsub(L, s, p, r);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_loadbuffer); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_loadbuffer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, buff, sz, name");
    {
	lua_State *	L;
	const char *	buff = (const char *)SvPV_nolen(ST(1));
	size_t	sz = (size_t)SvUV(ST(2));
	const char *	name = (const char *)SvPV_nolen(ST(3));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::loadbuffer",
                        "L", "Lua::API::State");

	RETVAL = luaL_loadbuffer(L, buff, sz, name);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_loadfile); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_loadfile)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, filename");
    {
	lua_State *	L;
	const char *	filename = (const char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::loadfile",
                        "L", "Lua::API::State");

	RETVAL = luaL_loadfile(L, filename);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_loadstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_loadstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, s");
    {
	lua_State *	L;
	const char *	s = (const char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::loadstring",
                        "L", "Lua::API::State");

	RETVAL = luaL_loadstring(L, s);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_newmetatable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_newmetatable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, tname");
    {
	lua_State *	L;
	const char *	tname = (const char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::newmetatable",
                        "L", "Lua::API::State");

	RETVAL = luaL_newmetatable(L, tname);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_newstate); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_newstate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	CLASS;
	lua_State *	RETVAL;
#line 1066 "API.xs"
        RETVAL = luaL_newstate();
	ST(0) = sv_newmortal();
        sv_setref_iv(ST(0), "Lua::API::State", PTR2IV(RETVAL));
	set_Perl_object( RETVAL, ST(0) );
        XSRETURN(1);
#line 4469 "API.c"
	PUTBACK;
	return;
    }
}


XS(XS_Lua__API__State_optint); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_optint)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, n, d");
    {
	lua_State *	L;
	int	n = (int)SvIV(ST(1));
	int	d = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::optint",
                        "L", "Lua::API::State");

	RETVAL = luaL_optint(L, n, d);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_optinteger); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_optinteger)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, nArg, def");
    {
	lua_State *	L;
	int	nArg = (int)SvIV(ST(1));
	lua_Integer	def = (lua_Integer)SvIV(ST(2));
	lua_Integer	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::optinteger",
                        "L", "Lua::API::State");

	RETVAL = luaL_optinteger(L, nArg, def);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_optlong); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_optlong)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, n, d");
    {
	lua_State *	L;
	int	n = (int)SvIV(ST(1));
	long	d = (long)SvIV(ST(2));
	long	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::optlong",
                        "L", "Lua::API::State");

	RETVAL = luaL_optlong(L, n, d);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_optlstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_optlstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "L, numArg, def, l");
    {
	lua_State *	L;
	int	numArg = (int)SvIV(ST(1));
	const char *	def = (const char *)SvPV_nolen(ST(2));
	size_t	l = (size_t)SvUV(ST(3));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::optlstring",
                        "L", "Lua::API::State");

	RETVAL = luaL_optlstring(L, numArg, def, &l);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_optnumber); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_optnumber)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, nArg, def");
    {
	lua_State *	L;
	int	nArg = (int)SvIV(ST(1));
	lua_Number	def = (double)SvNV(ST(2));
	lua_Number	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::optnumber",
                        "L", "Lua::API::State");

	RETVAL = luaL_optnumber(L, nArg, def);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_optstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_optstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, n, d");
    {
	lua_State *	L;
	int	n = (int)SvIV(ST(1));
	const char *	d = (const char *)SvPV_nolen(ST(2));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::optstring",
                        "L", "Lua::API::State");

	RETVAL = luaL_optstring(L, n, d);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_ref); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_ref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, t");
    {
	lua_State *	L;
	int	t = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::ref",
                        "L", "Lua::API::State");

	RETVAL = luaL_ref(L, t);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_typerror); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_typerror)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, narg, tname");
    {
	lua_State *	L;
	int	narg = (int)SvIV(ST(1));
	const char *	tname = (const char *)SvPV_nolen(ST(2));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::typerror",
                        "L", "Lua::API::State");

	RETVAL = luaL_typerror(L, narg, tname);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_unref); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_unref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, t, ref");
    {
	lua_State *	L;
	int	t = (int)SvIV(ST(1));
	int	ref = (int)SvIV(ST(2));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::unref",
                        "L", "Lua::API::State");

	luaL_unref(L, t, ref);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_where); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_where)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, lvl");
    {
	lua_State *	L;
	int	lvl = (int)SvIV(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::where",
                        "L", "Lua::API::State");

	luaL_where(L, lvl);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        GvNAME(CvGV(cv)),
                        "L", "Lua::API::State");
#line 1147 "API.xs"
 	if ( NULL != delete_oob_entry( L ) )
	    lua_close( L );
#line 4824 "API.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_lua_error); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_lua_error)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "L");
    {
	lua_State *	L;
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::lua_error",
                        "L", "Lua::API::State");

	RETVAL = lua_error(L);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_lua_register); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_lua_register)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "L, name, f");
    {
	lua_State *	L;
	const char *	name = (const char *)SvPV_nolen(ST(1));
	SV *	f = ST(2);
#line 1164 "API.xs"
	SV *sv_c = newSVsv(f);
#line 4877 "API.c"

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::lua_register",
                        "L", "Lua::API::State");
#line 1166 "API.xs"
        lua_pushlightuserdata(L, sv_c );
        lua_pushcclosure(L, l2p_closure, 1 );
	lua_setglobal(L, name );
#line 4891 "API.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_lua_getmetatable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_lua_getmetatable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, index");
    {
	lua_State *	L;
	int	index = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::lua_getmetatable",
                        "L", "Lua::API::State");

	RETVAL = lua_getmetatable(L, index);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaL_getmetatable); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaL_getmetatable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, n");
    {
	lua_State *	L;
	const char *	n = (const char *)SvPV_nolen(ST(1));

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaL_getmetatable",
                        "L", "Lua::API::State");

	luaL_getmetatable(L, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__State_lua_typename); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_lua_typename)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, tp");
    {
	lua_State *	L;
	int	tp = (int)SvIV(ST(1));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::lua_typename",
                        "L", "Lua::API::State");

	RETVAL = lua_typename(L, tp);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__State_luaL_typename); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__State_luaL_typename)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "L, i");
    {
	lua_State *	L;
	int	i = (int)SvIV(ST(1));
	const char *	RETVAL;
	dXSTARG;

        if (sv_derived_from(ST(0), "Lua::API::State")) {
            IV tmp = SvIV((SV*)SvRV(ST(0)));
            L = INT2PTR(lua_State *,tmp);
        }
        else
            Perl_croak(aTHX_ "%s: %s is not of type %s",
                        "Lua::API::State::luaL_typename",
                        "L", "Lua::API::State");

	RETVAL = luaL_typename(L, i);
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_new)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	CLASS;
	lua_Debug *	RETVAL;
#line 1197 "API.xs"
        Newxz( RETVAL, 1, lua_Debug );
	ST(0) = sv_newmortal();
        sv_setref_iv(ST(0), "Lua::API::Debug", PTR2IV(RETVAL));
	set_Perl_object( RETVAL, ST(0) );
        XSRETURN(1);
#line 5043 "API.c"
	PUTBACK;
	return;
    }
}


XS(XS_Lua__API__Debug_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1207 "API.xs"
        delete_oob_entry( THIS );
        Safefree(THIS);
#line 5077 "API.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__Debug_event); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_event)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1215 "API.xs"
	RETVAL = THIS->event;
#line 5111 "API.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_name); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_name)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	const char *	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1224 "API.xs"
	RETVAL = THIS->name;
#line 5146 "API.c"
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_namewhat); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_namewhat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	const char *	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1233 "API.xs"
	RETVAL = THIS->namewhat;
#line 5181 "API.c"
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_what); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_what)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	const char *	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1242 "API.xs"
	RETVAL = THIS->what;
#line 5216 "API.c"
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_source); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_source)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	const char *	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1251 "API.xs"
	RETVAL = THIS->source;
#line 5251 "API.c"
	XSprePUSH; PUSHp(RETVAL, RETVAL ? strlen(RETVAL) : 0 );
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_currentline); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_currentline)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1260 "API.xs"
	RETVAL = THIS->currentline;
#line 5286 "API.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_nups); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_nups)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1269 "API.xs"
	RETVAL = THIS->nups;
#line 5321 "API.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_linedefined); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_linedefined)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1278 "API.xs"
	RETVAL = THIS->linedefined;
#line 5356 "API.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_lastlinedefined); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_lastlinedefined)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1287 "API.xs"
	RETVAL = THIS->lastlinedefined;
#line 5391 "API.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Debug_short_src); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Debug_short_src)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	lua_Debug *	THIS;
	char *	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Debug")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(lua_Debug * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Debug");
#line 1296 "API.xs"
	RETVAL = THIS->short_src;
#line 5426 "API.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Buffer_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_new)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	CLASS;
	luaL_Buffer *	RETVAL;
#line 1307 "API.xs"
        Newxz( RETVAL, 1, luaL_Buffer );
	ST(0) = sv_newmortal();
        sv_setref_iv(ST(0), "Lua::API::Buffer", PTR2IV(RETVAL));
	set_Perl_object( RETVAL, ST(0) );
        XSRETURN(1);
#line 5454 "API.c"
	PUTBACK;
	return;
    }
}


XS(XS_Lua__API__Buffer_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	luaL_Buffer *	THIS;

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(THIS))
		croak("Size %d of packed data != expected %d",
			len, sizeof(THIS));
	    THIS = *(luaL_Buffer * *)s;
	}
	else
	    croak("THIS is not of type Lua::API::Buffer");
#line 1317 "API.xs"
        delete_oob_entry( THIS );
        Safefree(THIS);
#line 5488 "API.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__Buffer_addchar); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_addchar)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "B, c");
    {
	luaL_Buffer *	B;
	char	c = (char)*SvPV_nolen(ST(1));

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::Buffer");

	luaL_addchar(B, c);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__Buffer_addlstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_addlstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "B, s, l");
    {
	luaL_Buffer *	B;
	const char *	s = (const char *)SvPV_nolen(ST(1));
	size_t	l = (size_t)SvUV(ST(2));

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::Buffer");

	luaL_addlstring(B, s, l);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__Buffer_addsize); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_addsize)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "B, n");
    {
	luaL_Buffer *	B;
	size_t	n = (size_t)SvUV(ST(1));

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::Buffer");

	luaL_addsize(B, n);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__Buffer_addstring); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_addstring)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "B, s");
    {
	luaL_Buffer *	B;
	const char *	s = (const char *)SvPV_nolen(ST(1));

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::Buffer");

	luaL_addstring(B, s);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__Buffer_addvalue); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_addvalue)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "B");
    {
	luaL_Buffer *	B;

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::Buffer");

	luaL_addvalue(B);
    }
    XSRETURN_EMPTY;
}


XS(XS_Lua__API__Buffer_prepbuffer); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_prepbuffer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "B");
    {
	luaL_Buffer *	B;
	char *	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::Buffer");

	RETVAL = luaL_prepbuffer(B);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_Lua__API__Buffer_pushresult); /* prototype to pass -Wmissing-prototypes */
XS(XS_Lua__API__Buffer_pushresult)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "B");
    {
	luaL_Buffer *	B;

	if (sv_derived_from(ST(0), "Lua::API::Buffer")) {
	    STRLEN len;
	    char  *s = SvPV((SV*)SvRV(ST(0)), len);

	    if (len != sizeof(B))
		croak("Size %d of packed data != expected %d",
			len, sizeof(B));
	    B = *(luaL_Buffer * *)s;
	}
	else
	    croak("B is not of type Lua::API::Buffer");

	luaL_pushresult(B);
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Lua__API); /* prototype to pass -Wmissing-prototypes */
XS(boot_Lua__API)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    XS_VERSION_BOOTCHECK ;

    {
        CV * cv ;

        newXS("Lua::API::constant", XS_Lua__API_constant, file);
        newXS("Lua::API::RELEASE", XS_Lua__API_RELEASE, file);
        newXS("Lua::API::COPYRIGHT", XS_Lua__API_COPYRIGHT, file);
        newXS("Lua::API::State::atpanic", XS_Lua__API__State_atpanic, file);
        newXS("Lua::API::State::call", XS_Lua__API__State_call, file);
        newXS("Lua::API::State::checkstack", XS_Lua__API__State_checkstack, file);
        newXS("Lua::API::State::concat", XS_Lua__API__State_concat, file);
        newXS("Lua::API::State::cpcall", XS_Lua__API__State_cpcall, file);
        newXS("Lua::API::State::createtable", XS_Lua__API__State_createtable, file);
        newXS("Lua::API::State::equal", XS_Lua__API__State_equal, file);
        newXS("Lua::API::State::gc", XS_Lua__API__State_gc, file);
        newXS("Lua::API::State::getallocf", XS_Lua__API__State_getallocf, file);
        newXS("Lua::API::State::getfenv", XS_Lua__API__State_getfenv, file);
        newXS("Lua::API::State::getfield", XS_Lua__API__State_getfield, file);
        newXS("Lua::API::State::getgccount", XS_Lua__API__State_getgccount, file);
        newXS("Lua::API::State::getglobal", XS_Lua__API__State_getglobal, file);
        newXS("Lua::API::State::gethook", XS_Lua__API__State_gethook, file);
        newXS("Lua::API::State::gethookcount", XS_Lua__API__State_gethookcount, file);
        newXS("Lua::API::State::gethookmask", XS_Lua__API__State_gethookmask, file);
        newXS("Lua::API::State::getinfo", XS_Lua__API__State_getinfo, file);
        newXS("Lua::API::State::getlocal", XS_Lua__API__State_getlocal, file);
        newXS("Lua::API::State::getmetatable", XS_Lua__API__State_getmetatable, file);
        newXS("Lua::API::State::getregistry", XS_Lua__API__State_getregistry, file);
        newXS("Lua::API::State::getstack", XS_Lua__API__State_getstack, file);
        newXS("Lua::API::State::gettable", XS_Lua__API__State_gettable, file);
        newXS("Lua::API::State::gettop", XS_Lua__API__State_gettop, file);
        newXS("Lua::API::State::getupvalue", XS_Lua__API__State_getupvalue, file);
        newXS("Lua::API::State::insert", XS_Lua__API__State_insert, file);
        newXS("Lua::API::State::isboolean", XS_Lua__API__State_isboolean, file);
        newXS("Lua::API::State::iscfunction", XS_Lua__API__State_iscfunction, file);
        newXS("Lua::API::State::isfunction", XS_Lua__API__State_isfunction, file);
        newXS("Lua::API::State::islightuserdata", XS_Lua__API__State_islightuserdata, file);
        newXS("Lua::API::State::isnil", XS_Lua__API__State_isnil, file);
        newXS("Lua::API::State::isnone", XS_Lua__API__State_isnone, file);
        newXS("Lua::API::State::isnoneornil", XS_Lua__API__State_isnoneornil, file);
        newXS("Lua::API::State::isnumber", XS_Lua__API__State_isnumber, file);
        newXS("Lua::API::State::isstring", XS_Lua__API__State_isstring, file);
        newXS("Lua::API::State::istable", XS_Lua__API__State_istable, file);
        newXS("Lua::API::State::isthread", XS_Lua__API__State_isthread, file);
        newXS("Lua::API::State::isuserdata", XS_Lua__API__State_isuserdata, file);
        newXS("Lua::API::State::lessthan", XS_Lua__API__State_lessthan, file);
        newXS("Lua::API::State::newtable", XS_Lua__API__State_newtable, file);
        newXS("Lua::API::State::newthread", XS_Lua__API__State_newthread, file);
        newXS("Lua::API::State::newuserdata", XS_Lua__API__State_newuserdata, file);
        newXS("Lua::API::State::next", XS_Lua__API__State_next, file);
        newXS("Lua::API::State::objlen", XS_Lua__API__State_objlen, file);
        newXS("Lua::API::State::pcall", XS_Lua__API__State_pcall, file);
        newXS("Lua::API::State::pop", XS_Lua__API__State_pop, file);
        newXS("Lua::API::State::pushboolean", XS_Lua__API__State_pushboolean, file);
        newXS("Lua::API::State::pushcclosure", XS_Lua__API__State_pushcclosure, file);
        newXS("Lua::API::State::pushcfunction", XS_Lua__API__State_pushcfunction, file);
        newXS("Lua::API::State::pushinteger", XS_Lua__API__State_pushinteger, file);
        newXS("Lua::API::State::pushlightuserdata", XS_Lua__API__State_pushlightuserdata, file);
        newXS("Lua::API::State::pushlstring", XS_Lua__API__State_pushlstring, file);
        newXS("Lua::API::State::pushliteral", XS_Lua__API__State_pushliteral, file);
        newXS("Lua::API::State::pushnil", XS_Lua__API__State_pushnil, file);
        newXS("Lua::API::State::pushnumber", XS_Lua__API__State_pushnumber, file);
        newXS("Lua::API::State::pushstring", XS_Lua__API__State_pushstring, file);
        newXS("Lua::API::State::pushthread", XS_Lua__API__State_pushthread, file);
        newXS("Lua::API::State::pushvalue", XS_Lua__API__State_pushvalue, file);
        newXS("Lua::API::State::rawequal", XS_Lua__API__State_rawequal, file);
        newXS("Lua::API::State::rawget", XS_Lua__API__State_rawget, file);
        newXS("Lua::API::State::rawgeti", XS_Lua__API__State_rawgeti, file);
        newXS("Lua::API::State::rawset", XS_Lua__API__State_rawset, file);
        newXS("Lua::API::State::rawseti", XS_Lua__API__State_rawseti, file);
        newXS("Lua::API::State::remove", XS_Lua__API__State_remove, file);
        newXS("Lua::API::State::replace", XS_Lua__API__State_replace, file);
        newXS("Lua::API::State::resume", XS_Lua__API__State_resume, file);
        newXS("Lua::API::State::setfenv", XS_Lua__API__State_setfenv, file);
        newXS("Lua::API::State::setfield", XS_Lua__API__State_setfield, file);
        newXS("Lua::API::State::setglobal", XS_Lua__API__State_setglobal, file);
        newXS("Lua::API::State::sethook", XS_Lua__API__State_sethook, file);
        newXS("Lua::API::State::setlevel", XS_Lua__API__State_setlevel, file);
        newXS("Lua::API::State::setlocal", XS_Lua__API__State_setlocal, file);
        newXS("Lua::API::State::setmetatable", XS_Lua__API__State_setmetatable, file);
        newXS("Lua::API::State::settable", XS_Lua__API__State_settable, file);
        newXS("Lua::API::State::settop", XS_Lua__API__State_settop, file);
        newXS("Lua::API::State::setupvalue", XS_Lua__API__State_setupvalue, file);
        newXS("Lua::API::State::status", XS_Lua__API__State_status, file);
        newXS("Lua::API::State::strlen", XS_Lua__API__State_strlen, file);
        newXS("Lua::API::State::toboolean", XS_Lua__API__State_toboolean, file);
        newXS("Lua::API::State::tocfunction", XS_Lua__API__State_tocfunction, file);
        newXS("Lua::API::State::tointeger", XS_Lua__API__State_tointeger, file);
        newXS("Lua::API::State::tolstring", XS_Lua__API__State_tolstring, file);
        newXS("Lua::API::State::tonumber", XS_Lua__API__State_tonumber, file);
        newXS("Lua::API::State::topointer", XS_Lua__API__State_topointer, file);
        newXS("Lua::API::State::tostring", XS_Lua__API__State_tostring, file);
        newXS("Lua::API::State::tothread", XS_Lua__API__State_tothread, file);
        newXS("Lua::API::State::touserdata", XS_Lua__API__State_touserdata, file);
        newXS("Lua::API::State::type", XS_Lua__API__State_type, file);
        newXS("Lua::API::State::typename", XS_Lua__API__State_typename, file);
        newXS("Lua::API::State::xmove", XS_Lua__API__State_xmove, file);
        newXS("Lua::API::State::yield", XS_Lua__API__State_yield, file);
        newXS("Lua::API::State::luaopen_base", XS_Lua__API__State_luaopen_base, file);
        newXS("Lua::API::State::luaopen_debug", XS_Lua__API__State_luaopen_debug, file);
        newXS("Lua::API::State::luaopen_io", XS_Lua__API__State_luaopen_io, file);
        newXS("Lua::API::State::luaopen_math", XS_Lua__API__State_luaopen_math, file);
        newXS("Lua::API::State::luaopen_os", XS_Lua__API__State_luaopen_os, file);
        newXS("Lua::API::State::luaopen_package", XS_Lua__API__State_luaopen_package, file);
        newXS("Lua::API::State::luaopen_string", XS_Lua__API__State_luaopen_string, file);
        newXS("Lua::API::State::luaopen_table", XS_Lua__API__State_luaopen_table, file);
        newXS("Lua::API::State::openlibs", XS_Lua__API__State_openlibs, file);
        newXS("Lua::API::State::argcheck", XS_Lua__API__State_argcheck, file);
        newXS("Lua::API::State::argerror", XS_Lua__API__State_argerror, file);
        newXS("Lua::API::State::buffinit", XS_Lua__API__State_buffinit, file);
        newXS("Lua::API::State::callmeta", XS_Lua__API__State_callmeta, file);
        newXS("Lua::API::State::checkany", XS_Lua__API__State_checkany, file);
        newXS("Lua::API::State::checkint", XS_Lua__API__State_checkint, file);
        newXS("Lua::API::State::checkinteger", XS_Lua__API__State_checkinteger, file);
        newXS("Lua::API::State::checklong", XS_Lua__API__State_checklong, file);
        newXS("Lua::API::State::checklstring", XS_Lua__API__State_checklstring, file);
        newXS("Lua::API::State::checknumber", XS_Lua__API__State_checknumber, file);
        newXS("Lua::API::State::checkoption", XS_Lua__API__State_checkoption, file);
        newXS("Lua::API::State::checkstring", XS_Lua__API__State_checkstring, file);
        newXS("Lua::API::State::checktype", XS_Lua__API__State_checktype, file);
        newXS("Lua::API::State::checkudata", XS_Lua__API__State_checkudata, file);
        newXS("Lua::API::State::dofile", XS_Lua__API__State_dofile, file);
        newXS("Lua::API::State::dostring", XS_Lua__API__State_dostring, file);
        newXS("Lua::API::State::findtable", XS_Lua__API__State_findtable, file);
        newXS("Lua::API::State::getmetafield", XS_Lua__API__State_getmetafield, file);
        newXS("Lua::API::State::gsub", XS_Lua__API__State_gsub, file);
        newXS("Lua::API::State::loadbuffer", XS_Lua__API__State_loadbuffer, file);
        newXS("Lua::API::State::loadfile", XS_Lua__API__State_loadfile, file);
        newXS("Lua::API::State::loadstring", XS_Lua__API__State_loadstring, file);
        newXS("Lua::API::State::newmetatable", XS_Lua__API__State_newmetatable, file);
        cv = newXSproto_portable("Lua::API::State::newstate", XS_Lua__API__State_newstate, file, "$");
        XSANY.any_i32 = 0 ;
        cv = newXSproto_portable("Lua::API::State::new", XS_Lua__API__State_newstate, file, "$");
        XSANY.any_i32 = 2 ;
        cv = newXSproto_portable("Lua::API::State::open", XS_Lua__API__State_newstate, file, "$");
        XSANY.any_i32 = 1 ;
        newXS("Lua::API::State::optint", XS_Lua__API__State_optint, file);
        newXS("Lua::API::State::optinteger", XS_Lua__API__State_optinteger, file);
        newXS("Lua::API::State::optlong", XS_Lua__API__State_optlong, file);
        newXS("Lua::API::State::optlstring", XS_Lua__API__State_optlstring, file);
        newXS("Lua::API::State::optnumber", XS_Lua__API__State_optnumber, file);
        newXS("Lua::API::State::optstring", XS_Lua__API__State_optstring, file);
        newXS("Lua::API::State::ref", XS_Lua__API__State_ref, file);
        newXS("Lua::API::State::typerror", XS_Lua__API__State_typerror, file);
        newXS("Lua::API::State::unref", XS_Lua__API__State_unref, file);
        newXS("Lua::API::State::where", XS_Lua__API__State_where, file);
        cv = newXS("Lua::API::State::close", XS_Lua__API__State_DESTROY, file);
        XSANY.any_i32 = 1 ;
        cv = newXS("Lua::API::State::DESTROY", XS_Lua__API__State_DESTROY, file);
        XSANY.any_i32 = 0 ;
        newXS("Lua::API::State::lua_error", XS_Lua__API__State_lua_error, file);
        newXS("Lua::API::State::lua_register", XS_Lua__API__State_lua_register, file);
        newXS("Lua::API::State::lua_getmetatable", XS_Lua__API__State_lua_getmetatable, file);
        newXS("Lua::API::State::luaL_getmetatable", XS_Lua__API__State_luaL_getmetatable, file);
        newXS("Lua::API::State::lua_typename", XS_Lua__API__State_lua_typename, file);
        newXS("Lua::API::State::luaL_typename", XS_Lua__API__State_luaL_typename, file);
        (void)newXSproto_portable("Lua::API::Debug::new", XS_Lua__API__Debug_new, file, "$");
        newXS("Lua::API::Debug::DESTROY", XS_Lua__API__Debug_DESTROY, file);
        (void)newXSproto_portable("Lua::API::Debug::event", XS_Lua__API__Debug_event, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::name", XS_Lua__API__Debug_name, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::namewhat", XS_Lua__API__Debug_namewhat, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::what", XS_Lua__API__Debug_what, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::source", XS_Lua__API__Debug_source, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::currentline", XS_Lua__API__Debug_currentline, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::nups", XS_Lua__API__Debug_nups, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::linedefined", XS_Lua__API__Debug_linedefined, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::lastlinedefined", XS_Lua__API__Debug_lastlinedefined, file, "$");
        (void)newXSproto_portable("Lua::API::Debug::short_src", XS_Lua__API__Debug_short_src, file, "$");
        (void)newXSproto_portable("Lua::API::Buffer::new", XS_Lua__API__Buffer_new, file, "$");
        newXS("Lua::API::Buffer::DESTROY", XS_Lua__API__Buffer_DESTROY, file);
        newXS("Lua::API::Buffer::addchar", XS_Lua__API__Buffer_addchar, file);
        newXS("Lua::API::Buffer::addlstring", XS_Lua__API__Buffer_addlstring, file);
        newXS("Lua::API::Buffer::addsize", XS_Lua__API__Buffer_addsize, file);
        newXS("Lua::API::Buffer::addstring", XS_Lua__API__Buffer_addstring, file);
        newXS("Lua::API::Buffer::addvalue", XS_Lua__API__Buffer_addvalue, file);
        newXS("Lua::API::Buffer::prepbuffer", XS_Lua__API__Buffer_prepbuffer, file);
        newXS("Lua::API::Buffer::pushresult", XS_Lua__API__Buffer_pushresult, file);
    }

    /* Initialisation Section */

#line 279 "API.xs"
{
    MY_CXT_INIT;
    MY_CXT.OOB = newHV();
}

#line 5924 "API.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

