/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Map;
import org.w3c.dom.ranges.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTextInput
extends HtmlInput {
    private static final long serialVersionUID = -2473799124286935674L;
    private String valueAtFocus_;
    private final DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(){

        void typeDone(String newValue, int newCursorPosition) {
            HtmlTextInput.this.setAttribute("value", newValue);
            HtmlTextInput.this.setSelectionStart(newCursorPosition);
            HtmlTextInput.this.setSelectionEnd(newCursorPosition);
        }
    };

    HtmlTextInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), this.getSelectionStart(), this.getSelectionEnd(), c, shiftKey, ctrlKey, altKey);
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    public String getSelectedText() {
        Range selection = this.getThisSelection();
        if (selection != null) {
            return this.getValueAttribute().substring(selection.getStartOffset(), selection.getEndOffset());
        }
        return null;
    }

    private Range getThisSelection() {
        Range selection;
        if (this.getPage() instanceof HtmlPage && (selection = ((HtmlPage)this.getPage()).getSelection()).getStartContainer() == this && selection.getEndContainer() == this) {
            return selection;
        }
        return null;
    }

    public int getSelectionStart() {
        Range selection = this.getThisSelection();
        if (selection != null) {
            return selection.getStartOffset();
        }
        return this.getValueAttribute().length();
    }

    public void setSelectionStart(int selectionStart) {
        if (this.getPage() instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)this.getPage();
            int length = this.getValueAttribute().length();
            selectionStart = Math.max(0, Math.min(selectionStart, length));
            page.getSelection().setStart(this, selectionStart);
            if (page.getSelection().getEndContainer() != this) {
                page.getSelection().setEnd(this, length);
            } else if (page.getSelection().getEndOffset() < selectionStart) {
                page.getSelection().setEnd(this, selectionStart);
            }
        }
    }

    public int getSelectionEnd() {
        Range selection = this.getThisSelection();
        if (selection != null) {
            return selection.getEndOffset();
        }
        return this.getValueAttribute().length();
    }

    public void setSelectionEnd(int selectionEnd) {
        if (this.getPage() instanceof HtmlPage) {
            HtmlPage page = (HtmlPage)this.getPage();
            int length = this.getValueAttribute().length();
            selectionEnd = Math.min(length, Math.max(selectionEnd, 0));
            page.getSelection().setEnd(this, selectionEnd);
            if (page.getSelection().getStartContainer() != this) {
                page.getSelection().setStart(this, 0);
            } else if (page.getSelection().getStartOffset() > selectionEnd) {
                page.getSelection().setStart(this, selectionEnd);
            }
        }
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        SgmlPage page = this.getPage();
        if (qualifiedName.equals("value") && page instanceof HtmlPage && ((HtmlPage)page).getFocusedElement() == this) {
            this.setSelectionStart(attributeValue.length());
            this.setSelectionEnd(attributeValue.length());
        }
    }

    public void select() {
        this.focus();
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getValueAttribute().length());
    }

    @Override
    public void focus() {
        super.focus();
        this.valueAtFocus_ = this.getValueAttribute();
    }

    @Override
    void removeFocus() {
        super.removeFocus();
        if (!this.valueAtFocus_.equals(this.getValueAttribute())) {
            HtmlTextInput.executeOnChangeHandlerIfAppropriate(this);
        }
        this.valueAtFocus_ = null;
    }
}

