/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.regexp;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.RegExpProxy;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.regexp.NativeRegExp;
import net.sourceforge.htmlunit.corejs.javascript.regexp.RegExpImpl;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlUnitRegExpProxy
extends RegExpImpl {
    private static final Log LOG = LogFactory.getLog(HtmlUnitRegExpProxy.class);
    private final RegExpProxy wrapped_;

    public HtmlUnitRegExpProxy(RegExpProxy wrapped) {
        this.wrapped_ = wrapped;
    }

    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            return this.doAction(cx, scope, thisObj, args, actionType);
        }
        catch (StackOverflowError e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return this.wrapped_.action(cx, scope, thisObj, args, actionType);
        }
    }

    private Object doAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        if (2 == actionType && args.length == 2 && args[1] instanceof String) {
            String thisString = Context.toString((Object)thisObj);
            String replacement = (String)args[1];
            Object arg0 = args[0];
            if (arg0 instanceof String) {
                return StringUtils.replaceOnce((String)thisString, (String)((String)arg0), (String)replacement);
            }
            if (arg0 instanceof NativeRegExp) {
                replacement = replacement.replaceAll("\\\\", "\\\\\\\\");
                try {
                    NativeRegExp regexp = (NativeRegExp)arg0;
                    RegExpData reData = new RegExpData(regexp);
                    String regex = reData.getJavaPattern();
                    int flags = reData.getJavaFlags();
                    Pattern pattern = Pattern.compile(regex, flags);
                    Matcher matcher = pattern.matcher(thisString);
                    replacement = this.escapeInvalidBackReferences(regex, replacement);
                    if (reData.hasFlag('g')) {
                        return matcher.replaceAll(replacement);
                    }
                    return matcher.replaceFirst(replacement);
                }
                catch (PatternSyntaxException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (1 == actionType) {
            if (args.length == 0) {
                return null;
            }
            Object arg0 = args[0];
            String thisString = Context.toString((Object)thisObj);
            RegExpData reData = arg0 instanceof NativeRegExp ? new RegExpData((NativeRegExp)arg0) : new RegExpData(Context.toString((Object)arg0));
            Pattern pattern = Pattern.compile(reData.getJavaPattern(), reData.getJavaFlags());
            Matcher matcher = pattern.matcher(thisString);
            if (!matcher.find()) {
                return null;
            }
            int index = matcher.start(0);
            ArrayList<Object> groups = new ArrayList<Object>();
            if (reData.hasFlag('g')) {
                groups.add(matcher.group(0));
                while (matcher.find()) {
                    groups.add(matcher.group(0));
                }
            } else {
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    Object group = matcher.group(i);
                    if (group == null) {
                        group = Context.getUndefinedValue();
                    }
                    groups.add(group);
                }
            }
            Scriptable response = cx.newArray(scope, groups.toArray());
            response.put("index", response, (Object)new Integer(index));
            response.put("input", response, (Object)thisString);
            return response;
        }
        return this.wrappedAction(cx, scope, thisObj, args, actionType);
    }

    private String escapeInvalidBackReferences(String regex, String replacement) {
        StringBuilder ret = new StringBuilder();
        Matcher m = Pattern.compile(regex).matcher(replacement);
        int groups = m.groupCount();
        int prevIndex = 0;
        char[] rep = replacement.toCharArray();
        int i = ArrayUtils.indexOf((char[])rep, (char)'$');
        while (i != -1) {
            boolean escaped;
            ret.append(rep, prevIndex, i - prevIndex);
            boolean bl = escaped = i != 0 && rep[i - 1] == '\\';
            if (!escaped) {
                int num;
                StringBuilder sb = new StringBuilder(2);
                for (int j = i + 1; j < rep.length && Character.isDigit(rep[j]); ++j) {
                    sb.append(rep[j]);
                }
                boolean valid = sb.length() > 0 ? (num = Integer.parseInt(sb.toString())) > 0 && num <= groups : false;
                if (!valid) {
                    ret.append('\\');
                }
            }
            prevIndex = i;
            i = ArrayUtils.indexOf((char[])rep, (char)'$', (int)(i + 1));
        }
        ret.append(rep, prevIndex, rep.length - prevIndex);
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object wrappedAction(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        try {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this.wrapped_);
            Object object = this.wrapped_.action(cx, scope, thisObj, args, actionType);
            return object;
        }
        finally {
            ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)this);
        }
    }

    public Object compileRegExp(Context cx, String source, String flags) {
        try {
            return this.wrapped_.compileRegExp(cx, source, flags);
        }
        catch (Exception e) {
            LOG.warn((Object)("compileRegExp() threw for >" + source + "<, flags: >" + flags + "<. " + "Replacing with a '####shouldNotFindAnything###'"));
            return this.wrapped_.compileRegExp(cx, "####shouldNotFindAnything###", "");
        }
    }

    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        return this.wrapped_.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
    }

    public boolean isRegExp(Scriptable obj) {
        return this.wrapped_.isRegExp(obj);
    }

    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return this.wrapped_.wrapRegExp(cx, scope, compiled);
    }

    static String jsRegExpToJavaRegExp(String re) {
        re = re.replaceAll("\\[\\^\\\\\\d\\]", ".");
        re = re.replaceAll("\\[([^\\]]*)\\\\b([^\\]]*)\\]", "[$1\\\\cH$2]");
        re = re.replaceAll("(?<!\\\\)\\[([^((?<!\\\\)\\[)\\]]*)\\[", "[$1\\\\[");
        re = re.replaceAll("(?<!\\\\)\\[([^\\]]*)(?<!\\\\)\\\\\\d", "[$1");
        re = HtmlUnitRegExpProxy.escapeJSCurly(re);
        return re;
    }

    static String escapeJSCurly(String re) {
        re = re.replaceAll("(?<!\\\\)\\{(?!\\d)", "\\\\{");
        re = re.replaceAll("(?<!(\\d,?|\\\\))\\}", "\\\\}");
        return re;
    }

    private static class RegExpData {
        private final String jsSource_;
        private final String jsFlags_;

        RegExpData(NativeRegExp re) {
            String str = re.toString();
            this.jsSource_ = StringUtils.substringBeforeLast((String)str.substring(1), (String)"/");
            this.jsFlags_ = StringUtils.substringAfterLast((String)str, (String)"/");
        }

        public RegExpData(String string) {
            this.jsSource_ = string;
            this.jsFlags_ = "";
        }

        public int getJavaFlags() {
            int flags = 0;
            if (this.jsFlags_.contains("i")) {
                flags |= 2;
            }
            if (this.jsFlags_.contains("m")) {
                flags |= 8;
            }
            return flags;
        }

        public String getJavaPattern() {
            return HtmlUnitRegExpProxy.jsRegExpToJavaRegExp(this.jsSource_);
        }

        boolean hasFlag(char c) {
            return this.jsFlags_.indexOf(c) != -1;
        }
    }
}

