/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObjectImpl;
import com.gargoylesoftware.htmlunit.javascript.host.XSLTemplate;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLHttpRequest;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class ActiveXObject
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(ActiveXObject.class);

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        String mapValue;
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor must have one or two String parameters.");
        }
        if (args[0] == Context.getUndefinedValue()) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"ActiveXObject Error: constructor parameter must be a String.");
        }
        String activeXName = (String)args[0];
        if (ActiveXObject.isXMLHttpRequest(activeXName)) {
            return ActiveXObject.buildXMLHttpRequest();
        }
        if (ActiveXObject.isXMLDocument(activeXName)) {
            return ActiveXObject.buildXMLDocument(ActiveXObject.getWindow((Scriptable)ctorObj).getWebWindow());
        }
        if (ActiveXObject.isXMLTemplate(activeXName)) {
            return ActiveXObject.buildXSLTemplate();
        }
        WebClient webClient = ActiveXObject.getWindow((Scriptable)ctorObj).getWebWindow().getWebClient();
        Map<String, String> map = webClient.getActiveXObjectMap();
        if (map != null && (mapValue = map.get(activeXName)) != null) {
            String xClassString = mapValue;
            Object object = null;
            try {
                Class<?> xClass = Class.forName(xClassString);
                object = xClass.newInstance();
            }
            catch (Exception e) {
                throw Context.reportRuntimeError((String)("ActiveXObject Error: failed instantiating class " + xClassString + " because " + e.getMessage() + "."));
            }
            return Context.toObject(object, (Scriptable)ctorObj);
        }
        if (webClient.getOptions().isActiveXNative() && System.getProperty("os.name").contains("Windows")) {
            try {
                return new ActiveXObjectImpl(activeXName);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error initiating Jacob", (Throwable)e);
            }
        }
        LOG.warn((Object)("Automation server can't create object for '" + activeXName + "'."));
        throw Context.reportRuntimeError((String)("Automation server can't create object for '" + activeXName + "'."));
    }

    static boolean isXMLHttpRequest(String name) {
        if (name == null) {
            return false;
        }
        return "Microsoft.XMLHTTP".equalsIgnoreCase(name = name.toLowerCase()) || name.startsWith("Msxml2.XMLHTTP".toLowerCase());
    }

    static boolean isXMLDocument(String name) {
        if (name == null) {
            return false;
        }
        return "Microsoft.XMLDOM".equalsIgnoreCase(name = name.toLowerCase()) || name.matches("msxml\\d*\\.domdocument.*") || name.matches("msxml\\d*\\.freethreadeddomdocument.*");
    }

    static boolean isXMLTemplate(String name) {
        if (name == null) {
            return false;
        }
        name = name.toLowerCase();
        return name.matches("msxml\\d*\\.xsltemplate.*");
    }

    private static Scriptable buildXMLHttpRequest() {
        XMLHttpRequest scriptable = new XMLHttpRequest(false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "onreadystatechange", true, true);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "readyState", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "responseText", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "responseXML", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "status", true, false);
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "statusText", true, false);
        ActiveXObject.addFunction(scriptable, "abort");
        ActiveXObject.addFunction(scriptable, "getAllResponseHeaders");
        ActiveXObject.addFunction(scriptable, "getResponseHeader");
        ActiveXObject.addFunction(scriptable, "open");
        ActiveXObject.addFunction(scriptable, "send");
        ActiveXObject.addFunction(scriptable, "setRequestHeader");
        return scriptable;
    }

    private static Scriptable buildXSLTemplate() {
        XSLTemplate scriptable = new XSLTemplate();
        ActiveXObject.addProperty((SimpleScriptable)scriptable, "stylesheet", true, true);
        ActiveXObject.addFunction(scriptable, "createProcessor");
        return scriptable;
    }

    public static XMLDocument buildXMLDocument(WebWindow enclosingWindow) {
        XMLDocument document = new XMLDocument(enclosingWindow);
        ActiveXObject.addProperty((SimpleScriptable)document, "async", true, true);
        ActiveXObject.addProperty((SimpleScriptable)document, "parseError", true, false);
        ActiveXObject.addProperty((SimpleScriptable)document, "preserveWhiteSpace", true, true);
        ActiveXObject.addProperty((SimpleScriptable)document, "xml", true, false);
        ActiveXObject.addFunction(document, "createNode");
        ActiveXObject.addFunction(document, "createCDATASection");
        ActiveXObject.addFunction(document, "createProcessingInstruction");
        ActiveXObject.addFunction(document, "getElementsByTagName");
        ActiveXObject.addFunction(document, "load");
        ActiveXObject.addFunction(document, "loadXML");
        ActiveXObject.addFunction(document, "nodeFromID");
        ActiveXObject.addFunction(document, "selectNodes");
        ActiveXObject.addFunction(document, "selectSingleNode");
        ActiveXObject.addFunction(document, "setProperty");
        JavaScriptConfiguration jsConfig = enclosingWindow.getWebClient().getJavaScriptEngine().getJavaScriptConfiguration();
        String className = "Document";
        while (StringUtils.isNotBlank((CharSequence)className)) {
            ClassConfiguration classConfig = jsConfig.getClassConfiguration(className);
            for (String string : classConfig.functionKeys()) {
                ActiveXObject.addFunction(document, string);
            }
            for (Map.Entry entry : classConfig.propertyEntries()) {
                String propertyName = (String)entry.getKey();
                Method readMethod = ((ClassConfiguration.PropertyInfo)entry.getValue()).getReadMethod();
                Method writeMethod = ((ClassConfiguration.PropertyInfo)entry.getValue()).getWriteMethod();
                ActiveXObject.addProperty((SimpleScriptable)document, propertyName, readMethod != null, writeMethod != null);
            }
            className = classConfig.getExtendedClassName();
        }
        return document;
    }

    private static void addFunction(SimpleScriptable scriptable, String methodName) {
        Method javaFunction = ActiveXObject.getMethod(scriptable.getClass(), methodName);
        FunctionObject fo = new FunctionObject(null, (Member)javaFunction, (Scriptable)scriptable);
        scriptable.defineProperty(methodName, fo, 1);
    }

    public static void addProperty(SimpleScriptable scriptable, String propertyName, boolean isGetter, boolean isSetter) {
        String initialUpper = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String getterName = null;
        if (isGetter) {
            getterName = "get" + initialUpper;
        }
        String setterName = null;
        if (isSetter) {
            setterName = "set" + initialUpper;
        }
        ActiveXObject.addProperty(scriptable, propertyName, getterName, setterName);
    }

    static void addProperty(SimpleScriptable scriptable, String propertyName, String getterMethodName, String setterMethodName) {
        scriptable.defineProperty(propertyName, null, ActiveXObject.getMethod(scriptable.getClass(), getterMethodName), ActiveXObject.getMethod(scriptable.getClass(), setterMethodName), 4);
    }

    static Method getMethod(Class<? extends SimpleScriptable> clazz, String name) {
        if (name == null) {
            return null;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    @Override
    public String getClassName() {
        return "ActiveXObject";
    }
}

