/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  int opcode;   /* Either TK_GLOB or TK_LIKE */
  int not;      /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 239
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct AttachKey yy40;
  int yy60;
  struct TrigEvent yy62;
  struct {int value; int mask;} yy243;
  struct LikeOp yy258;
  ExprList* yy266;
  IdList* yy272;
  Select* yy331;
  struct LimitVal yy348;
  Token yy406;
  SrcList* yy427;
  Expr* yy454;
  TriggerStep* yy455;
  int yy477;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 564
#define YYNRULE 305
#define YYERRORSYMBOL 141
#define YYERRSYMDT yy477
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   263,  203,  261,  154,  124,  126,  128,  130,  132,  134,
 /*    10 */   136,  138,  140,  142,    3,  562,  145,  641,   83,  369,
 /*    20 */   144,  114,  116,  112,  118,  286,  124,  126,  128,  130,
 /*    30 */   132,  134,  136,  138,  140,  142,  152,  222,  163,  168,
 /*    40 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*    50 */   114,  116,  112,  118,  844,  124,  126,  128,  130,  132,
 /*    60 */   134,  136,  138,  140,  142,  866,  223,  533,  262,  124,
 /*    70 */   126,  128,  130,  132,  134,  136,  138,  140,  142,   13,
 /*    80 */    96,  145,   13,  535,  536,  144,  660,  438,  371,   92,
 /*    90 */   437,  373,  380,  385,  132,  134,  136,  138,  140,  142,
 /*   100 */    75,  845,  439,  388,  235,  110,   94,  146,  157,  162,
 /*   110 */   167,  156,  161,  120,  122,  114,  116,  112,  118,  428,
 /*   120 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   130 */   145,  354,  356,  357,  144,   13,   44,   45,  371,  227,
 /*   140 */   236,  373,  380,  385,  358,   14,   15,  294,   14,   15,
 /*   150 */    13,  293,   51,  388,  110,   94,  146,  157,  162,  167,
 /*   160 */   156,  161,  120,  122,  114,  116,  112,  118,  860,  124,
 /*   170 */   126,  128,  130,  132,  134,  136,  138,  140,  142,  426,
 /*   180 */    37,  341,   40,   59,   67,   69,  305,  336,  171,    2,
 /*   190 */   173,  174,    4,  358,  338,  145,  351,  356,  357,  144,
 /*   200 */   424,   14,   15,  371,   13,  546,  373,  380,  385,  292,
 /*   210 */    16,   17,   18,  107,  106,  108,   14,   15,  388,  110,
 /*   220 */    94,  146,  157,  162,  167,  156,  161,  120,  122,  114,
 /*   230 */   116,  112,  118,   51,  124,  126,  128,  130,  132,  134,
 /*   240 */   136,  138,  140,  142,   34,  345,  367,  366,  349,   95,
 /*   250 */   847,  640,   96,   31,   32,   33,  278,  250,  358,   78,
 /*   260 */    13,  364,  362,   40,   59,   67,   69,  305,  336,  145,
 /*   270 */    14,   15,   75,  144,  261,  338,  296,  368,  401,   57,
 /*   280 */    58,  534,  101,  102,  460,  387,  455,  136,  138,  140,
 /*   290 */   142,   77,  197,  110,   94,  146,  157,  162,  167,  156,
 /*   300 */   161,  120,  122,  114,  116,  112,  118,  246,  124,  126,
 /*   310 */   128,  130,  132,  134,  136,  138,  140,  142,   77,  800,
 /*   320 */    27,   48,  403,  588,  148,  252,   14,   15,  147,  573,
 /*   330 */    49,  152,   11,  163,  168,  248,  258,  494,  466,  456,
 /*   340 */   262,   50,  145,  479,   46,  425,  144,  564,   81,    6,
 /*   350 */     5,  251,  150,  151,   47,   25,    3,  562,  265,  465,
 /*   360 */   279,  507,  662,  457,  463,  802,  110,   94,  146,  157,
 /*   370 */   162,  167,  156,  161,  120,  122,  114,  116,  112,  118,
 /*   380 */   149,  124,  126,  128,  130,  132,  134,  136,  138,  140,
 /*   390 */   142,   52,   77,   77,   13,  288,   96,   96,  295,  688,
 /*   400 */   247,  250,  687,   54,  280,  258,  145,  169,   13,  281,
 /*   410 */   144,   13,  152,   98,  163,  168,   75,   75,  518,  421,
 /*   420 */   176,  176,  399,  309,  455,  171,  654,  173,  174,  398,
 /*   430 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*   440 */   114,  116,  112,  118,  205,  124,  126,  128,  130,  132,
 /*   450 */   134,  136,  138,  140,  142,  726,   77,  423,  243,  298,
 /*   460 */    14,   15,   65,  297,  171,  574,  173,  174,   66,  252,
 /*   470 */   217,  217,  350,  310,   14,   15,  261,   14,   15,  817,
 /*   480 */   145,  479,   13,  263,  144,  261,  171,  255,  173,  174,
 /*   490 */   171,   39,  173,  174,  397,  251,   13,  461,  832,  335,
 /*   500 */    72,  253,  463,  211,  110,   94,  146,  157,  162,  167,
 /*   510 */   156,  161,  120,  122,  114,  116,  112,  118,  175,  124,
 /*   520 */   126,  128,  130,  132,  134,  136,  138,  140,  142,  303,
 /*   530 */   172,  312,   48,  665,   96,  188,  338,  344,  870,    1,
 /*   540 */   563,   49,  262,    4,   96,   96,  145,  441,   14,   15,
 /*   550 */   144,  262,   50,  348,   75,  201,  406,  171,  493,  173,
 /*   560 */   174,  342,   14,   15,   75,   75,  499,  850,  235,  176,
 /*   570 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*   580 */   114,  116,  112,  118,  852,  124,  126,  128,  130,  132,
 /*   590 */   134,  136,  138,  140,  142,  596,  206,   96,   96,  187,
 /*   600 */   525,  505,  331,  501,  229,  367,  171,  241,  173,  174,
 /*   610 */    28,  145,  259,  402,   33,  144,  331,   75,   75,  216,
 /*   620 */   824,  190,  493,  171,  452,  173,  174,  152,  442,  163,
 /*   630 */   168,   77,  453,  537,  404,  110,   94,  146,  157,  162,
 /*   640 */   167,  156,  161,  120,  122,  114,  116,  112,  118,  382,
 /*   650 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   660 */   432,  434,  433,   96,  489,  810,   77,  275,  191,  171,
 /*   670 */    96,  173,  174,   96,   42,   96,  145,  801,  328,  623,
 /*   680 */   144,  327,  170,   75,  532,  503,  171,  277,  173,  174,
 /*   690 */    75,  202,  332,   75,  474,   75,  429,  245,  261,  176,
 /*   700 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*   710 */   114,  116,  112,  118,   77,  124,  126,  128,  130,  132,
 /*   720 */   134,  136,  138,  140,  142,  271,   96,   96,   96,  331,
 /*   730 */   862,   36,  340,   96,  219,   96,   96,  213,  720,  275,
 /*   740 */   335,  145,  313,  320,  322,  144,   75,   75,   75,  217,
 /*   750 */   143,   91,   93,   75,  471,   75,   75,  109,   64,  240,
 /*   760 */   184,  214,  391,  215,  262,  110,  165,  146,  157,  162,
 /*   770 */   167,  156,  161,  120,  122,  114,  116,  112,  118,  159,
 /*   780 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   790 */   265,   96,   96,   96,   96,  331,  195,  436,  207,   96,
 /*   800 */    96,   96,   96,  548,  310,  332,  145,  317,  316,  158,
 /*   810 */   144,   75,   75,   75,   75,  141,  198,  386,  224,   75,
 /*   820 */    75,   75,   75,  212,  164,  210,  196,  266,  449,  364,
 /*   830 */   362,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*   840 */   114,  116,  112,  118,   96,  124,  126,  128,  130,  132,
 /*   850 */   134,  136,  138,  140,  142,  244,  414,   96,   96,   96,
 /*   860 */    96,   85,  312,  347,   75,   96,   96,   96,  111,  430,
 /*   870 */   431,  332,  145,   96,  260,  318,  144,   75,   75,   75,
 /*   880 */    75,  113,  115,  178,  117,   75,   75,   75,   77,  427,
 /*   890 */   119,  121,  689,   75,  407,  319,  822,  123,  146,  157,
 /*   900 */   162,  167,  156,  161,  120,  122,  114,  116,  112,  118,
 /*   910 */    96,  124,  126,  128,  130,  132,  134,  136,  138,  140,
 /*   920 */   142,   76,   96,   96,   96,   71,  272,  265,  273,  415,
 /*   930 */    75,  410,   96,   96,  182,   76,  360,  361,   96,   71,
 /*   940 */   458,   45,   75,   75,   75,  331,  125,  153,  127,  199,
 /*   950 */   315,  837,   75,   75,  435,  720,  129,  131,   75,  107,
 /*   960 */   106,  108,  180,  199,  283,  177,  299,  838,  215,   96,
 /*   970 */   326,  652,  327,  107,  106,  108,  273,  597,  325,  177,
 /*   980 */   275,  689,  183,  181,  289,  219,   97,   96,   96,   75,
 /*   990 */   179,   73,   74,  133,   96,   95,  183,  181,  300,   96,
 /*  1000 */    96,  233,   96,  228,  179,   73,   74,   75,   75,   95,
 /*  1010 */   839,  155,  135,   76,   75,  476,  331,   71,  137,   75,
 /*  1020 */    75,  332,   75,  166,  491,  352,  139,  353,  101,  102,
 /*  1030 */   103,  104,  105,  185,  189,  107,  106,  108,  483,  365,
 /*  1040 */    96,  199,  101,  102,  103,  104,  105,  185,  189,  376,
 /*  1050 */    81,  107,  106,  108,  840,  476,   96,  177,  343,  346,
 /*  1060 */    75,   96,   63,  487,  208,   42,  290,  345,  383,   76,
 /*  1070 */   327,   95,  244,   71,  183,  181,   75,  392,  470,  327,
 /*  1080 */   302,   75,  179,   73,   74,  478,   75,   95,  689,  219,
 /*  1090 */   287,  450,  332,  327,  484,  486,  273,  199,  492,  421,
 /*  1100 */   490,  543,  219,  421,  101,  102,   81,  107,  106,  108,
 /*  1110 */   421,  421,  522,  177,  421,  421,  421,  526,  516,  490,
 /*  1120 */   101,  102,  103,  104,  105,  185,  189,   77,   64,   76,
 /*  1130 */   183,  181,   81,   71,  421,  820,  539,  500,  179,   73,
 /*  1140 */    74,  502,  100,   95,   77,  523,  244,  264,  504,  506,
 /*  1150 */   440,   62,  510,  514,  520,  355,  301,  199,  242,  232,
 /*  1160 */   142,  443,   43,  444,  549,  445,  446,  107,  106,  108,
 /*  1170 */   230,   70,  558,  177,  447,  448,  101,  102,  103,  104,
 /*  1180 */   105,  185,  189,  803,   42,  544,   41,  304,  551,  451,
 /*  1190 */   183,  181,  808,  276,  809,  359,  454,  267,  179,   73,
 /*  1200 */    74,  306,  269,   95,  324,  865,  552,   38,  459,   79,
 /*  1210 */     8,  363,  307,  727,  268,   19,   21,   23,  405,  728,
 /*  1220 */   308,  462,  215,  831,  309,  464,   89,  270,  846,  540,
 /*  1230 */   311,  457,  469,  467,   35,  550,  101,  102,  103,  104,
 /*  1240 */   105,  185,  189,  468,   90,   84,  400,  475,  529,  472,
 /*  1250 */   460,   61,  473,  587,   68,  527,  370,  553,    7,   30,
 /*  1260 */   848,  477,  556,  314,  372,   29,  583,   26,  480,  374,
 /*  1270 */   481,  582,  482,   88,  485,  225,  375,  554,  823,   60,
 /*  1280 */   231,  488,  555,   24,  377,  581,  867,  378,   22,  580,
 /*  1290 */   274,   20,  849,  379,  495,  381,  233,  221,  496,  497,
 /*  1300 */    87,  851,  545,  508,  512,  456,  234,   82,  557,  498,
 /*  1310 */   659,  661,   80,  249,   81,  321,  384,   81,  816,  858,
 /*  1320 */   389,  509,  390,  220,  559,  511,   55,  719,   56,  323,
 /*  1330 */   560,  515,  513,  859,  282,  393,  722,  226,  204,  519,
 /*  1340 */   575,  394,  561,  868,   12,  517,  395,  524,  538,  572,
 /*  1350 */   521,  396,   53,  725,  818,   10,   54,  528,    9,  530,
 /*  1360 */   819,  666,  531,  329,  284,  330,  285,  218,  667,   99,
 /*  1370 */   668,  239,  334,  541,  333,  254,  408,  598,  160,   86,
 /*  1380 */   337,  409,  411,  186,  567,  412,  413,  256,  192,  416,
 /*  1390 */   194,  547,  209,  339,  417,  193,  418,  237,  821,  420,
 /*  1400 */   419,  291,  861,  200,  257,  542,  238,  545,  545,  545,
 /*  1410 */   545,  545,  422,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    24,  187,   26,   78,   79,   80,   81,   82,   83,   84,
 /*    10 */    85,   86,   87,   88,    9,   10,   40,   23,  192,   25,
 /*    20 */    44,   74,   75,   76,   77,  199,   79,   80,   81,   82,
 /*    30 */    83,   84,   85,   86,   87,   88,  217,  218,  219,  220,
 /*    40 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    50 */    74,   75,   76,   77,   11,   79,   80,   81,   82,   83,
 /*    60 */    84,   85,   86,   87,   88,    9,   25,  150,   92,   79,
 /*    70 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   26,
 /*    80 */   150,   40,   26,  166,  167,   44,    9,   28,   94,   48,
 /*    90 */    31,   97,   98,   99,   83,   84,   85,   86,   87,   88,
 /*   100 */   170,   11,   43,  109,  174,   64,   65,   66,   67,   68,
 /*   110 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   39,
 /*   120 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   130 */    40,  165,  166,  167,   44,   26,  186,  187,   94,  209,
 /*   140 */   210,   97,   98,   99,  227,   92,   93,  112,   92,   93,
 /*   150 */    26,  116,   66,  109,   64,   65,   66,   67,   68,   69,
 /*   160 */    70,   71,   72,   73,   74,   75,   76,   77,    9,   79,
 /*   170 */    80,   81,   82,   83,   84,   85,   86,   87,   88,  136,
 /*   180 */    94,   95,   96,   97,   98,   99,  100,  101,  111,  144,
 /*   190 */   113,  114,  147,  227,  108,   40,  165,  166,  167,   44,
 /*   200 */   233,   92,   93,   94,   26,   46,   97,   98,   99,   85,
 /*   210 */    13,   14,   15,   60,   61,   62,   92,   93,  109,   64,
 /*   220 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   230 */    75,   76,   77,   66,   79,   80,   81,   82,   83,   84,
 /*   240 */    85,   86,   87,   88,  160,   92,  150,  163,  164,   96,
 /*   250 */    17,   23,  150,   25,  158,  159,   22,   25,  227,  157,
 /*   260 */    26,   83,   84,   96,   97,   98,   99,  100,  101,   40,
 /*   270 */    92,   93,  170,   44,   26,  108,  174,  181,  182,   13,
 /*   280 */    14,  103,  129,  130,   51,  171,  157,   85,   86,   87,
 /*   290 */    88,  189,  137,   64,   65,   66,   67,   68,   69,   70,
 /*   300 */    71,   72,   73,   74,   75,   76,   77,   25,   79,   80,
 /*   310 */    81,   82,   83,   84,   85,   86,   87,   88,  189,   17,
 /*   320 */    22,   18,   24,    9,   40,   93,   92,   93,   44,    9,
 /*   330 */    27,  217,   12,  219,  220,  201,  202,  104,  105,  106,
 /*   340 */    92,   38,   40,  214,   41,  234,   44,    0,  115,  145,
 /*   350 */   146,  119,   68,   69,   51,  151,    9,   10,  163,  230,
 /*   360 */   157,  157,    9,   64,  235,  136,   64,   65,   66,   67,
 /*   370 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   380 */    96,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   390 */    88,   96,  189,  189,   26,  200,  150,  150,   23,   23,
 /*   400 */   118,   25,   23,  108,  201,  202,   40,   22,   26,  206,
 /*   410 */    44,   26,  217,  150,  219,  220,  170,  170,  214,  150,
 /*   420 */   174,  174,  177,  178,  157,  111,  127,  113,  114,  184,
 /*   430 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   440 */    74,   75,   76,   77,  150,   79,   80,   81,   82,   83,
 /*   450 */    84,   85,   86,   87,   88,    9,  189,  188,  212,  212,
 /*   460 */    92,   93,   29,   23,  111,    9,  113,  114,   35,   93,
 /*   470 */   224,  224,   22,   45,   92,   93,   26,   92,   93,    9,
 /*   480 */    40,  214,   26,   24,   44,   26,  111,  119,  113,  114,
 /*   490 */   111,  169,  113,  114,   66,  119,   26,  230,   11,  177,
 /*   500 */    22,  119,  235,  137,   64,   65,   66,   67,   68,   69,
 /*   510 */    70,   71,   72,   73,   74,   75,   76,   77,   23,   79,
 /*   520 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   23,
 /*   530 */   112,  103,   18,  115,  150,   23,  108,  170,  142,  143,
 /*   540 */   144,   27,   92,  147,  150,  150,   40,   21,   92,   93,
 /*   550 */    44,   92,   38,  162,  170,   41,  153,  111,  174,  113,
 /*   560 */   114,  170,   92,   93,  170,  170,   20,    9,  174,  174,
 /*   570 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   580 */    74,   75,   76,   77,    9,   79,   80,   81,   82,   83,
 /*   590 */    84,   85,   86,   87,   88,  117,   23,  150,  150,  157,
 /*   600 */   216,   55,  150,   57,  210,  150,  111,  123,  113,  114,
 /*   610 */   155,   40,  150,  158,  159,   44,  150,  170,  170,  224,
 /*   620 */     9,  174,  174,  111,   98,  113,  114,  217,  225,  219,
 /*   630 */   220,  189,  229,   22,  157,   64,   65,   66,   67,   68,
 /*   640 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  183,
 /*   650 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   660 */   104,  105,  106,  150,  216,  139,  189,  150,  221,  111,
 /*   670 */   150,  113,  114,  150,  103,  150,   40,   17,  226,   23,
 /*   680 */    44,   25,  157,  170,   73,  139,  111,  174,  113,  114,
 /*   690 */   170,   23,  226,  170,  174,  170,   37,  174,   26,  174,
 /*   700 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   710 */    74,   75,   76,   77,  189,   79,   80,   81,   82,   83,
 /*   720 */    84,   85,   86,   87,   88,  208,  150,  150,  150,  150,
 /*   730 */     9,  168,  169,  150,  117,  150,  150,  212,    9,  150,
 /*   740 */   177,   40,  104,  105,  106,   44,  170,  170,  170,  224,
 /*   750 */   174,  174,  174,  170,   25,  170,  170,  174,  102,  174,
 /*   760 */   174,   23,  183,   25,   92,   64,   65,   66,   67,   68,
 /*   770 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   66,
 /*   780 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   790 */   163,  150,  150,  150,  150,  150,  136,  208,  138,  150,
 /*   800 */   150,  150,  150,  131,   45,  226,   40,   95,   96,   96,
 /*   810 */    44,  170,  170,  170,  170,  174,  174,  174,  174,  170,
 /*   820 */   170,  170,  170,  174,  174,  174,  174,  200,  183,   83,
 /*   830 */    84,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   840 */    74,   75,   76,   77,  150,   79,   80,   81,   82,   83,
 /*   850 */    84,   85,   86,   87,   88,  126,  157,  150,  150,  150,
 /*   860 */   150,  194,  103,  170,  170,  150,  150,  150,  174,   53,
 /*   870 */    54,  226,   40,  150,  154,   32,   44,  170,  170,  170,
 /*   880 */   170,  174,  174,  174,  174,  170,  170,  170,  189,  174,
 /*   890 */   174,  174,   24,  170,   20,   52,    9,  174,   66,   67,
 /*   900 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   910 */   150,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   920 */    88,   22,  150,  150,  150,   26,   23,  163,   25,   55,
 /*   930 */   170,   57,  150,  150,  174,   22,  129,  130,  150,   26,
 /*   940 */   186,  187,  170,  170,  170,  150,  174,  174,  174,   50,
 /*   950 */   107,  103,  170,  170,   47,    9,  174,  174,  170,   60,
 /*   960 */    61,   62,  174,   50,  200,   66,   23,  103,   25,  150,
 /*   970 */    23,    9,   25,   60,   61,   62,   25,  117,  183,   66,
 /*   980 */   150,    9,   83,   84,   85,  117,  117,  150,  150,  170,
 /*   990 */    91,   92,   93,  174,  150,   96,   83,   84,   85,  150,
 /*  1000 */   150,   26,  150,   25,   91,   92,   93,  170,  170,   96,
 /*  1010 */   103,  174,  174,   22,  170,  150,  150,   26,  174,  170,
 /*  1020 */   170,  226,  170,  174,  174,   23,  174,   25,  129,  130,
 /*  1030 */   131,  132,  133,  134,  135,   60,   61,   62,  208,  163,
 /*  1040 */   150,   50,  129,  130,  131,  132,  133,  134,  135,  183,
 /*  1050 */   115,   60,   61,   62,  103,  150,  150,   66,   83,   84,
 /*  1060 */   170,  150,  173,  128,  174,  103,  150,   92,   23,   22,
 /*  1070 */    25,   96,  126,   26,   83,   84,  170,   23,  213,   25,
 /*  1080 */   174,  170,   91,   92,   93,  174,  170,   96,  103,  117,
 /*  1090 */   174,   23,  226,   25,   23,  157,   25,   50,   23,  150,
 /*  1100 */    25,   24,  117,  150,  129,  130,  115,   60,   61,   62,
 /*  1110 */   150,  150,  157,   66,  150,  150,  150,   23,  213,   25,
 /*  1120 */   129,  130,  131,  132,  133,  134,  135,  189,  102,   22,
 /*  1130 */    83,   84,  115,   26,  150,    9,   23,  188,   91,   92,
 /*  1140 */    93,  188,  150,   96,  189,  128,  126,  150,  188,  188,
 /*  1150 */    47,  171,  188,  188,  188,   23,   23,   50,  122,  101,
 /*  1160 */    88,  139,   33,  150,   34,  154,  103,   60,   61,   62,
 /*  1170 */   211,   22,  188,   66,  150,   22,  129,  130,  131,  132,
 /*  1180 */   133,  134,  135,  136,  103,  150,  171,  171,  236,  171,
 /*  1190 */    83,   84,    9,  103,  139,  228,   11,  204,   91,   92,
 /*  1200 */    93,  150,  120,   96,   22,    9,  150,  150,  185,  190,
 /*  1210 */    11,  228,  175,  127,  205,   16,   17,   18,   19,  127,
 /*  1220 */   176,   17,   25,    9,  178,    9,  198,   22,   17,   30,
 /*  1230 */   150,   64,  107,  185,  161,   36,  129,  130,  131,  132,
 /*  1240 */   133,  134,  135,  150,  125,  193,  182,  194,   49,  150,
 /*  1250 */    51,  172,   73,    9,  171,   56,  182,   58,    9,   23,
 /*  1260 */     9,   73,   63,  179,  150,  156,    9,  152,  127,   46,
 /*  1270 */   150,    9,   22,  197,  215,  121,   22,  150,    9,   46,
 /*  1280 */   172,   22,  154,  149,  173,    9,    9,   23,  149,    9,
 /*  1290 */   150,  149,    9,  171,  118,   22,   26,  154,  150,  194,
 /*  1300 */   196,    9,  237,  104,  105,  106,  162,  191,   20,  110,
 /*  1310 */     9,    9,  189,  203,  115,  179,  171,  115,    9,    9,
 /*  1320 */    46,  118,   22,  150,   59,  194,  180,    9,   42,  179,
 /*  1330 */   140,  107,  185,    9,   23,  100,    9,  122,   25,  127,
 /*  1340 */     9,  150,  150,    9,  150,  194,  175,   22,  150,    9,
 /*  1350 */   215,  176,  171,    9,    9,  149,  108,  150,  148,  150,
 /*  1360 */     9,  115,  154,  211,  204,  172,  205,  150,  115,  117,
 /*  1370 */   115,  124,  172,  236,  211,  150,  150,  117,   96,  195,
 /*  1380 */   162,  154,  150,   22,    9,  154,   24,  150,  222,  150,
 /*  1390 */    17,  163,  136,  180,  154,  223,  231,  211,    9,  103,
 /*  1400 */   232,  117,    9,   22,  119,  163,  172,  238,  238,  238,
 /*  1410 */   238,  238,  154,
};
#define YY_SHIFT_USE_DFLT (-76)
static const short yy_shift_ofst[] = {
 /*     0 */     5,  347,  -76,  -76, 1199, 1375, 1249,  -76,  197,  320,
 /*    10 */  1340,  456, 1331,  -76,  -76,  -76,  -76,  -76,  -76,  320,
 /*    20 */  1280,  320, 1276,  320, 1262,  298, 1257,   53,  228, 1236,
 /*    30 */  1244,  109,  -76,  248,  -76,   86,  -76,   53,  167,  -76,
 /*    40 */  1081,  -76, 1129,  303,  -76,  -76,  -76,  -76,  -76,  -76,
 /*    50 */   -76,  295, 1081,  -76, 1286,  -76,  266,  -76,  -76, 1233,
 /*    60 */   433, 1081, 1026,  -76,  -76,  -76,  -76, 1081,  -76, 1149,
 /*    70 */  1107,  478,  913,  860, 1260,  -76,  991,  -76,  375, 1202,
 /*    80 */   -76,   35,  -76,  282, 1020,  484, 1247, 1154, 1119,  -76,
 /*    90 */  1107,   41, 1107,  636, 1107,  -76,  869,   53, 1252,   53,
 /*   100 */   -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  832,
 /*   110 */  1107,  766, 1107,  -10, 1107,  -10, 1107,  -10, 1107,  -10,
 /*   120 */  1107,  -53, 1107,  -53, 1107,   11, 1107,   11, 1107,   11,
 /*   130 */  1107,   11, 1107,  202, 1107,  202, 1107, 1072, 1107, 1072,
 /*   140 */  1107, 1072, 1107,  -76,  -76,  -76,  284,  -76,  -76,  -76,
 /*   150 */   -76,  -76, 1107,  -75, 1107,  -10,  -76,  713,  -76, 1282,
 /*   160 */   -76,  -76,  -76, 1107,  701, 1107,  -53,  -76,  385,  991,
 /*   170 */   495,  418, 1246, 1253, 1255,  -76,  636, 1107,  832, 1107,
 /*   180 */   -76, 1107,  -76, 1107,  -76, 1361, 1202,  512,  -76, 1047,
 /*   190 */   229, 1256,  660, 1373,  -76, 1107,  155, 1107,  636, 1381,
 /*   200 */   514,  668,  -76, 1313,   53,  573,  -76, 1107,  302, 1107,
 /*   210 */   366, 1107,  636,  738,  -76, 1107,  -76,  -76,  617,   53,
 /*   220 */   -76,  -76,  -76, 1107,  636, 1215, 1107,  978, 1107, 1058,
 /*   230 */   433,  -76, 1270,  -76,  -76,  636, 1058,  433,  -76, 1107,
 /*   240 */   636, 1036, 1107, 1197, 1107,  636,  -76,  -76,  232,  -76,
 /*   250 */   -76,  -76,  382,  -76,  368,  -76, 1285,  -76,  234,  617,
 /*   260 */   459,  -76,  -76,   53,  -76,  -76, 1090, 1082,  -76, 1205,
 /*   270 */    53,  903,  -76,   53,  -76,  -76, 1107,  636, 1202,  379,
 /*   280 */   376, 1311,  459, 1090, 1082,  -76,  899,  -24,  -76,  -76,
 /*   290 */  1284,  124,  -76,  -76,  -76,  -76,  440,  -76,  943,  -76,
 /*   300 */  1133,  -76,  506, 1081,  -76,   53, 1182,  -76,  759,  -76,
 /*   310 */    53,  -76,  638,  843,  -76,  712,  -76,  -76,  -76,  -76,
 /*   320 */   843,  -76,  843,  -76,   53,  947,  -76,   53, 1058,  433,
 /*   330 */   -76,  -76, 1058,  433,  -76,  -76, 1270,  -76, 1286,  -76,
 /*   340 */   -76,  975,  -76,  153,  -76,  -76,  153,  -76,  -76,  450,
 /*   350 */   746, 1002,  -76,  746, 1132,  -76,  -76,  -76,  807,  -76,
 /*   360 */   -76,  -76,  807,  -76,  -76,  -76,  -76,  -76,   -6,   44,
 /*   370 */   -76,   53,  -76, 1223, 1254,   53,  656, 1264, 1081,  -76,
 /*   380 */  1273,   53, 1045, 1081,  -76, 1107,  571,  -76, 1274, 1300,
 /*   390 */    53, 1054, 1235,   53, 1182,  -76,  428, 1248,  -76,  -76,
 /*   400 */   -76,  -76,  -76, 1202,  314,  526,  874,   53,  617,  -76,
 /*   410 */    53,  868, 1362, 1202,   77,   53,  617,   59,  556, 1296,
 /*   420 */    53,  617,  -76,   80,   43,  487, 1107,   90,  659,  816,
 /*   430 */   -76,  -76,  848,  864,  907,   53,  951,  -76,  -76, 1103,
 /*   440 */   -76,  -76, 1022,   53,  985, 1063,   53, 1153,   53, 1068,
 /*   450 */   962, 1183, 1055, 1185,  233,  575,  299,  303,  -76, 1086,
 /*   460 */  1092, 1204, 1214, 1216,  233, 1211, 1167,   53, 1125,   53,
 /*   470 */   729,   53, 1179, 1107,  636, 1251, 1188, 1107,  636, 1141,
 /*   480 */    53, 1250,   53, 1071,  -76,  935,  558, 1259, 1107, 1075,
 /*   490 */  1107,  636, 1283,  636, 1176,   53,  946, 1292,  546,   53,
 /*   500 */  1301,   53, 1302,   53, 1309,   53, 1310,  353, 1203,   53,
 /*   510 */   946, 1318, 1167,   53, 1224,   53,  729, 1327, 1212,   53,
 /*   520 */  1250, 1017,  446, 1325, 1107, 1094, 1344,  470, 1345,   53,
 /*   530 */   617,  611,  178, 1351, 1126, 1389,  887,   53, 1113, 1269,
 /*   540 */  1130,  248, 1077,   53,  159, 1324,  672, 1393,  721,  -76,
 /*   550 */  1130,   53, 1196,   56,  972, 1277, 1288,   53, 1265, 1190,
 /*   560 */    53, 1334,  -76,  -76,
};
#define YY_REDUCE_USE_DFLT (-187)
static const short yy_reduce_ofst[] = {
 /*     0 */   396,   45, -187, -187,  204, -187, -187, -187, 1210, 1206,
 /*    10 */  -187, 1194, -187, -187, -187, -187, -187, -187, -187, 1142,
 /*    20 */  -187, 1139, -187, 1134, -187, 1115, -187,  455, 1109, -187,
 /*    30 */  -187,   96, -187,   84, 1073,  563, -187, 1057,  322, -187,
 /*    40 */  1015, -187, -187,  -50, -187, -187, -187, -187, -187, -187,
 /*    50 */  -187, -187, 1181, -187, 1146, -187, -187, -187, -187, -187,
 /*    60 */  1079,  980,  889, -187, -187, -187, -187, 1083, -187, -187,
 /*    70 */   906, -187,  247, -187, -187, -187,  102, -187, 1019, 1123,
 /*    80 */  -187, 1116, -174, 1052,  667, 1184, 1104, 1076, 1028, -187,
 /*    90 */   577,  410,  578,  410,  583, -187, -187,  263, -187,  992,
 /*   100 */  -187, -187, -187, -187, -187, -187, -187, -187, -187,  410,
 /*   110 */   694,  410,  707,  410,  708,  410,  710,  410,  716,  410,
 /*   120 */   717,  410,  723,  410,  772,  410,  774,  410,  782,  410,
 /*   130 */   783,  410,  819,  410,  838,  410,  844,  410,  852,  410,
 /*   140 */   641,  410,  576,  410, -187, -187, -187, -187, -187, -187,
 /*   150 */  -187, -187,  773, -181,  837,  410, -187, -187, -187, -187,
 /*   160 */  -187, -187, -187,  650,  410,  849,  410, -187, 1217,  525,
 /*   170 */  1019, -187, -187, -187, -187, -187,  410,  709,  410,  788,
 /*   180 */   410,  760,  410,  586,  410, -187,  442, 1019, -187,  447,
 /*   190 */   410, 1166, 1172, -187, -187,  652,  410,  642,  410, -187,
 /*   200 */  -186, -187, -187, -187,  294, -187, -187,  890,  410,  651,
 /*   210 */   410,  649,  410, -187, -187,  395, -187, -187, 1143, 1173,
 /*   220 */  -187, -187, -187,  644,  410, -187,  -70, -187,  394,  959,
 /*   230 */  1108, -187, 1144, -187, -187,  410, 1186, 1234, -187,  585,
 /*   240 */   410, -187,  246, -187,  523,  410, -187,  134, 1110, -187,
 /*   250 */  -187, -187, 1225, -187, 1237, -187, -187, -187,  462,  720,
 /*   260 */   627, -187, -187,  997, -187, -187,  993, 1009, -187, -187,
 /*   270 */   517, -187, -187, 1140, -187, -187,  513,  410,  203, 1019,
 /*   280 */  1110, -187,  764, 1160, 1161, -187,  916,  195, -187, -187,
 /*   290 */  -187,  263, -187, -187, -187, -187,  410, -187, -187, -187,
 /*   300 */  -187, -187,  410, 1016, -187, 1051, 1037, 1044, 1046, -187,
 /*   310 */  1080, -187, -187, 1084, -187, -187, -187, -187, -187, -187,
 /*   320 */  1136, -187, 1150, -187,  795, -187, -187,  452, 1152, 1193,
 /*   330 */  -187, -187, 1163, 1200, -187, -187, 1218, -187, 1213, -187,
 /*   340 */  -187,  391, -187,  367, -187, -187,  693, -187, -187,  876,
 /*   350 */    31, -187, -187,  -34, -187, -187, -187, -187,  967, -187,
 /*   360 */  -187, -187,  983, -187, -187, -187, -187, -187, 1064, 1074,
 /*   370 */  -187, 1114, -187, -187, -187,  866, 1111, -187, 1122, -187,
 /*   380 */  -187,  466, -187, 1145, -187,  643,  114, -187, -187, -187,
 /*   390 */   579, -187, -187, 1191, 1171, 1175,  245, -187, -187, -187,
 /*   400 */  -187, -187, -187,  477, 1019,  403, -187, 1226, 1227, -187,
 /*   410 */  1232, 1231, -187,  699, 1019, 1239, 1240, 1165, 1168, -187,
 /*   420 */   269, 1258, -187,  -33,  111, -187,  715,  410, -187, -187,
 /*   430 */  -187, -187, -187, -187, -187,  589, -187, -187, -187, -187,
 /*   440 */  -187, -187, -187, 1013, 1011, -187, 1024, -187,  645, -187,
 /*   450 */  1018, -187, -187, -187,  267, 1019, 1023,  754, -187, -187,
 /*   460 */  -187, -187, -187, -187,  129, -187, 1048, 1093, -187,  865,
 /*   470 */  1053, 1099, -187,  520,  410, -187, -187,  911,  410, -187,
 /*   480 */  1120, 1059,  830, -187, -187,  938, 1019, -187,  448, -187,
 /*   490 */   850,  410, -187,  410, -187, 1148, 1105, -187, -187,  949,
 /*   500 */  -187,  953, -187,  960, -187,  961, -187, 1019, -187,  964,
 /*   510 */  1131, -187, 1147,  965, -187,  905, 1151, -187, -187,  966,
 /*   520 */  1135,  955, 1019, -187,  384, -187, -187, 1207, -187, 1209,
 /*   530 */  1208, -187,  -83, -187, -187, -187, -187, 1198, -187, -187,
 /*   540 */  1137, 1242, -187, 1035, 1065, -187, 1228, -187, -187, -187,
 /*   550 */   952, 1056, -187, 1127, 1128, -187, -187,  984, -187, -187,
 /*   560 */  1192, -187, -187, -187,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   570,  570,  565,  568,  869,  869,  869,  569,  576,  869,
 /*    10 */   869,  869,  869,  596,  597,  598,  577,  578,  579,  869,
 /*    20 */   869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*    30 */   869,  869,  589,  599,  608,  591,  607,  869,  869,  609,
 /*    40 */   652,  615,  869,  869,  653,  656,  657,  658,  855,  856,
 /*    50 */   857,  869,  652,  616,  637,  635,  869,  638,  639,  869,
 /*    60 */   708,  652,  623,  617,  624,  706,  707,  652,  618,  869,
 /*    70 */   869,  738,  807,  744,  739,  735,  869,  663,  869,  869,
 /*    80 */   664,  672,  674,  681,  720,  711,  713,  701,  715,  669,
 /*    90 */   869,  716,  869,  717,  869,  737,  869,  869,  740,  869,
 /*   100 */   741,  742,  743,  745,  746,  747,  750,  751,  752,  753,
 /*   110 */   869,  754,  869,  755,  869,  756,  869,  757,  869,  758,
 /*   120 */   869,  759,  869,  760,  869,  761,  869,  762,  869,  763,
 /*   130 */   869,  764,  869,  765,  869,  766,  869,  767,  869,  768,
 /*   140 */   869,  769,  869,  770,  771,  772,  869,  773,  774,  781,
 /*   150 */   788,  791,  869,  776,  869,  775,  778,  869,  779,  869,
 /*   160 */   782,  780,  787,  869,  869,  869,  789,  790,  869,  807,
 /*   170 */   869,  869,  869,  869,  869,  794,  806,  869,  783,  869,
 /*   180 */   784,  869,  785,  869,  786,  869,  869,  869,  796,  869,
 /*   190 */   869,  869,  869,  869,  797,  869,  869,  869,  798,  869,
 /*   200 */   869,  869,  853,  869,  869,  869,  854,  869,  869,  869,
 /*   210 */   869,  869,  799,  869,  792,  807,  804,  805,  689,  869,
 /*   220 */   690,  795,  777,  869,  718,  869,  869,  702,  869,  709,
 /*   230 */   708,  703,  869,  593,  710,  705,  709,  708,  704,  869,
 /*   240 */   714,  869,  807,  712,  869,  721,  673,  684,  682,  683,
 /*   250 */   692,  693,  869,  694,  869,  695,  869,  696,  869,  689,
 /*   260 */   680,  594,  595,  869,  678,  679,  698,  700,  685,  869,
 /*   270 */   869,  869,  699,  869,  733,  734,  869,  697,  684,  869,
 /*   280 */   869,  869,  680,  698,  700,  686,  869,  680,  675,  676,
 /*   290 */   869,  869,  677,  670,  671,  793,  869,  736,  869,  748,
 /*   300 */   869,  749,  869,  652,  619,  869,  811,  625,  620,  626,
 /*   310 */   869,  627,  869,  869,  628,  869,  631,  632,  633,  634,
 /*   320 */   869,  629,  869,  630,  869,  869,  812,  869,  709,  708,
 /*   330 */   813,  815,  709,  708,  814,  621,  869,  622,  637,  636,
 /*   340 */   610,  869,  611,  869,  612,  744,  869,  613,  614,  600,
 /*   350 */   830,  869,  601,  830,  869,  602,  605,  606,  869,  825,
 /*   360 */   827,  828,  869,  826,  829,  604,  603,  592,  869,  869,
 /*   370 */   642,  869,  645,  869,  869,  869,  869,  869,  652,  646,
 /*   380 */   869,  869,  869,  652,  647,  869,  652,  648,  869,  869,
 /*   390 */   869,  869,  869,  869,  811,  625,  650,  869,  649,  651,
 /*   400 */   643,  644,  590,  869,  869,  586,  869,  869,  689,  584,
 /*   410 */   869,  869,  869,  869,  869,  869,  689,  836,  869,  869,
 /*   420 */   869,  689,  691,  841,  869,  869,  869,  869,  869,  869,
 /*   430 */   842,  843,  869,  869,  869,  869,  869,  833,  834,  869,
 /*   440 */   835,  585,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   450 */   869,  869,  869,  869,  869,  869,  869,  869,  655,  869,
 /*   460 */   869,  869,  869,  869,  869,  869,  654,  869,  869,  869,
 /*   470 */   869,  869,  869,  869,  723,  869,  869,  869,  724,  869,
 /*   480 */   869,  731,  869,  869,  732,  869,  869,  869,  869,  869,
 /*   490 */   869,  729,  869,  730,  869,  869,  869,  869,  869,  869,
 /*   500 */   869,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   510 */   869,  869,  654,  869,  869,  869,  869,  869,  869,  869,
 /*   520 */   731,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   530 */   689,  869,  830,  869,  869,  869,  869,  869,  869,  869,
 /*   540 */   864,  869,  869,  869,  869,  869,  869,  869,  869,  863,
 /*   550 */   864,  869,  869,  869,  869,  869,  869,  869,  869,  869,
 /*   560 */   869,  869,  571,  566,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*    CASCADE => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*       GLOB => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*       LIKE => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*  STATEMENT => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
   26,  /*    REINDEX => ID */
   26,  /*     RENAME => ID */
   26,  /*      CDATE => ID */
   26,  /*      CTIME => ID */
   26,  /* CTIMESTAMP => ID */
   26,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ASC",           "ATTACH",        "BEFORE",      
  "CASCADE",       "CONFLICT",      "DATABASE",      "DESC",        
  "DETACH",        "EACH",          "FAIL",          "FOR",         
  "GLOB",          "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "REINDEX",       "RENAME",      
  "CDATE",         "CTIME",         "CTIMESTAMP",    "ALTER",       
  "OR",            "AND",           "NOT",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "EXISTS",        "CASE",        
  "WHEN",          "THEN",          "ELSE",          "INDEX",       
  "TO",            "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "onconf",      
  "sortorder",     "autoinc",       "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "collate",     
  "exprlist",      "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "plus_opt",    
  "number",        "trigger_decl",  "trigger_cmd_list",  "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd", 
  "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT term",
 /*  48 */ "carg ::= DEFAULT PLUS term",
 /*  49 */ "carg ::= DEFAULT MINUS term",
 /*  50 */ "carg ::= DEFAULT id",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "autoinc ::=",
 /*  60 */ "autoinc ::= AUTOINCR",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= raisetype",
 /*  93 */ "resolvetype ::= IGNORE",
 /*  94 */ "resolvetype ::= REPLACE",
 /*  95 */ "cmd ::= DROP TABLE fullname",
 /*  96 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  97 */ "cmd ::= DROP VIEW fullname",
 /*  98 */ "cmd ::= select",
 /*  99 */ "select ::= oneselect",
 /* 100 */ "select ::= select multiselect_op oneselect",
 /* 101 */ "multiselect_op ::= UNION",
 /* 102 */ "multiselect_op ::= UNION ALL",
 /* 103 */ "multiselect_op ::= INTERSECT",
 /* 104 */ "multiselect_op ::= EXCEPT",
 /* 105 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 106 */ "distinct ::= DISTINCT",
 /* 107 */ "distinct ::= ALL",
 /* 108 */ "distinct ::=",
 /* 109 */ "sclp ::= selcollist COMMA",
 /* 110 */ "sclp ::=",
 /* 111 */ "selcollist ::= sclp expr as",
 /* 112 */ "selcollist ::= sclp STAR",
 /* 113 */ "selcollist ::= sclp nm DOT STAR",
 /* 114 */ "as ::= AS nm",
 /* 115 */ "as ::= ids",
 /* 116 */ "as ::=",
 /* 117 */ "from ::=",
 /* 118 */ "from ::= FROM seltablist",
 /* 119 */ "stl_prefix ::= seltablist joinop",
 /* 120 */ "stl_prefix ::=",
 /* 121 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 122 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 123 */ "seltablist_paren ::= select",
 /* 124 */ "seltablist_paren ::= seltablist",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "fullname ::= nm dbnm",
 /* 128 */ "joinop ::= COMMA",
 /* 129 */ "joinop ::= JOIN",
 /* 130 */ "joinop ::= JOIN_KW JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 133 */ "on_opt ::= ON expr",
 /* 134 */ "on_opt ::=",
 /* 135 */ "using_opt ::= USING LP inscollist RP",
 /* 136 */ "using_opt ::=",
 /* 137 */ "orderby_opt ::=",
 /* 138 */ "orderby_opt ::= ORDER BY sortlist",
 /* 139 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 140 */ "sortlist ::= sortitem collate sortorder",
 /* 141 */ "sortitem ::= expr",
 /* 142 */ "sortorder ::= ASC",
 /* 143 */ "sortorder ::= DESC",
 /* 144 */ "sortorder ::=",
 /* 145 */ "collate ::=",
 /* 146 */ "collate ::= COLLATE id",
 /* 147 */ "groupby_opt ::=",
 /* 148 */ "groupby_opt ::= GROUP BY exprlist",
 /* 149 */ "having_opt ::=",
 /* 150 */ "having_opt ::= HAVING expr",
 /* 151 */ "limit_opt ::=",
 /* 152 */ "limit_opt ::= LIMIT expr",
 /* 153 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 154 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 155 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 156 */ "where_opt ::=",
 /* 157 */ "where_opt ::= WHERE expr",
 /* 158 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 159 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 160 */ "setlist ::= nm EQ expr",
 /* 161 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 162 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 163 */ "insert_cmd ::= INSERT orconf",
 /* 164 */ "insert_cmd ::= REPLACE",
 /* 165 */ "itemlist ::= itemlist COMMA expr",
 /* 166 */ "itemlist ::= expr",
 /* 167 */ "inscollist_opt ::=",
 /* 168 */ "inscollist_opt ::= LP inscollist RP",
 /* 169 */ "inscollist ::= inscollist COMMA nm",
 /* 170 */ "inscollist ::= nm",
 /* 171 */ "expr ::= term",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "term ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "term ::= INTEGER",
 /* 179 */ "term ::= FLOAT",
 /* 180 */ "term ::= STRING",
 /* 181 */ "expr ::= BLOB",
 /* 182 */ "expr ::= REGISTER",
 /* 183 */ "expr ::= VARIABLE",
 /* 184 */ "expr ::= ID LP exprlist RP",
 /* 185 */ "expr ::= ID LP STAR RP",
 /* 186 */ "term ::= CTIME",
 /* 187 */ "term ::= CDATE",
 /* 188 */ "term ::= CTIMESTAMP",
 /* 189 */ "expr ::= expr AND expr",
 /* 190 */ "expr ::= expr OR expr",
 /* 191 */ "expr ::= expr LT expr",
 /* 192 */ "expr ::= expr GT expr",
 /* 193 */ "expr ::= expr LE expr",
 /* 194 */ "expr ::= expr GE expr",
 /* 195 */ "expr ::= expr NE expr",
 /* 196 */ "expr ::= expr EQ expr",
 /* 197 */ "expr ::= expr BITAND expr",
 /* 198 */ "expr ::= expr BITOR expr",
 /* 199 */ "expr ::= expr LSHIFT expr",
 /* 200 */ "expr ::= expr RSHIFT expr",
 /* 201 */ "expr ::= expr PLUS expr",
 /* 202 */ "expr ::= expr MINUS expr",
 /* 203 */ "expr ::= expr STAR expr",
 /* 204 */ "expr ::= expr SLASH expr",
 /* 205 */ "expr ::= expr REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "likeop ::= LIKE",
 /* 208 */ "likeop ::= GLOB",
 /* 209 */ "likeop ::= NOT LIKE",
 /* 210 */ "likeop ::= NOT GLOB",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOTNULL",
 /* 217 */ "expr ::= expr NOT NULL",
 /* 218 */ "expr ::= expr IS NOT NULL",
 /* 219 */ "expr ::= NOT expr",
 /* 220 */ "expr ::= BITNOT expr",
 /* 221 */ "expr ::= MINUS expr",
 /* 222 */ "expr ::= PLUS expr",
 /* 223 */ "between_op ::= BETWEEN",
 /* 224 */ "between_op ::= NOT BETWEEN",
 /* 225 */ "expr ::= expr between_op expr AND expr",
 /* 226 */ "in_op ::= IN",
 /* 227 */ "in_op ::= NOT IN",
 /* 228 */ "expr ::= expr in_op LP exprlist RP",
 /* 229 */ "expr ::= LP select RP",
 /* 230 */ "expr ::= expr in_op LP select RP",
 /* 231 */ "expr ::= expr in_op nm dbnm",
 /* 232 */ "expr ::= EXISTS LP select RP",
 /* 233 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 234 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 235 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 236 */ "case_else ::= ELSE expr",
 /* 237 */ "case_else ::=",
 /* 238 */ "case_operand ::= expr",
 /* 239 */ "case_operand ::=",
 /* 240 */ "exprlist ::= exprlist COMMA expritem",
 /* 241 */ "exprlist ::= expritem",
 /* 242 */ "expritem ::= expr",
 /* 243 */ "expritem ::=",
 /* 244 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 245 */ "uniqueflag ::= UNIQUE",
 /* 246 */ "uniqueflag ::=",
 /* 247 */ "idxlist_opt ::=",
 /* 248 */ "idxlist_opt ::= LP idxlist RP",
 /* 249 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 250 */ "idxlist ::= idxitem collate sortorder",
 /* 251 */ "idxitem ::= nm",
 /* 252 */ "cmd ::= DROP INDEX fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 257 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 260 */ "cmd ::= PRAGMA nm dbnm",
 /* 261 */ "plus_num ::= plus_opt number",
 /* 262 */ "minus_num ::= MINUS number",
 /* 263 */ "number ::= INTEGER",
 /* 264 */ "number ::= FLOAT",
 /* 265 */ "plus_opt ::= PLUS",
 /* 266 */ "plus_opt ::=",
 /* 267 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 268 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 269 */ "trigger_time ::= BEFORE",
 /* 270 */ "trigger_time ::= AFTER",
 /* 271 */ "trigger_time ::= INSTEAD OF",
 /* 272 */ "trigger_time ::=",
 /* 273 */ "trigger_event ::= DELETE",
 /* 274 */ "trigger_event ::= INSERT",
 /* 275 */ "trigger_event ::= UPDATE",
 /* 276 */ "trigger_event ::= UPDATE OF inscollist",
 /* 277 */ "foreach_clause ::=",
 /* 278 */ "foreach_clause ::= FOR EACH ROW",
 /* 279 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 280 */ "when_clause ::=",
 /* 281 */ "when_clause ::= WHEN expr",
 /* 282 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 283 */ "trigger_cmd_list ::=",
 /* 284 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 285 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 286 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 287 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 288 */ "trigger_cmd ::= select",
 /* 289 */ "expr ::= RAISE LP IGNORE RP",
 /* 290 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 291 */ "raisetype ::= ROLLBACK",
 /* 292 */ "raisetype ::= ABORT",
 /* 293 */ "raisetype ::= FAIL",
 /* 294 */ "cmd ::= DROP TRIGGER fullname",
 /* 295 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 296 */ "key_opt ::=",
 /* 297 */ "key_opt ::= KEY ids",
 /* 298 */ "key_opt ::= KEY BLOB",
 /* 299 */ "database_kw_opt ::= DATABASE",
 /* 300 */ "database_kw_opt ::=",
 /* 301 */ "cmd ::= DETACH database_kw_opt nm",
 /* 302 */ "cmd ::= REINDEX",
 /* 303 */ "cmd ::= REINDEX nm dbnm",
 /* 304 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 157:
    case 189:
    case 206:
#line 325 "parse.y"
{sqlite3SelectDelete((yypminor->yy331));}
#line 1305 "parse.c"
      break;
    case 170:
    case 174:
    case 194:
    case 196:
    case 204:
    case 210:
    case 224:
#line 584 "parse.y"
{sqlite3ExprDelete((yypminor->yy454));}
#line 1316 "parse.c"
      break;
    case 175:
    case 183:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 212:
    case 213:
    case 216:
    case 222:
#line 796 "parse.y"
{sqlite3ExprListDelete((yypminor->yy266));}
#line 1331 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 454 "parse.y"
{sqlite3SrcListDelete((yypminor->yy427));}
#line 1339 "parse.c"
      break;
    case 198:
#line 516 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy348).pLimit);
  sqlite3ExprDelete((yypminor->yy348).pOffset);
}
#line 1347 "parse.c"
      break;
    case 205:
    case 208:
    case 215:
#line 472 "parse.y"
{sqlite3IdListDelete((yypminor->yy272));}
#line 1354 "parse.c"
      break;
    case 230:
    case 235:
#line 889 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy455));}
#line 1360 "parse.c"
      break;
    case 232:
#line 873 "parse.y"
{sqlite3IdListDelete((yypminor->yy62).b);}
#line 1365 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 145, 1 },
  { 144, 1 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 146, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 151, 5 },
  { 153, 1 },
  { 153, 0 },
  { 152, 4 },
  { 152, 2 },
  { 155, 3 },
  { 155, 1 },
  { 158, 3 },
  { 159, 1 },
  { 162, 1 },
  { 163, 1 },
  { 163, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 160, 0 },
  { 160, 1 },
  { 160, 4 },
  { 160, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 161, 2 },
  { 161, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 5 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 173, 0 },
  { 173, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 156, 0 },
  { 156, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 3 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 171, 0 },
  { 171, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 146, 3 },
  { 146, 7 },
  { 146, 3 },
  { 146, 1 },
  { 157, 1 },
  { 157, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 154, 0 },
  { 154, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 5 },
  { 209, 3 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 211, 0 },
  { 211, 2 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 146, 4 },
  { 194, 0 },
  { 194, 2 },
  { 146, 6 },
  { 213, 5 },
  { 213, 3 },
  { 146, 8 },
  { 146, 5 },
  { 214, 2 },
  { 214, 1 },
  { 216, 3 },
  { 216, 1 },
  { 215, 0 },
  { 215, 3 },
  { 208, 3 },
  { 208, 1 },
  { 174, 1 },
  { 174, 3 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 5 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 4 },
  { 174, 4 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 217, 1 },
  { 217, 1 },
  { 217, 2 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 174, 4 },
  { 174, 2 },
  { 174, 3 },
  { 174, 2 },
  { 174, 3 },
  { 174, 4 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 219, 1 },
  { 219, 2 },
  { 174, 5 },
  { 220, 1 },
  { 220, 2 },
  { 174, 5 },
  { 174, 3 },
  { 174, 5 },
  { 174, 4 },
  { 174, 4 },
  { 174, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 212, 3 },
  { 212, 1 },
  { 224, 1 },
  { 224, 0 },
  { 146, 11 },
  { 225, 1 },
  { 225, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 226, 1 },
  { 146, 3 },
  { 146, 1 },
  { 146, 2 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 6 },
  { 146, 3 },
  { 166, 2 },
  { 167, 2 },
  { 228, 1 },
  { 228, 1 },
  { 227, 1 },
  { 227, 0 },
  { 146, 5 },
  { 229, 10 },
  { 231, 1 },
  { 231, 1 },
  { 231, 2 },
  { 231, 0 },
  { 232, 1 },
  { 232, 1 },
  { 232, 1 },
  { 232, 3 },
  { 233, 0 },
  { 233, 3 },
  { 233, 3 },
  { 234, 0 },
  { 234, 2 },
  { 230, 3 },
  { 230, 0 },
  { 235, 6 },
  { 235, 8 },
  { 235, 5 },
  { 235, 4 },
  { 235, 1 },
  { 174, 4 },
  { 174, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 146, 3 },
  { 146, 6 },
  { 237, 0 },
  { 237, 2 },
  { 237, 2 },
  { 236, 1 },
  { 236, 0 },
  { 146, 3 },
  { 146, 1 },
  { 146, 3 },
  { 146, 6 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 84 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1897 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1902 "parse.c"
        break;
      case 7:
#line 89 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1907 "parse.c"
        break;
      case 8:
#line 95 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy60);}
#line 1912 "parse.c"
        break;
      case 12:
#line 100 "parse.y"
{yygotominor.yy60 = TK_DEFERRED;}
#line 1917 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 101:
      case 103:
      case 104:
#line 101 "parse.y"
{yygotominor.yy60 = yymsp[0].major;}
#line 1927 "parse.c"
        break;
      case 16:
      case 17:
#line 104 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1933 "parse.c"
        break;
      case 18:
#line 106 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1938 "parse.c"
        break;
      case 20:
#line 111 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406,yymsp[-3].minor.yy60,0);
}
#line 1945 "parse.c"
        break;
      case 21:
      case 60:
      case 74:
      case 106:
      case 224:
      case 227:
#line 115 "parse.y"
{yygotominor.yy60 = 1;}
#line 1955 "parse.c"
        break;
      case 22:
      case 59:
      case 73:
      case 75:
      case 86:
      case 107:
      case 108:
      case 223:
      case 226:
#line 116 "parse.y"
{yygotominor.yy60 = 0;}
#line 1968 "parse.c"
        break;
      case 23:
#line 117 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1975 "parse.c"
        break;
      case 24:
#line 120 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy331);
  sqlite3SelectDelete(yymsp[0].minor.yy331);
}
#line 1983 "parse.c"
        break;
      case 28:
#line 132 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy406);}
#line 1988 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 263:
      case 264:
#line 138 "parse.y"
{yygotominor.yy406 = yymsp[0].minor.yy0;}
#line 2000 "parse.c"
        break;
      case 36:
#line 193 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy406,&yymsp[0].minor.yy406);}
#line 2005 "parse.c"
        break;
      case 37:
#line 194 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy406,&yymsp[0].minor.yy0);}
#line 2010 "parse.c"
        break;
      case 38:
#line 196 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy406,&yymsp[0].minor.yy0);}
#line 2015 "parse.c"
        break;
      case 39:
      case 114:
      case 115:
      case 126:
      case 146:
      case 251:
      case 261:
      case 262:
#line 198 "parse.y"
{yygotominor.yy406 = yymsp[0].minor.yy406;}
#line 2027 "parse.c"
        break;
      case 40:
#line 199 "parse.y"
{yygotominor.yy406.z=yymsp[-1].minor.yy406.z; yygotominor.yy406.n=yymsp[0].minor.yy406.n+(yymsp[0].minor.yy406.z-yymsp[-1].minor.yy406.z);}
#line 2032 "parse.c"
        break;
      case 41:
#line 201 "parse.y"
{ yygotominor.yy60 = atoi(yymsp[0].minor.yy406.z); }
#line 2037 "parse.c"
        break;
      case 42:
#line 202 "parse.y"
{ yygotominor.yy60 = -atoi(yymsp[0].minor.yy406.z); }
#line 2042 "parse.c"
        break;
      case 47:
      case 48:
#line 207 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy454);}
#line 2048 "parse.c"
        break;
      case 49:
#line 209 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2056 "parse.c"
        break;
      case 50:
#line 213 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy406);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2064 "parse.c"
        break;
      case 52:
#line 222 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy60);}
#line 2069 "parse.c"
        break;
      case 53:
#line 224 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy60,yymsp[0].minor.yy60);}
#line 2074 "parse.c"
        break;
      case 54:
#line 225 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy60,0,0);}
#line 2079 "parse.c"
        break;
      case 56:
#line 228 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy406,yymsp[-1].minor.yy266,yymsp[0].minor.yy60);}
#line 2084 "parse.c"
        break;
      case 57:
#line 229 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy60);}
#line 2089 "parse.c"
        break;
      case 58:
#line 230 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy406.z, yymsp[0].minor.yy406.n);}
#line 2094 "parse.c"
        break;
      case 61:
#line 243 "parse.y"
{ yygotominor.yy60 = OE_Restrict * 0x010101; }
#line 2099 "parse.c"
        break;
      case 62:
#line 244 "parse.y"
{ yygotominor.yy60 = (yymsp[-1].minor.yy60 & yymsp[0].minor.yy243.mask) | yymsp[0].minor.yy243.value; }
#line 2104 "parse.c"
        break;
      case 63:
#line 246 "parse.y"
{ yygotominor.yy243.value = 0;     yygotominor.yy243.mask = 0x000000; }
#line 2109 "parse.c"
        break;
      case 64:
#line 247 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60;     yygotominor.yy243.mask = 0x0000ff; }
#line 2114 "parse.c"
        break;
      case 65:
#line 248 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60<<8;  yygotominor.yy243.mask = 0x00ff00; }
#line 2119 "parse.c"
        break;
      case 66:
#line 249 "parse.y"
{ yygotominor.yy243.value = yymsp[0].minor.yy60<<16; yygotominor.yy243.mask = 0xff0000; }
#line 2124 "parse.c"
        break;
      case 67:
#line 251 "parse.y"
{ yygotominor.yy60 = OE_SetNull; }
#line 2129 "parse.c"
        break;
      case 68:
#line 252 "parse.y"
{ yygotominor.yy60 = OE_SetDflt; }
#line 2134 "parse.c"
        break;
      case 69:
#line 253 "parse.y"
{ yygotominor.yy60 = OE_Cascade; }
#line 2139 "parse.c"
        break;
      case 70:
#line 254 "parse.y"
{ yygotominor.yy60 = OE_Restrict; }
#line 2144 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 89:
      case 91:
      case 92:
      case 163:
#line 256 "parse.y"
{yygotominor.yy60 = yymsp[0].minor.yy60;}
#line 2155 "parse.c"
        break;
      case 82:
#line 273 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy266,yymsp[0].minor.yy60,yymsp[-2].minor.yy60);}
#line 2160 "parse.c"
        break;
      case 83:
#line 275 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy266,yymsp[0].minor.yy60,0,0);}
#line 2165 "parse.c"
        break;
      case 85:
#line 278 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy266, &yymsp[-3].minor.yy406, yymsp[-2].minor.yy266, yymsp[-1].minor.yy60);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy60);
}
#line 2173 "parse.c"
        break;
      case 88:
      case 90:
#line 292 "parse.y"
{yygotominor.yy60 = OE_Default;}
#line 2179 "parse.c"
        break;
      case 93:
#line 297 "parse.y"
{yygotominor.yy60 = OE_Ignore;}
#line 2184 "parse.c"
        break;
      case 94:
      case 164:
#line 298 "parse.y"
{yygotominor.yy60 = OE_Replace;}
#line 2190 "parse.c"
        break;
      case 95:
#line 302 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy427, 0);
}
#line 2197 "parse.c"
        break;
      case 96:
#line 309 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy406, &yymsp[-2].minor.yy406, yymsp[0].minor.yy331, yymsp[-5].minor.yy60);
}
#line 2204 "parse.c"
        break;
      case 97:
#line 312 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy427, 1);
}
#line 2211 "parse.c"
        break;
      case 98:
#line 319 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy331, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy331);
}
#line 2219 "parse.c"
        break;
      case 99:
      case 123:
#line 329 "parse.y"
{yygotominor.yy331 = yymsp[0].minor.yy331;}
#line 2225 "parse.c"
        break;
      case 100:
#line 331 "parse.y"
{
  if( yymsp[0].minor.yy331 ){
    yymsp[0].minor.yy331->op = yymsp[-1].minor.yy60;
    yymsp[0].minor.yy331->pPrior = yymsp[-2].minor.yy331;
  }
  yygotominor.yy331 = yymsp[0].minor.yy331;
}
#line 2236 "parse.c"
        break;
      case 102:
#line 340 "parse.y"
{yygotominor.yy60 = TK_ALL;}
#line 2241 "parse.c"
        break;
      case 105:
#line 345 "parse.y"
{
  yygotominor.yy331 = sqlite3SelectNew(yymsp[-6].minor.yy266,yymsp[-5].minor.yy427,yymsp[-4].minor.yy454,yymsp[-3].minor.yy266,yymsp[-2].minor.yy454,yymsp[-1].minor.yy266,yymsp[-7].minor.yy60,yymsp[0].minor.yy348.pLimit,yymsp[0].minor.yy348.pOffset);
}
#line 2248 "parse.c"
        break;
      case 109:
      case 248:
#line 366 "parse.y"
{yygotominor.yy266 = yymsp[-1].minor.yy266;}
#line 2254 "parse.c"
        break;
      case 110:
      case 137:
      case 147:
      case 247:
#line 367 "parse.y"
{yygotominor.yy266 = 0;}
#line 2262 "parse.c"
        break;
      case 111:
#line 368 "parse.y"
{
   yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-2].minor.yy266,yymsp[-1].minor.yy454,yymsp[0].minor.yy406.n?&yymsp[0].minor.yy406:0);
}
#line 2269 "parse.c"
        break;
      case 112:
#line 371 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-1].minor.yy266, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2276 "parse.c"
        break;
      case 113:
#line 374 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-3].minor.yy266, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2285 "parse.c"
        break;
      case 116:
#line 386 "parse.y"
{yygotominor.yy406.n = 0;}
#line 2290 "parse.c"
        break;
      case 117:
#line 398 "parse.y"
{yygotominor.yy427 = sqliteMalloc(sizeof(*yygotominor.yy427));}
#line 2295 "parse.c"
        break;
      case 118:
#line 399 "parse.y"
{yygotominor.yy427 = yymsp[0].minor.yy427;}
#line 2300 "parse.c"
        break;
      case 119:
#line 404 "parse.y"
{
   yygotominor.yy427 = yymsp[-1].minor.yy427;
   if( yygotominor.yy427 && yygotominor.yy427->nSrc>0 ) yygotominor.yy427->a[yygotominor.yy427->nSrc-1].jointype = yymsp[0].minor.yy60;
}
#line 2308 "parse.c"
        break;
      case 120:
#line 408 "parse.y"
{yygotominor.yy427 = 0;}
#line 2313 "parse.c"
        break;
      case 121:
#line 409 "parse.y"
{
  yygotominor.yy427 = sqlite3SrcListAppend(yymsp[-5].minor.yy427,&yymsp[-4].minor.yy406,&yymsp[-3].minor.yy406);
  if( yymsp[-2].minor.yy406.n ) sqlite3SrcListAddAlias(yygotominor.yy427,&yymsp[-2].minor.yy406);
  if( yymsp[-1].minor.yy454 ){
    if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pOn = yymsp[-1].minor.yy454; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy454); }
  }
  if( yymsp[0].minor.yy272 ){
    if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pUsing = yymsp[0].minor.yy272; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
  }
}
#line 2329 "parse.c"
        break;
      case 122:
#line 423 "parse.y"
{
    yygotominor.yy427 = sqlite3SrcListAppend(yymsp[-6].minor.yy427,0,0);
    yygotominor.yy427->a[yygotominor.yy427->nSrc-1].pSelect = yymsp[-4].minor.yy331;
    if( yymsp[-2].minor.yy406.n ) sqlite3SrcListAddAlias(yygotominor.yy427,&yymsp[-2].minor.yy406);
    if( yymsp[-1].minor.yy454 ){
      if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pOn = yymsp[-1].minor.yy454; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy454); }
    }
    if( yymsp[0].minor.yy272 ){
      if( yygotominor.yy427 && yygotominor.yy427->nSrc>1 ){ yygotominor.yy427->a[yygotominor.yy427->nSrc-2].pUsing = yymsp[0].minor.yy272; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
    }
  }
#line 2346 "parse.c"
        break;
      case 124:
#line 444 "parse.y"
{
     yygotominor.yy331 = sqlite3SelectNew(0,yymsp[0].minor.yy427,0,0,0,0,0,0,0);
  }
#line 2353 "parse.c"
        break;
      case 125:
#line 450 "parse.y"
{yygotominor.yy406.z=0; yygotominor.yy406.n=0;}
#line 2358 "parse.c"
        break;
      case 127:
#line 455 "parse.y"
{yygotominor.yy427 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406);}
#line 2363 "parse.c"
        break;
      case 128:
      case 129:
#line 459 "parse.y"
{ yygotominor.yy60 = JT_INNER; }
#line 2369 "parse.c"
        break;
      case 130:
#line 461 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2374 "parse.c"
        break;
      case 131:
#line 462 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy406,0); }
#line 2379 "parse.c"
        break;
      case 132:
#line 464 "parse.y"
{ yygotominor.yy60 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy406,&yymsp[-1].minor.yy406); }
#line 2384 "parse.c"
        break;
      case 133:
      case 141:
      case 150:
      case 157:
      case 171:
      case 211:
      case 236:
      case 238:
      case 242:
#line 468 "parse.y"
{yygotominor.yy454 = yymsp[0].minor.yy454;}
#line 2397 "parse.c"
        break;
      case 134:
      case 149:
      case 156:
      case 212:
      case 237:
      case 239:
      case 243:
#line 469 "parse.y"
{yygotominor.yy454 = 0;}
#line 2408 "parse.c"
        break;
      case 135:
      case 168:
#line 473 "parse.y"
{yygotominor.yy272 = yymsp[-1].minor.yy272;}
#line 2414 "parse.c"
        break;
      case 136:
      case 167:
#line 474 "parse.y"
{yygotominor.yy272 = 0;}
#line 2420 "parse.c"
        break;
      case 138:
      case 148:
#line 485 "parse.y"
{yygotominor.yy266 = yymsp[0].minor.yy266;}
#line 2426 "parse.c"
        break;
      case 139:
#line 486 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266,yymsp[-2].minor.yy454,yymsp[-1].minor.yy406.n>0?&yymsp[-1].minor.yy406:0);
  if( yygotominor.yy266 ) yygotominor.yy266->a[yygotominor.yy266->nExpr-1].sortOrder = yymsp[0].minor.yy60;
}
#line 2434 "parse.c"
        break;
      case 140:
#line 490 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy454,yymsp[-1].minor.yy406.n>0?&yymsp[-1].minor.yy406:0);
  if( yygotominor.yy266 && yygotominor.yy266->a ) yygotominor.yy266->a[0].sortOrder = yymsp[0].minor.yy60;
}
#line 2442 "parse.c"
        break;
      case 142:
      case 144:
#line 499 "parse.y"
{yygotominor.yy60 = SQLITE_SO_ASC;}
#line 2448 "parse.c"
        break;
      case 143:
#line 500 "parse.y"
{yygotominor.yy60 = SQLITE_SO_DESC;}
#line 2453 "parse.c"
        break;
      case 145:
#line 502 "parse.y"
{yygotominor.yy406.z = 0; yygotominor.yy406.n = 0;}
#line 2458 "parse.c"
        break;
      case 151:
#line 520 "parse.y"
{yygotominor.yy348.pLimit = 0; yygotominor.yy348.pOffset = 0;}
#line 2463 "parse.c"
        break;
      case 152:
#line 521 "parse.y"
{yygotominor.yy348.pLimit = yymsp[0].minor.yy454; yygotominor.yy348.pOffset = 0;}
#line 2468 "parse.c"
        break;
      case 153:
#line 523 "parse.y"
{yygotominor.yy348.pLimit = yymsp[-2].minor.yy454; yygotominor.yy348.pOffset = yymsp[0].minor.yy454;}
#line 2473 "parse.c"
        break;
      case 154:
#line 525 "parse.y"
{yygotominor.yy348.pOffset = yymsp[-2].minor.yy454; yygotominor.yy348.pLimit = yymsp[0].minor.yy454;}
#line 2478 "parse.c"
        break;
      case 155:
#line 529 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy427,yymsp[0].minor.yy454);}
#line 2483 "parse.c"
        break;
      case 158:
#line 543 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy427,yymsp[-1].minor.yy266,yymsp[0].minor.yy454,yymsp[-4].minor.yy60);}
#line 2488 "parse.c"
        break;
      case 159:
#line 546 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266,yymsp[0].minor.yy454,&yymsp[-2].minor.yy406);}
#line 2493 "parse.c"
        break;
      case 160:
#line 547 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[0].minor.yy454,&yymsp[-2].minor.yy406);}
#line 2498 "parse.c"
        break;
      case 161:
#line 553 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy427, yymsp[-1].minor.yy266, 0, yymsp[-4].minor.yy272, yymsp[-7].minor.yy60);}
#line 2503 "parse.c"
        break;
      case 162:
#line 555 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy427, 0, yymsp[0].minor.yy331, yymsp[-1].minor.yy272, yymsp[-4].minor.yy60);}
#line 2508 "parse.c"
        break;
      case 165:
      case 240:
#line 565 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-2].minor.yy266,yymsp[0].minor.yy454,0);}
#line 2514 "parse.c"
        break;
      case 166:
      case 241:
#line 566 "parse.y"
{yygotominor.yy266 = sqlite3ExprListAppend(0,yymsp[0].minor.yy454,0);}
#line 2520 "parse.c"
        break;
      case 169:
#line 575 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(yymsp[-2].minor.yy272,&yymsp[0].minor.yy406);}
#line 2525 "parse.c"
        break;
      case 170:
#line 576 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(0,&yymsp[0].minor.yy406);}
#line 2530 "parse.c"
        break;
      case 172:
#line 587 "parse.y"
{yygotominor.yy454 = yymsp[-1].minor.yy454; sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2535 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 588 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2544 "parse.c"
        break;
      case 174:
      case 175:
#line 589 "parse.y"
{yygotominor.yy454 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2550 "parse.c"
        break;
      case 176:
#line 591 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy406);
  yygotominor.yy454 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2559 "parse.c"
        break;
      case 177:
#line 596 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy406);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy406);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy406);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy454 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2570 "parse.c"
        break;
      case 182:
#line 607 "parse.y"
{yygotominor.yy454 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2575 "parse.c"
        break;
      case 183:
#line 608 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy454 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2584 "parse.c"
        break;
      case 184:
#line 613 "parse.y"
{
  yygotominor.yy454 = sqlite3ExprFunction(yymsp[-1].minor.yy266, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2592 "parse.c"
        break;
      case 185:
#line 617 "parse.y"
{
  yygotominor.yy454 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2600 "parse.c"
        break;
      case 186:
      case 187:
      case 188:
#line 621 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[0].major,0,0,0);}
#line 2607 "parse.c"
        break;
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
#line 624 "parse.y"
{yygotominor.yy454 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy454, yymsp[0].minor.yy454, 0);}
#line 2629 "parse.c"
        break;
      case 207:
#line 643 "parse.y"
{yygotominor.yy258.opcode = TK_LIKE; yygotominor.yy258.not = 0;}
#line 2634 "parse.c"
        break;
      case 208:
#line 644 "parse.y"
{yygotominor.yy258.opcode = TK_GLOB; yygotominor.yy258.not = 0;}
#line 2639 "parse.c"
        break;
      case 209:
#line 645 "parse.y"
{yygotominor.yy258.opcode = TK_LIKE; yygotominor.yy258.not = 1;}
#line 2644 "parse.c"
        break;
      case 210:
#line 646 "parse.y"
{yygotominor.yy258.opcode = TK_GLOB; yygotominor.yy258.not = 1;}
#line 2649 "parse.c"
        break;
      case 213:
#line 650 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy454, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy454, 0);
  if( yymsp[0].minor.yy454 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy454, 0);
  }
  yygotominor.yy454 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->op = yymsp[-2].minor.yy258.opcode;
  if( yymsp[-2].minor.yy258.not ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-3].minor.yy454->span, &yymsp[-1].minor.yy454->span);
}
#line 2664 "parse.c"
        break;
      case 214:
#line 662 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2672 "parse.c"
        break;
      case 215:
#line 666 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2680 "parse.c"
        break;
      case 216:
#line 670 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2688 "parse.c"
        break;
      case 217:
#line 674 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2696 "parse.c"
        break;
      case 218:
#line 678 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy454->span,&yymsp[0].minor.yy0);
}
#line 2704 "parse.c"
        break;
      case 219:
      case 220:
#line 682 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2713 "parse.c"
        break;
      case 221:
#line 690 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2721 "parse.c"
        break;
      case 222:
#line 694 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy454->span);
}
#line 2729 "parse.c"
        break;
      case 225:
#line 701 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy454, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy454, 0);
  yygotominor.yy454 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy454, 0, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->pList = pList;
  if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
  sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy454->span);
}
#line 2741 "parse.c"
        break;
      case 228:
#line 713 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pList = yymsp[-1].minor.yy266;
    if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy0);
  }
#line 2751 "parse.c"
        break;
      case 229:
#line 719 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = yymsp[-1].minor.yy331;
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2760 "parse.c"
        break;
      case 230:
#line 724 "parse.y"
{
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = yymsp[-1].minor.yy331;
    if( yymsp[-3].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-4].minor.yy454->span,&yymsp[0].minor.yy0);
  }
#line 2770 "parse.c"
        break;
      case 231:
#line 730 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406);
    yygotominor.yy454 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy454, 0, 0);
    if( yygotominor.yy454 ) yygotominor.yy454->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    if( yymsp[-2].minor.yy60 ) yygotominor.yy454 = sqlite3Expr(TK_NOT, yygotominor.yy454, 0, 0);
    sqlite3ExprSpan(yygotominor.yy454,&yymsp[-3].minor.yy454->span,yymsp[0].minor.yy406.z?&yymsp[0].minor.yy406:&yymsp[-1].minor.yy406);
  }
#line 2781 "parse.c"
        break;
      case 232:
#line 737 "parse.y"
{
    Expr *p = yygotominor.yy454 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy331;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }
  }
#line 2792 "parse.c"
        break;
      case 233:
#line 747 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy454, yymsp[-1].minor.yy454, 0);
  if( yygotominor.yy454 ) yygotominor.yy454->pList = yymsp[-2].minor.yy266;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2801 "parse.c"
        break;
      case 234:
#line 754 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266, yymsp[-2].minor.yy454, 0);
  yygotominor.yy266 = sqlite3ExprListAppend(yygotominor.yy266, yymsp[0].minor.yy454, 0);
}
#line 2809 "parse.c"
        break;
      case 235:
#line 758 "parse.y"
{
  yygotominor.yy266 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy454, 0);
  yygotominor.yy266 = sqlite3ExprListAppend(yygotominor.yy266, yymsp[0].minor.yy454, 0);
}
#line 2817 "parse.c"
        break;
      case 244:
#line 783 "parse.y"
{
  if( yymsp[-9].minor.yy60!=OE_None ) yymsp[-9].minor.yy60 = yymsp[0].minor.yy60;
  if( yymsp[-9].minor.yy60==OE_Default) yymsp[-9].minor.yy60 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy406, &yymsp[-6].minor.yy406, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy406,0),yymsp[-2].minor.yy266,yymsp[-9].minor.yy60, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2826 "parse.c"
        break;
      case 245:
      case 292:
#line 790 "parse.y"
{yygotominor.yy60 = OE_Abort;}
#line 2832 "parse.c"
        break;
      case 246:
#line 791 "parse.y"
{yygotominor.yy60 = OE_None;}
#line 2837 "parse.c"
        break;
      case 249:
#line 801 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy406.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy406.z, yymsp[-1].minor.yy406.n);
  }
  yygotominor.yy266 = sqlite3ExprListAppend(yymsp[-4].minor.yy266, p, &yymsp[-2].minor.yy406);
}
#line 2849 "parse.c"
        break;
      case 250:
#line 809 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy406.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy406.z, yymsp[-1].minor.yy406.n);
  }
  yygotominor.yy266 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy406);
}
#line 2861 "parse.c"
        break;
      case 252:
#line 822 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy427);}
#line 2866 "parse.c"
        break;
      case 253:
      case 254:
#line 826 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2872 "parse.c"
        break;
      case 255:
      case 257:
#line 832 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy406,0);}
#line 2878 "parse.c"
        break;
      case 256:
#line 833 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy0,0);}
#line 2883 "parse.c"
        break;
      case 258:
#line 835 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy406,&yymsp[-2].minor.yy406,&yymsp[0].minor.yy406,1);
}
#line 2890 "parse.c"
        break;
      case 259:
#line 838 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy406,&yymsp[-3].minor.yy406,&yymsp[-1].minor.yy406,0);}
#line 2895 "parse.c"
        break;
      case 260:
#line 839 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy406,&yymsp[0].minor.yy406,0,0);}
#line 2900 "parse.c"
        break;
      case 267:
#line 852 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy406.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy406.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy455, &all);
}
#line 2910 "parse.c"
        break;
      case 268:
#line 861 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy406, &yymsp[-6].minor.yy406, yymsp[-5].minor.yy60, yymsp[-4].minor.yy62.a, yymsp[-4].minor.yy62.b, yymsp[-2].minor.yy427, yymsp[-1].minor.yy60, yymsp[0].minor.yy454, yymsp[-9].minor.yy60);
  yygotominor.yy406 = (yymsp[-6].minor.yy406.n==0?yymsp[-7].minor.yy406:yymsp[-6].minor.yy406);
}
#line 2918 "parse.c"
        break;
      case 269:
      case 272:
#line 867 "parse.y"
{ yygotominor.yy60 = TK_BEFORE; }
#line 2924 "parse.c"
        break;
      case 270:
#line 868 "parse.y"
{ yygotominor.yy60 = TK_AFTER;  }
#line 2929 "parse.c"
        break;
      case 271:
#line 869 "parse.y"
{ yygotominor.yy60 = TK_INSTEAD;}
#line 2934 "parse.c"
        break;
      case 273:
      case 274:
      case 275:
#line 874 "parse.y"
{yygotominor.yy62.a = yymsp[0].major; yygotominor.yy62.b = 0;}
#line 2941 "parse.c"
        break;
      case 276:
#line 877 "parse.y"
{yygotominor.yy62.a = TK_UPDATE; yygotominor.yy62.b = yymsp[0].minor.yy272;}
#line 2946 "parse.c"
        break;
      case 277:
      case 278:
#line 880 "parse.y"
{ yygotominor.yy60 = TK_ROW; }
#line 2952 "parse.c"
        break;
      case 279:
#line 882 "parse.y"
{ yygotominor.yy60 = TK_STATEMENT; }
#line 2957 "parse.c"
        break;
      case 280:
#line 885 "parse.y"
{ yygotominor.yy454 = 0; }
#line 2962 "parse.c"
        break;
      case 281:
#line 886 "parse.y"
{ yygotominor.yy454 = yymsp[0].minor.yy454; }
#line 2967 "parse.c"
        break;
      case 282:
#line 890 "parse.y"
{
  yymsp[-2].minor.yy455->pNext = yymsp[0].minor.yy455;
  yygotominor.yy455 = yymsp[-2].minor.yy455;
}
#line 2975 "parse.c"
        break;
      case 283:
#line 894 "parse.y"
{ yygotominor.yy455 = 0; }
#line 2980 "parse.c"
        break;
      case 284:
#line 900 "parse.y"
{ yygotominor.yy455 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy406, yymsp[-1].minor.yy266, yymsp[0].minor.yy454, yymsp[-4].minor.yy60); }
#line 2985 "parse.c"
        break;
      case 285:
#line 905 "parse.y"
{yygotominor.yy455 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy406, yymsp[-4].minor.yy272, yymsp[-1].minor.yy266, 0, yymsp[-7].minor.yy60);}
#line 2990 "parse.c"
        break;
      case 286:
#line 908 "parse.y"
{yygotominor.yy455 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy406, yymsp[-1].minor.yy272, 0, yymsp[0].minor.yy331, yymsp[-4].minor.yy60);}
#line 2995 "parse.c"
        break;
      case 287:
#line 912 "parse.y"
{yygotominor.yy455 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy406, yymsp[0].minor.yy454);}
#line 3000 "parse.c"
        break;
      case 288:
#line 915 "parse.y"
{yygotominor.yy455 = sqlite3TriggerSelectStep(yymsp[0].minor.yy331); }
#line 3005 "parse.c"
        break;
      case 289:
#line 918 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy454->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3014 "parse.c"
        break;
      case 290:
#line 923 "parse.y"
{
  yygotominor.yy454 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy406); 
  yygotominor.yy454->iColumn = yymsp[-3].minor.yy60;
  sqlite3ExprSpan(yygotominor.yy454, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3023 "parse.c"
        break;
      case 291:
#line 931 "parse.y"
{yygotominor.yy60 = OE_Rollback;}
#line 3028 "parse.c"
        break;
      case 293:
#line 933 "parse.y"
{yygotominor.yy60 = OE_Fail;}
#line 3033 "parse.c"
        break;
      case 294:
#line 938 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy427);
}
#line 3040 "parse.c"
        break;
      case 295:
#line 944 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy406, &yymsp[-1].minor.yy406, yymsp[0].minor.yy40.type, &yymsp[0].minor.yy40.key);
}
#line 3047 "parse.c"
        break;
      case 296:
#line 948 "parse.y"
{ yygotominor.yy40.type = 0; }
#line 3052 "parse.c"
        break;
      case 297:
#line 949 "parse.y"
{ yygotominor.yy40.type=1; yygotominor.yy40.key = yymsp[0].minor.yy406; }
#line 3057 "parse.c"
        break;
      case 298:
#line 950 "parse.y"
{ yygotominor.yy40.type=2; yygotominor.yy40.key = yymsp[0].minor.yy0; }
#line 3062 "parse.c"
        break;
      case 301:
#line 956 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy406);
}
#line 3069 "parse.c"
        break;
      case 302:
#line 962 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3074 "parse.c"
        break;
      case 303:
#line 963 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy406, &yymsp[0].minor.yy406);}
#line 3079 "parse.c"
        break;
      case 304:
#line 968 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy427,&yymsp[0].minor.yy406);
}
#line 3086 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3153 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
