use strict;
use warnings FATAL => 'all';
use Module::Build;

my $build = Module::Build->new(
    license              => 'perl',
    recursive_test_files => 1,
    dynamic_config       => 0,
    build_requires       => {
        'Test::Requires' => '0.05',
        'YAML'           => '0'
    },
    configure_requires => { 'Module::Build' => '0.38' },
    requires           => {
        'perl'                  => '5.008001',
        'Scalar::Util'          => '1.19',
        'Filter::Util::Call'    => '0',
        'UNIVERSAL::require'    => '0.11',
        'Class::Accessor::Lite' => '0.05',
        'CGI'                   => '3.31'
    },
    no_index    => { 'directory' => [ 't', 'inc' ] },
    name        => 'FormValidator-Lite',
    module_name => 'FormValidator::Lite',

    test_files => ( -d '.git' || $ENV{RELEASE_TESTING} ) ? 't/ xt/' : 't/',

    create_readme  => 1,
    create_license => 1,
);
$build->create_build_script();
