use strict;
use warnings;

use Test::More tests => 149;

BEGIN { use_ok 'Range::Object::Extension' };

my $tests = eval do { local $/; <DATA>; };
die "Data eval error: $@" if $@;

die "Nothing to test!" unless $tests;

require 't/tests.pl';

run_tests( $tests );

__DATA__
[
    'Range::Object::Extension' => [
        # Custom code
        undef,

        # Invalid input
        [ '00*00', '12345678901234567', '', '&9999', 'foo', '%123' ],

        # Valid input
        [ '*00', '#00', '0000-0010', '1234', '157863', '*0123', '#9999' ],

        # Valid in() items
        [ '*00', '#00', qw(0000 0001 0002 0003 0004 0005 0006 0007 0008
          0009 0010 1234 157863), '*0123', '#9999' ],

        # Not in() input
        [ '*01', '#02', '0011', '*1234', '157862', '#0123', '*9999' ],

        # Not in() output
        [ '*01', '#02', '0011', '*1234', '157862', '#0123', '*9999' ],

        # List context range() output
        [ '#00', '#9999', '*00', '*0123',
          qw(0000 0001 0002 0003 0004 0005 0006 0007 0008
          0009 0010 1234 157863) ],

        # Scalar context range() output
        '#00,#9999,*00,*0123,0000,0001,0002,0003,0004,0005,0006,0007,'.
        '0008,0009,0010,1234,157863',

        # List context collapsed() output
        [ '#00', '#9999', '*00', '*0123',
          { start => '0000', end => '0010', count => 11 },
          '1234', '157863' ],

        # Scalar context collapsed() output
        '#00,#9999,*00,*0123,0000-0010,1234,157863',

        # Initial range size()
        17,

        # add() input
        [ qw(*1000-*1003), '#01-#03' ],

        # Valid in() items after add()
        [ '#00', '#01', '#02', '#03', '#9999',
          qw(*00 *1000 *1001 *1002 *1003 *0123
             0000 0001 0002 0003 0004 0005 0006 0007 0008 0009 0010
             1234 157863) ],

        # Not in() input
        [ '*01', '*02', '0011', '*1234', '157862', '#0123', '*9999' ],

        # Not in() output
        [ '*01', '*02', '0011', '*1234', '157862', '#0123', '*9999' ],

        # List context range() output after add()
        [ '#00', '#01', '#02', '#03', '#9999',
          qw(*00 *0123 *1000 *1001 *1002 *1003
             0000 0001 0002 0003 0004 0005 0006 0007 0008 0009 0010
             1234 157863) ],

        # Scalar context range() output after add()
        '#00,#01,#02,#03,#9999,*00,*0123,*1000,*1001,*1002,*1003,'.
        '0000,0001,0002,0003,0004,0005,0006,0007,0008,0009,0010,'.
        '1234,157863',

        # List context collapsed() output after add()
        [ { start => '#00',   end => '#03',   count => 4  },
          '#9999', '*00', '*0123',
          { start => '*1000', end => '*1003', count => 4  },
          { start => '0000',  end => '0010',  count => 11 },
          '1234','157863' ],

        # Scalar context collapsed() output after add()
        '#00-#03,#9999,*00,*0123,*1000-*1003,0000-0010,1234,157863',

        # size() after add()
        24,

        # remove() input
        [ '#00-#02', '0001-0007', '157863' ],

        # Valid in() items after remove()
        [ '#03', '#9999',
          qw(*00 *0123 *1000 *1001 *1002 *1003 0000 0008 0009 0010 1234) ],

        # Not in() input after remove()
        [ '*01', '*02', '0011', '*1234', '157862', '#0123', '*9999',
          '#00', '#01', '#02', qw(0001 0002 0003 0004 0005 0006 0007),
          '157863' ],

        # Not in() output
        [ '*01', '*02', '0011', '*1234', '157862', '#0123', '*9999',
          '#00', '#01', '#02', qw(0001 0002 0003 0004 0005 0006 0007),
          '157863' ],

        # List context range() output after remove()
        [ '#03', '#9999',
          qw(*00 *0123 *1000 *1001 *1002 *1003 0000 0008 0009 0010 1234) ],

        # Scalar context range() output after remove()
        '#03,#9999,*00,*0123,*1000,*1001,*1002,*1003,0000,0008,0009,0010,1234',

        # List context collapsed() output after remove()
        [ '#03', '#9999', '*00', '*0123',
          { start => '*1000', end => '*1003', count => 4 }, '0000',
          { start => '0008',  end => '0010',  count => 3 }, '1234', ],

        # Scalar context collapsed() output after remove()
        '#03,#9999,*00,*0123,*1000-*1003,0000,0008-0010,1234',

        # size() after remove()
        13,
    ],
]
