use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name       => 'Class::Sniff',
    license           => 'perl',
    dist_author       => 'Curtis "Ovid" Poe <ovid@cpan.org>',
    dist_version_from => 'lib/Class/Sniff.pm',
    requires => {
        'B::Concise'        => 0.66,
        'Devel::Symdump'    => 2.08,
        'Digest::MD5'       => 2.36,
        'Graph::Easy'       => 0.64,
        'List::MoreUtils'   => 0.22,
        'Sub::Information'  => 0.02, 
        'Text::SimpleTable' => 0.05,
        'Tree'              => 1.01,
    },
    build_requires    => {
        'Test::Most'        => 0.20,
    },
    add_to_cleanup     => ['Class-Sniff-*'],
    create_makefile_pl => 'traditional',
);

$builder->create_build_script();
