# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: Authen-PAAS.spec.PL,v 1.4 2005/08/21 10:57:05 dan Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do "lib/Authen/PAAS.pm")
  {
    if ($@) { die $@ }
    die "lib/Authen/PAAS.pm: $!"
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Authen::PAAS::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by perl-Authen-PAAS-CGI.spec.PL

%define perlvendorarch %(perl -e 'use Config; print $Config{installvendorarch}')
%define perlvendorlib %(perl -e 'use Config; print $Config{installvendorlib}')
%define perlvendorprefix %(perl -e 'use Config; print $Config{vendorprefix}')
%define perlvendorman3 %{perlvendorprefix}/share/man/man3
%define perlvendorman1 %{perlvendorprefix}/share/man/man1
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname Authen-PAAS

Summary: Perl authentication & authorization modules 
Name: perl-%{appname}
Version: @VERSION@
Release: 1
License: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl >= %{perlversion}
Requires: perl-Config-Record >= 1.1.0
Requires: perl-Log-Log4perl

%description
Authen::PAAS is a pure Perl equivalent of PAM or JAAS authentication
frameworks

%prep
%setup -q -n %{appname}-%{version}

%build
%__perl Makefile.PL PREFIX=/usr INSTALLDIRS=vendor
%__make

%install
%__rm -rf $RPM_BUILD_ROOT

export PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
make sysconfdir=/etc INSTALLVENDORMAN3DIR=%{perlvendorman3} INSTALLVENDORMAN1DIR=%{perlvendorman1} install
find $RPM_BUILD_ROOT -name perllocal.pod -exec rm -f {} \;
find $RPM_BUILD_ROOT -name .packlist -exec rm -f {} \;

%clean
%__rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc examples README CHANGES COPYING

# Man pages
%{perlvendorman1}/*
%{perlvendorman3}/*
%{_bindir}/authen-paas-passwd

# Scripts & modules
%{perlvendorlib}/Authen/PAAS.pm
%{perlvendorlib}/Authen/PAAS/

