#!/usr/bin/perl -w

use File::Compare;
use File::Path;

my $par = 'perl ../par';
my $unpar = 'perl ../unpar';
my $dir = 'temp';

mkdir $dir, 0777 or die "Couldn't mkdir '$dir': $!";

system("$par -q robert.frost mog.gif moogles | $unpar -qcd $dir")
    == 0 or die "Couldn't run par/unpar: $!";

my $error = 0;
my %saw;
for (qw[
    robert.frost
    mog.gif
    moogles/aisukuriimu.yum
    moogles/kulock.gif
    moogles/kurago.gif
    moogles/kurune.gif
]) {
    $error++ unless compare($_, "$dir/$_") == 0;
    $saw{$_, (stat $_       )[2,7,8,9]}++;
    $saw{$_, (stat "$dir/$_")[2,7,8,9]} or $error++;
}

print "1..1\n";
print $error ? "not ok 1\n" : "ok 1\n";

rmtree $dir;
