#!/usr/bin/perl -w

# -c, -e, -n, -u, -S

use strict;
use Test; plan tests => 12;
use File::Copy;
use File::Compare;

# This should just extract and apply the diffs from our pseudo-news-article.

for (qw/c e n u/) {
    copy('article.old', "article.$_.txt")
        or die "Couldn't copy article.old: $!";
}

system("perl ../patch -s < article.diff") == 0 or die "Couldn't patch: $!";

for (qw/c e n u/) {
    ok(compare('article.new', "article.$_.txt") == 0);
}

unlink <*txt*> or die "Couldn't unlink files: $!";

# Apply only certain types of diffs...
# -c, -e, -n, -u

for (qw/c e n u/) {
    copy('article.old', "article.$_.txt")
        or die "Couldn't copy article.old: $!";
}

# Right order.
system("perl ../patch -sc + -se + -sn + -su < article.diff") == 0
    or die "Couldn't patch: $!";

# Wrong order.
system(
    "perl ../patch -seo art.e.txt + -sno art.n.txt + -suo art.u.txt " .
    " + -sco art.c.txt < article.diff"
) == 0 or die "Couldn't patch: $!";

for (qw/c e n u/) {
    ok(
        compare('article.new', "article.$_.txt") == 0 &&
        compare('article.new', "art.$_.txt") != 0
    );
}

unlink <*txt*> or die "Couldn't unlink files: $!";

# Skip the second and fourth diffs in file...
# -S

for (qw/c e n u/) {
    copy('article.old', "article.$_.txt")
        or die "Couldn't copy article.old: $!";
}

system("perl ../patch -s + -sS + -s + -sS < article.diff") == 0
    or die "Couldn't patch: $!";

ok(compare('article.new', 'article.c.txt') == 0);
ok(compare('article.old', 'article.e.txt') == 0); # -S
ok(compare('article.new', 'article.n.txt') == 0);
ok(compare('article.old', 'article.u.txt') == 0); # -S

unlink <*txt*> or die "Couldn't unlink files: $!";

