
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601"
  },
  "configure_requires" => {
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "A Rinci transaction manager",
  "dist_author" => [
    "Steven Haryanto <stevenharyanto\@gmail.com>"
  ],
  "dist_name" => "Perinci-Tx-Manager",
  "dist_version" => "0.45",
  "license" => "perl",
  "module_name" => "Perinci::Tx::Manager",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "DBD::SQLite" => 0,
    "DBI" => 0,
    "File::Flock" => 0,
    "File::Remove" => 0,
    "JSON" => 0,
    "Log::Any" => 0,
    "Riap" => "v1.1.14",
    "Rinci" => "v1.1.29",
    "SHARYANTO::Package::Util" => 0,
    "UUID::Random" => 0,
    "experimental" => 0,
    "perl" => "5.010001"
  },
  "script_files" => [],
  "test_requires" => {
    "Capture::Tiny" => 0,
    "File::chdir" => 0,
    "Perinci::Access::Schemeless" => "0.32",
    "Test::More" => "0.98",
    "UUID::Random" => 0,
    "blib" => 0
  }
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  my $tr = delete $module_build_args{test_requires};
  my $br = $module_build_args{build_requires};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
