use strict;
use Test::More tests => 72;

use_ok('Number::Phone::JP', 'mobile');

my $tel  = Number::Phone::JP->new;
my $line = 37;

for (1..$line) {
	my $num = <DATA>;
	chomp $num;
	ok($tel->set_number($num)->is_valid_number);
}

while (<DATA>) {
	chomp;
	ok(! $tel->set_number($_)->is_valid_number);
}

__DATA__
090 12345678
090 23456789
090 34567890
090 45678901
090 56789012
090 67890123
090 78901234
090 89012345
090 90123456
080 10012345
080 11012345
080 12012345
080 13012345
080 14012345
080 16012345
080 16712345
080 17012345
080 18012345
080 19012345
080 30012345
080 31012345
080 32012345
080 33812345
080 34012345
080 36112345
080 37412345
080 38012345
080 39212345
080 50012345
080 51012345
080 52012345
080 54012345
080 55512345
080 55812345
080 56012345
080 57012345
080 57112345
090 01234567
090 02345678
090 03456789
090 04567890
090 05678901
090 06789012
090 07890123
090 08901234
090 09012345
090 123456789
080 13312345
080 14812345
080 15012345
080 15912345
080 16312345
080 16612345
080 18612345
080 19612345
080 32912345
080 33712345
080 34612345
080 35012345
080 36012345
080 37012345
080 38112345
080 39312345
080 51212345
080 52412345
080 53012345
080 54712345
080 55612345
080 56112345
080 57212345
080 100123456
