/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;

public class CSSStyleRuleImpl
extends AbstractCSSRuleImpl
implements CSSStyleRule,
Serializable {
    private static final long serialVersionUID = -697009251364657426L;
    private SelectorList selectors = null;
    private CSSStyleDeclaration style = null;

    public SelectorList getSelectors() {
        return this.selectors;
    }

    public void setSelectors(SelectorList selectors) {
        this.selectors = selectors;
    }

    public CSSStyleRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, SelectorList selectors) {
        super(parentStyleSheet, parentRule);
        this.selectors = selectors;
    }

    public CSSStyleRuleImpl() {
    }

    public short getType() {
        return 1;
    }

    public String getCssText() {
        return this.getSelectorText() + " { " + this.getStyle().getCssText() + " }";
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 1) {
                throw new DOMExceptionImpl(13, 4);
            }
            this.selectors = ((CSSStyleRuleImpl)r).selectors;
            this.style = ((CSSStyleRuleImpl)r).style;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getSelectorText() {
        return this.selectors.toString();
    }

    public void setSelectorText(String selectorText) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(selectorText));
            CSSOMParser parser = new CSSOMParser();
            this.selectors = parser.parseSelectors(is);
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclaration getStyle() {
        return this.style;
    }

    public void setStyle(CSSStyleDeclaration style) {
        this.style = style;
    }

    public String toString() {
        return this.getCssText();
    }
}

