/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptExecutor
implements Runnable,
Serializable {
    private transient WeakReference<WebClient> webClient_;
    private transient List<WeakReference<JavaScriptJobManager>> jobManagerList_ = new ArrayList<WeakReference<JavaScriptJobManager>>();
    private volatile boolean shutdown_ = false;
    private transient Thread eventLoopThread_ = null;
    private static final Log LOG = LogFactory.getLog(JavaScriptExecutor.class);

    public JavaScriptExecutor(WebClient webClient) {
        this.webClient_ = new WeakReference<WebClient>(webClient);
    }

    protected void startThreadIfNeeded() {
        if (this.eventLoopThread_ == null) {
            this.eventLoopThread_ = new Thread((Runnable)this, "JS executor for " + this.webClient_.get());
            this.eventLoopThread_.setDaemon(true);
            this.eventLoopThread_.start();
        }
    }

    private void killThread() {
        if (this.eventLoopThread_ == null) {
            return;
        }
        try {
            this.eventLoopThread_.interrupt();
            this.eventLoopThread_.join(10000L);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("InterruptedException while waiting for the eventLoop thread to join " + e));
        }
        if (this.eventLoopThread_.isAlive()) {
            LOG.warn((Object)("Event loop thread " + this.eventLoopThread_.getName() + " still alive at " + System.currentTimeMillis()));
        }
    }

    protected synchronized JavaScriptJobManager getJobManagerWithEarliestJob() {
        JavaScriptJobManager javaScriptJobManager = null;
        JavaScriptJob earliestJob = null;
        for (WeakReference<JavaScriptJobManager> jobManagerRef : this.jobManagerList_) {
            JavaScriptJob newJob;
            JavaScriptJobManager jobManager = (JavaScriptJobManager)jobManagerRef.get();
            if (jobManager == null || (newJob = jobManager.getEarliestJob()) == null || earliestJob != null && earliestJob.compareTo(newJob) <= 0) continue;
            earliestJob = newJob;
            javaScriptJobManager = jobManager;
        }
        return javaScriptJobManager;
    }

    public int pumpEventLoop(long timeoutMillis) {
        return 0;
    }

    public void run() {
        long sleepInterval = 10L;
        while (!this.shutdown_ && this.webClient_.get() != null) {
            long waitTime;
            JavaScriptJob earliestJob;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("started finding earliestJob at " + System.currentTimeMillis()));
            }
            JavaScriptJobManager jobManager = this.getJobManagerWithEarliestJob();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("stopped finding earliestJob at " + System.currentTimeMillis()));
            }
            if (jobManager != null && (earliestJob = jobManager.getEarliestJob()) != null && (waitTime = earliestJob.getTargetExecutionTime() - System.currentTimeMillis()) < 1L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("started executing job at " + System.currentTimeMillis()));
                }
                jobManager.runSingleJob(earliestJob);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("stopped executing job at " + System.currentTimeMillis()));
                continue;
            }
            if (this.shutdown_ || this.webClient_.get() == null) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
    }

    public synchronized void addWindow(WebWindow newWindow) {
        JavaScriptJobManager jobManager = newWindow.getJobManager();
        if (jobManager != null && !this.contains(jobManager)) {
            this.jobManagerList_.add(new WeakReference<JavaScriptJobManager>(jobManager));
            this.startThreadIfNeeded();
        }
    }

    private boolean contains(JavaScriptJobManager newJobManager) {
        for (WeakReference<JavaScriptJobManager> jobManagerRef : this.jobManagerList_) {
            if (jobManagerRef.get() != newJobManager) continue;
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.shutdown_ = true;
        this.killThread();
    }
}

