/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 35 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };


#line 34 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqliteParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqliteParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqliteParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqliteParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqliteParserARG_STORE     Code to store %extra_argument into yypParser
**    sqliteParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 220
#define YYACTIONTYPE unsigned short int
#define sqliteParserTOKENTYPE Token
typedef union {
  sqliteParserTOKENTYPE yy0;
  struct LimitVal yy22;
  Expr* yy164;
  Expr * yy206;
  ExprList* yy232;
  IdList* yy246;
  SrcList* yy283;
  struct {int value; int mask;} yy299;
  Token yy318;
  TriggerStep * yy353;
  Select* yy375;
  struct TrigEvent yy414;
  int yy424;
  int yy439;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqliteParserARG_SDECL Parse *pParse;
#define sqliteParserARG_PDECL ,Parse *pParse
#define sqliteParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqliteParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 561
#define YYNRULE 291
#define YYERRORSYMBOL 155
#define YYERRSYMDT yy439
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   104,  264,  174,  219,  215,   43,  162,  129,   20,  131,
 /*    10 */   491,  103,  538,  461,  535,   62,  480,  331,  374,  330,
 /*    20 */   154,  537,  539,   22,   41,  837,  106,  361,  336,  333,
 /*    30 */    69,  506,  543,    5,   69,  106,  174,  219,  244,  536,
 /*    40 */   127,  168,  545,   14,  185,  282,  283,  284,  464,  123,
 /*    50 */   143,  377,  119,  259,  262,  237,   95,  225,  166,   20,
 /*    60 */   106,   21,  278,  328,  177,  184,  157,  156,  183,  154,
 /*    70 */   275,  121,  142,  570,   22,  133,  117,  276,  146,  125,
 /*    80 */   139,  161,   46,   18,   44,  276,  115,   73,  144,  106,
 /*    90 */    15,   83,   54,  152,  308,  363,  174,  219,  233,  135,
 /*   100 */   112,  143,   16,  150,  449,  148,   86,  263,  104,  229,
 /*   110 */    64,  333,   21,  542,  162,  129,   84,  131,   60,  111,
 /*   120 */   106,  369,  374,  142,   69,   67,  289,   75,  154,  479,
 /*   130 */    68,  361,  541,  224,  179,  231,  175,   62,  105,  331,
 /*   140 */   251,   17,  152,   13,  181,  172,  516,  193,  127,  103,
 /*   150 */    20,  333,  150,  106,  148,  377,   73,  123,  143,  264,
 /*   160 */   119,  313,  154,   66,  386,   22,  166,  461,  171,  315,
 /*   170 */   230,  346,  177,  106,  157,  156,  183,  321,  113,  121,
 /*   180 */   142,  338,  274,  133,  117,  455,  146,  125,  139,  161,
 /*   190 */   339,  252,  253,   97,  115,   20,  144,   36,   37,  363,
 /*   200 */   358,  152,  232,   21,   46,  343,   44,  135,  112,  347,
 /*   210 */    22,  150,  262,  148,   54,  340,  308,  104,   64,  169,
 /*   220 */   146,  687,   73,  162,  129,  369,  131,  111,  172,  159,
 /*   230 */   144,  158,  790,   67,  337,  152,  357,  154,   68,    1,
 /*   240 */    60,  172,  179,  514,  175,  150,  105,  148,   21,  395,
 /*   250 */   172,  171,  181,  441,  560,  193,    3,  127,  430,   20,
 /*   260 */   390,  322,  201,  329,  171,  263,  123,  143,  318,  119,
 /*   270 */   853,   66,   18,  171,   22,  166,   20,  172,    6,  281,
 /*   280 */     4,  172,  479,  157,  156,  173,  113,   29,  121,  142,
 /*   290 */   256,   22,  133,  117,  172,  146,  125,  139,  161,  475,
 /*   300 */   171,  581,  169,  115,  171,  144,  106,  298,  566,  205,
 /*   310 */   152,    9,   21,  508,  374,  169,  135,  171,  359,   69,
 /*   320 */   150,  195,  148,  361,  169,   69,  104,  213,  316,   21,
 /*   330 */   443,  356,  162,  129,   20,  131,  495,  659,  251,  209,
 /*   340 */   789,  661,  446,  448,  342,  426,  154,  377,  254,   22,
 /*   350 */    20,  169,  425,  116,  840,  169,  391,   37,   32,  129,
 /*   360 */   325,  131,  197,  341,  788,   22,  127,   10,  169,    8,
 /*   370 */   167,  561,  154,  278,  272,  123,  143,  106,  119,   38,
 /*   380 */   348,   20,  569,  649,  166,  456,   11,   21,  276,  252,
 /*   390 */   253,  363,  157,  156,  489,  357,   22,  121,  142,  638,
 /*   400 */    69,  133,  117,   21,  146,  125,  139,  161,   19,  299,
 /*   410 */   427,  443,  115,  172,  144,  291,  323,  369,  559,  152,
 /*   420 */   174,  219,  301,  446,  444,  135,  189,  133,  807,  150,
 /*   430 */   146,  148,  104,  106,   21,   20,  171,   69,  162,  129,
 /*   440 */   144,  131,  172,  485,  106,  152,  249,  492,   70,  266,
 /*   450 */    22,  135,  154,  259,  221,  150,  573,  148,  487,  221,
 /*   460 */   172,  137,  534,  417,  798,  171,  262,  174,  218,  718,
 /*   470 */   278,  437,  127,  842,  396,  388,  387,  558,  402,  278,
 /*   480 */   380,  123,  143,  171,  119,  276,  295,  169,   21,  398,
 /*   490 */   166,  106,  313,  245,  276,  418,  546,  247,  157,  156,
 /*   500 */   315,   12,  724,  121,  142,  217,  118,  133,  117,  718,
 /*   510 */   146,  125,  139,  161,  429,  312,  169,  686,  115,  263,
 /*   520 */   144,  440,  688,  814,   40,  152,  688,  248,  297,  335,
 /*   530 */   106,  135,  262,  245,  169,  150,   73,  148,  278,  371,
 /*   540 */    58,  104,  191,  330,  589,  278,  366,  162,  129,  806,
 /*   550 */   131,  419,  349,  276,  120,  122,  124,  473,  182,  126,
 /*   560 */   276,  154,  296,   69,  267,  165,  274,  527,  241,   59,
 /*   570 */   128,  286,   24,  246,  513,  217,  130,  274,  106,  106,
 /*   580 */   106,  127,  106,  106,   65,  263,  234,  132,  476,  106,
 /*   590 */   123,  143,  106,  119,  106,  834,   26,  106,  266,  166,
 /*   600 */   106,  228,  134,   69,  226,  266,  180,  157,  156,  136,
 /*   610 */   217,  106,  121,  142,  472,  320,  133,  117,  138,  146,
 /*   620 */   125,  139,  161,  476,  280,  106,  106,  115,  106,  144,
 /*   630 */   106,  305,  392,  106,  152,  214,  141,  212,  210,  300,
 /*   640 */   135,   49,  106,  137,  150,  104,  148,  273,  106,  145,
 /*   650 */   376,  162,  129,  290,  131,  106,  216,  459,  381,  106,
 /*   660 */   106,  106,  106,  147,  463,  154,  149,  422,  178,  478,
 /*   670 */    35,  319,  651,  106,  151,  176,  153,  293,  192,  274,
 /*   680 */   274,  106,  155,  190,  477,  127,  375,  106,  106,  412,
 /*   690 */   106,  302,  106,  450,  123,  143,   47,  119,  106,  106,
 /*   700 */   106,  170,  106,  166,  517,   31,  106,  106,  106,  415,
 /*   710 */   106,  157,  156,  106,  411,  114,  121,  142,  416,   69,
 /*   720 */   133,  117,  421,  146,  125,  139,  161,  420,   91,  829,
 /*   730 */   401,  115,  424,  144,   52,  830,  352,  559,  152,  106,
 /*   740 */   345,  221,  469,  306,  135,    2,   69,    3,  150,  104,
 /*   750 */   148,  637,  424,  163,  688,  162,  129,  393,  131,  344,
 /*   760 */   372,  367,  422,   53,  221,  549,  574,    7,  575,  154,
 /*   770 */    28,   30,  274,  576,   33,   34,  580,  106,   42,   39,
 /*   780 */    51,   23,   10,   45,   48,  521,  394,   50,   55,  127,
 /*   790 */    56,  496,   57,  590,  555,   89,  558,  484,  123,  143,
 /*   800 */    25,  119,  664,   61,  688,   63,  591,  166,   73,   71,
 /*   810 */    72,   76,   74,  245,  242,  157,  156,  351,   78,  240,
 /*   820 */   121,  142,   77,  518,  133,  117,   79,  146,  125,  139,
 /*   830 */   161,   93,   81,   82,   10,  115,   80,  144,   88,   85,
 /*   840 */   104,   87,  152,  470,   90,  835,  162,  129,  135,  131,
 /*   850 */    96,  532,  150,  438,  148,   92,  520,   94,   27,  100,
 /*   860 */   154,   98,   73,  101,   99,  137,  107,  108,  177,  102,
 /*   870 */   109,  140,  183,  154,  110,  160,  220,  665,  211,  501,
 /*   880 */   127,  666,  530,  667,  188,  194,  186,  187,  196,  123,
 /*   890 */   143,  198,  119,  199,  200,  202,  204,  203,  166,  206,
 /*   900 */   207,  208,  221,  222,  112,  235,  157,  156,  243,  223,
 /*   910 */   236,  121,  142,  239,   64,  133,  117,  217,  146,  125,
 /*   920 */   139,  161,  238,  111,  255,  258,  115,  250,  144,   67,
 /*   930 */   261,  268,  270,  152,   68,  279,  271,  257,  179,  135,
 /*   940 */   175,  277,  105,  150,  260,  148,  104,  265,  181,  269,
 /*   950 */   285,  193,  162,  129,  294,  131,  304,  287,  288,  307,
 /*   960 */   309,  327,  310,  332,  314,  334,  154,   66,  355,  311,
 /*   970 */   350,  354,  364,  312,  317,  365,  324,  326,  362,  370,
 /*   980 */   378,  379,  113,  382,  791,  368,  127,  384,   49,  353,
 /*   990 */   383,  373,  385,  397,  399,  123,  143,  389,  119,  400,
 /*  1000 */   360,  403,  404,  406,  166,  407,  408,  413,  822,  409,
 /*  1010 */   414,  827,  157,  156,  828,  423,  405,  121,  142,  410,
 /*  1020 */   428,  133,  117,  431,  146,  125,  139,  161,  433,  435,
 /*  1030 */   436,  432,  115,  796,  144,  434,  797,  442,  445,  152,
 /*  1040 */   821,  447,  439,  836,  450,  135,  452,  453,  460,  150,
 /*  1050 */   454,  148,  164,  457,  451,  458,  838,  462,  162,  129,
 /*  1060 */   465,  131,  466,  468,  467,  474,  471,  839,  481,  482,
 /*  1070 */   841,  486,  154,  658,  660,  494,  804,  483,  497,  488,
 /*  1080 */   490,  847,  493,  499,  498,  500,  717,  503,  505,  504,
 /*  1090 */   502,  720,  127,  507,  509,  510,  511,  515,  512,  725,
 /*  1100 */   723,  123,  143,  519,  119,  726,  522,  525,  524,  523,
 /*  1110 */   166,  526,  528,  529,  805,  808,  548,  531,  157,  156,
 /*  1120 */   533,  809,  540,  121,  142,  810,  811,  133,  117,  812,
 /*  1130 */   146,  125,  139,  161,  815,  547,  817,  818,  115,  816,
 /*  1140 */   144,  554,  544,  813,  551,  152,  550,  552,  848,  851,
 /*  1150 */   512,  135,  553,  556,  557,  150,  512,  148,  227,  512,
 /*  1160 */   512,  512,  512,  512,  162,  129,  512,  131,  512,  512,
 /*  1170 */   512,  512,  512,  512,  512,  512,  512,  512,  154,  512,
 /*  1180 */   512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
 /*  1190 */   512,  512,  512,  512,  512,  512,  512,  512,  127,  512,
 /*  1200 */   512,  512,  512,  512,  512,  512,  512,  123,  143,  512,
 /*  1210 */   119,  512,  512,  512,  512,  512,  166,  512,  512,  512,
 /*  1220 */   512,  512,  512,  512,  157,  156,  512,  512,  512,  121,
 /*  1230 */   142,  512,  512,  133,  117,  512,  146,  125,  139,  161,
 /*  1240 */   512,  512,  512,  512,  115,  512,  144,  512,  512,  512,
 /*  1250 */   512,  152,  512,  512,  512,  512,  512,  135,  512,  512,
 /*  1260 */   512,  150,  512,  148,  104,  512,  512,  512,  512,  512,
 /*  1270 */   162,  129,  512,  131,  512,  512,  512,  512,  512,  512,
 /*  1280 */   512,  512,  512,  512,  154,  512,  512,  512,  512,  512,
 /*  1290 */   512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
 /*  1300 */   512,  512,  512,  512,  127,  512,  512,  512,  512,  512,
 /*  1310 */   512,  512,  512,  123,  143,  512,  119,  512,  512,  512,
 /*  1320 */   512,  512,  166,  512,  512,  512,  512,  512,  512,  512,
 /*  1330 */   157,  156,  512,  512,  512,  121,  142,  512,  512,  133,
 /*  1340 */   117,  512,  146,  125,  139,  161,  512,  162,  129,  512,
 /*  1350 */   131,  512,  144,  512,  512,  512,  512,  152,  512,  512,
 /*  1360 */   512,  154,  512,  135,  512,  512,  512,  150,  512,  148,
 /*  1370 */   512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
 /*  1380 */   512,  127,  512,  512,  512,  512,  512,  512,  512,  512,
 /*  1390 */   123,  143,  512,  119,  512,  512,  512,  512,  512,  166,
 /*  1400 */   512,  512,  512,  512,  512,  177,  512,  157,  156,  183,
 /*  1410 */   512,  512,  121,  142,  512,  512,  133,  117,  512,  146,
 /*  1420 */   125,  139,  161,  177,  512,  512,  512,  183,  512,  144,
 /*  1430 */   512,  512,  512,  512,  152,  512,  512,  512,  512,  512,
 /*  1440 */   135,  112,  512,  512,  150,  512,  148,  512,  512,  512,
 /*  1450 */   512,   64,  512,  512,  512,  512,  512,  512,  512,  112,
 /*  1460 */   111,  512,  512,  512,  512,  512,   67,  512,  512,   64,
 /*  1470 */   512,   68,  512,  512,  512,  179,  512,  175,  111,  105,
 /*  1480 */   512,  512,  512,  512,   67,  181,  512,  512,  193,   68,
 /*  1490 */   512,  512,  512,  179,  512,  175,  512,  105,  129,  512,
 /*  1500 */   131,  512,  292,  181,   66,  512,  193,  512,  512,  512,
 /*  1510 */   512,  154,  512,  512,  512,  512,  512,  512,  512,  113,
 /*  1520 */   303,  512,   66,  512,  512,  512,  512,  512,  512,  512,
 /*  1530 */   512,  512,  512,  512,  512,  512,  512,  113,  512,  512,
 /*  1540 */   123,  512,  512,  119,  512,  512,  512,  512,  512,  512,
 /*  1550 */   512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
 /*  1560 */   512,  512,  121,  512,  512,  512,  133,  117,  512,  146,
 /*  1570 */   512,  512,  512,  512,  512,  512,  512,  512,  512,  144,
 /*  1580 */   512,  512,  512,  512,  152,  512,  512,  512,  512,  512,
 /*  1590 */   135,  512,  512,  512,  150,  512,  148,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */     5,    6,  157,  158,  159,  137,   11,   12,   59,   14,
 /*    10 */   150,  157,  179,  181,  181,   18,   34,   20,   18,  151,
 /*    20 */    25,  188,  189,   74,   27,   43,  181,   27,   31,   32,
 /*    30 */   185,  199,   83,  106,  185,  181,  157,  158,  159,   90,
 /*    40 */    45,  196,   93,    1,  136,  196,  197,  198,   66,   54,
 /*    50 */    55,   51,   57,  204,   59,  201,  202,   11,   63,   59,
 /*    60 */   181,  112,  166,  167,   13,  157,   71,   72,   17,   25,
 /*    70 */   166,   76,   77,  106,   74,   80,   81,  181,   83,   84,
 /*    80 */    85,   86,   85,  116,   87,  181,   91,  105,   93,  181,
 /*    90 */    48,   68,   95,   98,   97,   95,  157,  158,  159,  104,
 /*   100 */    49,   55,   60,  108,  122,  110,   83,  112,    5,   63,
 /*   110 */    59,   32,  112,   49,   11,   12,   93,   14,  121,   68,
 /*   120 */   181,  121,   18,   77,  185,   74,  194,  195,   25,  157,
 /*   130 */    79,   27,   68,   87,   83,  196,   85,   18,   87,   20,
 /*   140 */    22,   99,   98,  101,   93,   46,  174,   96,   45,  157,
 /*   150 */    59,   32,  108,  181,  110,   51,  105,   54,   55,    6,
 /*   160 */    57,   82,   25,  112,   85,   74,   63,  181,   69,   90,
 /*   170 */    79,   49,   13,  181,   71,   72,   17,   16,  127,   76,
 /*   180 */    77,   59,   22,   80,   81,  199,   83,   84,   85,   86,
 /*   190 */    68,   73,   74,  201,   91,   59,   93,  142,  143,   95,
 /*   200 */   145,   98,  103,  112,   85,   83,   87,  104,   49,   87,
 /*   210 */    74,  108,   59,  110,   95,   93,   97,    5,   59,  120,
 /*   220 */    83,  103,  105,   11,   12,  121,   14,   68,   46,   85,
 /*   230 */    93,   87,  129,   74,  112,   98,  181,   25,   79,  139,
 /*   240 */   121,   46,   83,  126,   85,  108,   87,  110,  112,  206,
 /*   250 */    46,   69,   93,  210,  154,   96,  156,   45,  215,   59,
 /*   260 */   205,  100,    1,  103,   69,  112,   54,   55,  107,   57,
 /*   270 */   170,  112,  116,   69,   74,   63,   59,   46,  138,   79,
 /*   280 */   140,   46,  157,   71,   72,  103,  127,  147,   76,   77,
 /*   290 */    73,   74,   80,   81,   46,   83,   84,   85,   86,  174,
 /*   300 */    69,  106,  120,   91,   69,   93,  181,  103,  106,   48,
 /*   310 */    98,  184,  112,  173,   18,  120,  104,   69,   22,  185,
 /*   320 */   108,   60,  110,   27,  120,  185,    5,  115,   34,  112,
 /*   330 */   196,  165,   11,   12,   59,   14,  196,  106,   22,   42,
 /*   340 */    43,  106,  208,  209,   49,    2,   25,   51,   73,   74,
 /*   350 */    59,  120,    9,  157,  106,  120,  142,  143,  144,   12,
 /*   360 */    66,   14,  101,   68,   43,   74,   45,   90,  120,  207,
 /*   370 */    79,    0,   25,  166,  167,   54,   55,  181,   57,  213,
 /*   380 */   214,   59,  106,  106,   63,   22,   26,  112,  181,   73,
 /*   390 */    74,   95,   71,   72,   64,  181,   74,   76,   77,  103,
 /*   400 */   185,   80,   81,  112,   83,   84,   85,   86,  181,  157,
 /*   410 */    67,  196,   91,   46,   93,  131,  122,  121,   47,   98,
 /*   420 */   157,  158,  159,  208,  209,  104,  129,   80,  106,  108,
 /*   430 */    83,  110,    5,  181,  112,   59,   69,  185,   11,   12,
 /*   440 */    93,   14,   46,  113,  181,   98,  197,  117,  196,  165,
 /*   450 */    74,  104,   25,  204,   39,  108,  106,  110,  128,   39,
 /*   460 */    46,  177,   45,   34,   64,   69,   59,  157,  158,  106,
 /*   470 */   166,  167,   45,  106,  113,  151,  152,  106,  117,  166,
 /*   480 */   167,   54,   55,   69,   57,  181,  110,  120,  112,  128,
 /*   490 */    63,  181,   82,  130,  181,   66,   79,   22,   71,   72,
 /*   500 */    90,  193,  106,   76,   77,   22,  157,   80,   81,  106,
 /*   510 */    83,   84,   85,   86,  114,  191,  120,  103,   91,  112,
 /*   520 */    93,  121,  107,  106,  132,   98,  106,   52,    4,  137,
 /*   530 */   181,  104,   59,  130,  120,  108,  105,  110,  166,  167,
 /*   540 */     7,    5,  115,  151,   39,  166,  167,   11,   12,  106,
 /*   550 */    14,  122,   79,  181,  157,  157,  157,  126,  157,  157,
 /*   560 */   181,   25,   38,  185,  131,  157,   22,  124,  157,   36,
 /*   570 */   157,  131,  207,  157,  196,   22,  157,   22,  181,  181,
 /*   580 */   181,   45,  181,  181,   79,  112,  103,  157,   22,  181,
 /*   590 */    54,   55,  181,   57,  181,   10,  207,  181,  165,   63,
 /*   600 */   181,  157,  157,  185,  157,  165,  157,   71,   72,  157,
 /*   610 */    22,  181,   76,   77,  196,   31,   80,   81,  157,   83,
 /*   620 */    84,   85,   86,   22,  157,  181,  181,   91,  181,   93,
 /*   630 */   181,  157,    6,  181,   98,  157,  157,  157,  157,  103,
 /*   640 */   104,   32,  181,  177,  108,    5,  110,  103,  181,  157,
 /*   650 */   184,   11,   12,  157,   14,  181,  103,  157,  103,  181,
 /*   660 */   181,  181,  181,  157,  157,   25,  157,   22,  157,  103,
 /*   670 */    22,   87,   70,  181,  157,  157,  157,  181,  157,   22,
 /*   680 */    22,  181,  157,  157,  157,   45,  157,  181,  181,  157,
 /*   690 */   181,  103,  181,   91,   54,   55,   87,   57,  181,  181,
 /*   700 */   181,    4,  181,   63,  103,   79,  181,  181,  181,  102,
 /*   710 */   181,   71,   72,  181,  129,  157,   76,   77,  111,  185,
 /*   720 */    80,   81,  171,   83,   84,   85,   86,   88,   22,   90,
 /*   730 */   196,   91,  181,   93,   33,   90,   22,   47,   98,  181,
 /*   740 */    49,   39,  171,  103,  104,  154,  185,  156,  108,    5,
 /*   750 */   110,  103,  181,  157,   52,   11,   12,  196,   14,   68,
 /*   760 */   103,  103,   22,   62,   39,    8,  106,   10,  106,   25,
 /*   770 */   207,  148,   22,  106,  146,  103,  106,  181,  181,  133,
 /*   780 */    65,   24,   90,  184,  184,   28,   29,  169,   75,   45,
 /*   790 */   203,   34,  184,   39,   37,   89,  106,   40,   54,   55,
 /*   800 */    43,   57,  105,  184,   79,   79,   39,   63,  105,  180,
 /*   810 */   185,  161,  153,  130,   56,   71,   72,  103,  162,   58,
 /*   820 */    76,   77,  218,   66,   80,   81,  163,   83,   84,   85,
 /*   830 */    86,   92,  178,   78,   90,   91,  187,   93,  200,   68,
 /*   840 */     5,   68,   98,  103,  200,   10,   11,   12,  104,   14,
 /*   850 */    22,   94,  108,  103,  110,  200,   99,   15,  101,   20,
 /*   860 */    25,  141,  105,   59,  203,  177,   39,  181,   13,  164,
 /*   870 */    39,  177,   17,   25,  181,   87,  181,  105,  129,  122,
 /*   880 */    45,  105,  125,  105,   43,   79,  135,  134,  103,   54,
 /*   890 */    55,   22,   57,  181,  103,   22,  103,  181,   63,   22,
 /*   900 */   181,  103,   39,  181,   49,  181,   71,   72,   15,  150,
 /*   910 */   150,   76,   77,  203,   59,   80,   81,   22,   83,   84,
 /*   920 */    85,   86,  141,   68,  181,   73,   91,  175,   93,   74,
 /*   930 */   150,  183,  124,   98,   79,   90,   79,  181,   83,  104,
 /*   940 */    85,  203,   87,  108,  181,  110,    5,  181,   93,  216,
 /*   950 */   103,   96,   11,   12,   39,   14,  103,  183,  216,  184,
 /*   960 */   181,   79,  168,  164,  181,  169,   25,  112,  165,  192,
 /*   970 */   200,  103,   75,  191,  190,   79,  190,  190,  181,   79,
 /*   980 */    75,   79,  127,   97,  129,  184,   45,  168,   32,  200,
 /*   990 */   181,  184,  192,  181,  181,   54,   55,  205,   57,    6,
 /*  1000 */   205,  181,  212,   90,   63,  181,  150,   50,   10,  160,
 /*  1010 */    41,   90,   71,   72,   90,  181,  211,   76,   77,  217,
 /*  1020 */    88,   80,   81,   64,   83,   84,   85,   86,   90,  150,
 /*  1030 */    79,  181,   91,  106,   93,  181,   64,   10,   43,   98,
 /*  1040 */   106,  106,  184,   43,   91,  104,  186,  181,  218,  108,
 /*  1050 */   107,  110,    5,  181,  193,   45,  106,   45,   11,   12,
 /*  1060 */   186,   14,   70,   79,  181,   79,  172,  106,   52,  181,
 /*  1070 */   106,  181,   25,  106,  106,  150,  106,  218,   52,  181,
 /*  1080 */   181,  106,  181,  150,  181,  218,  106,  181,  107,  150,
 /*  1090 */   186,  106,   45,  218,   70,  181,  150,   79,  172,   70,
 /*  1100 */   106,   54,   55,  186,   57,   70,  186,   52,  150,  181,
 /*  1110 */    63,  181,   35,  112,  106,  106,  103,  181,   71,   72,
 /*  1120 */   165,  106,  182,   76,   77,  106,  106,   80,   81,  106,
 /*  1130 */    83,   84,   85,   86,  106,  181,  106,  106,   91,  106,
 /*  1140 */    93,   30,  182,  106,  165,   98,  149,    6,  106,  106,
 /*  1150 */   219,  104,  181,  149,  181,  108,  219,  110,    5,  219,
 /*  1160 */   219,  219,  219,  219,   11,   12,  219,   14,  219,  219,
 /*  1170 */   219,  219,  219,  219,  219,  219,  219,  219,   25,  219,
 /*  1180 */   219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
 /*  1190 */   219,  219,  219,  219,  219,  219,  219,  219,   45,  219,
 /*  1200 */   219,  219,  219,  219,  219,  219,  219,   54,   55,  219,
 /*  1210 */    57,  219,  219,  219,  219,  219,   63,  219,  219,  219,
 /*  1220 */   219,  219,  219,  219,   71,   72,  219,  219,  219,   76,
 /*  1230 */    77,  219,  219,   80,   81,  219,   83,   84,   85,   86,
 /*  1240 */   219,  219,  219,  219,   91,  219,   93,  219,  219,  219,
 /*  1250 */   219,   98,  219,  219,  219,  219,  219,  104,  219,  219,
 /*  1260 */   219,  108,  219,  110,    5,  219,  219,  219,  219,  219,
 /*  1270 */    11,   12,  219,   14,  219,  219,  219,  219,  219,  219,
 /*  1280 */   219,  219,  219,  219,   25,  219,  219,  219,  219,  219,
 /*  1290 */   219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
 /*  1300 */   219,  219,  219,  219,   45,  219,  219,  219,  219,  219,
 /*  1310 */   219,  219,  219,   54,   55,  219,   57,  219,  219,  219,
 /*  1320 */   219,  219,   63,  219,  219,  219,  219,  219,  219,  219,
 /*  1330 */    71,   72,  219,  219,  219,   76,   77,  219,  219,   80,
 /*  1340 */    81,  219,   83,   84,   85,   86,  219,   11,   12,  219,
 /*  1350 */    14,  219,   93,  219,  219,  219,  219,   98,  219,  219,
 /*  1360 */   219,   25,  219,  104,  219,  219,  219,  108,  219,  110,
 /*  1370 */   219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
 /*  1380 */   219,   45,  219,  219,  219,  219,  219,  219,  219,  219,
 /*  1390 */    54,   55,  219,   57,  219,  219,  219,  219,  219,   63,
 /*  1400 */   219,  219,  219,  219,  219,   13,  219,   71,   72,   17,
 /*  1410 */   219,  219,   76,   77,  219,  219,   80,   81,  219,   83,
 /*  1420 */    84,   85,   86,   13,  219,  219,  219,   17,  219,   93,
 /*  1430 */   219,  219,  219,  219,   98,  219,  219,  219,  219,  219,
 /*  1440 */   104,   49,  219,  219,  108,  219,  110,  219,  219,  219,
 /*  1450 */   219,   59,  219,  219,  219,  219,  219,  219,  219,   49,
 /*  1460 */    68,  219,  219,  219,  219,  219,   74,  219,  219,   59,
 /*  1470 */   219,   79,  219,  219,  219,   83,  219,   85,   68,   87,
 /*  1480 */   219,  219,  219,  219,   74,   93,  219,  219,   96,   79,
 /*  1490 */   219,  219,  219,   83,  219,   85,  219,   87,   12,  219,
 /*  1500 */    14,  219,  110,   93,  112,  219,   96,  219,  219,  219,
 /*  1510 */   219,   25,  219,  219,  219,  219,  219,  219,  219,  127,
 /*  1520 */   110,  219,  112,  219,  219,  219,  219,  219,  219,  219,
 /*  1530 */   219,  219,  219,  219,  219,  219,  219,  127,  219,  219,
 /*  1540 */    54,  219,  219,   57,  219,  219,  219,  219,  219,  219,
 /*  1550 */   219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
 /*  1560 */   219,  219,   76,  219,  219,  219,   80,   81,  219,   83,
 /*  1570 */   219,  219,  219,  219,  219,  219,  219,  219,  219,   93,
 /*  1580 */   219,  219,  219,  219,   98,  219,  219,  219,  219,  219,
 /*  1590 */   104,  219,  219,  219,  108,  219,  110,
};
#define YY_SHIFT_USE_DFLT (-74)
static short yy_shift_ofst[] = {
 /*     0 */   690,  371,  -74,  757,  -73,  -74,  202,  156,  277,  276,
 /*    10 */   360,   42,  -74,  -74,  -74,  -74,  -74,  -74,  136,  -74,
 /*    20 */   -74,  -74,  -74,  -33,  350,  -33,  660,  -33,  662,  626,
 /*    30 */   667,  136,  648,  672,  670,    0,  -74,  407,  -74,   -3,
 /*    40 */   -74,  136,  119,  -74,  692,  -74,  609,  692,  -74,  715,
 /*    50 */   -74,  701,  -74,  -74,  713,  533,  692,  -74,  -74,  -74,
 /*    60 */   692,  -74,  726,  159,  505, 1410,  754,  767,   51,  -74,
 /*    70 */   204,  703,  -74,  524,  -74,  475,  683,  758,  761,  739,
 /*    80 */   755,  -74,   23,  -74,  771,  -74,  773,  -74,  706,   23,
 /*    90 */   -74,   23,  -74,  842,  159,  828,  159,  839,  533,  -74,
 /*   100 */   804,  -74,  -74,  941,  159,  -74,  827,  136,  831,  136,
 /*   110 */   -74,  -74,  -74,  -74, 1336,  159, 1259,  159,  347,  159,
 /*   120 */   347,  159,  347,  159,  347,  159, 1486,  159, 1486,  159,
 /*   130 */   137,  159,  137,  159,  137,  159,  137,  159, 1486,   46,
 /*   140 */   159, 1486,  -74,  -74,  159,   44,  159,   44,  159,  848,
 /*   150 */   159,  848,  159,  848,  159,  -74,  -74,  144,  -74,  788,
 /*   160 */   -74,  -74,  159, 1047,  159, 1486,  291,   51,  182,  697,
 /*   170 */   772,  776,  778,  -74,  941,  159, 1336,  159,  -74,  159,
 /*   180 */   -74,  159,  -74,  855,  103,  749,  297,  841,  -74,  159,
 /*   190 */   427,  159,  941,  806,  261,  785,  -74,  869,  136,  791,
 /*   200 */   -74,  873,  136,  793,  -74,  877,  136,  798,  -74,  159,
 /*   210 */   321,  159,  212,  159,  941,  553,  -74,  159,  -74,  -74,
 /*   220 */   863,  136,  -74,  -74,  -74,  159, 1153,  159, 1336,   91,
 /*   230 */    51,   99,  -74,  483,  -74,  863,  -74,  839,  533,  -74,
 /*   240 */   159,  941,  893,  159,  895,  159,  941,  -74,  -74,  316,
 /*   250 */   -74,  -74,  -74,  275,  -74,  217,  -74,  852,  -74,  200,
 /*   260 */   863,  153,  -74,  -74,  136,  -74,  -74,  845,  808,  -74,
 /*   270 */   857,  136,  544,  -74,  136,  -74,  533,  -74,  -74,  159,
 /*   280 */   941,  703,  414,  118,  847,  153,  845,  808,  -74, 1392,
 /*   290 */    -5,  -74,  -74,  915,  376,  -74,  -74,  -74,  -74,  536,
 /*   300 */   -74,  588,  -74,  853,  -74,  640,  692,  -74,  136,  882,
 /*   310 */   -74,  410,  -74,  136,  -74,  294,  161,  -74,  584,  -74,
 /*   320 */   -74,  -74,  -74,  161,  -74,  161,  -74,  136,  160,  -74,
 /*   330 */   -74,  804,  -74,  715,  -74,  -74,  122,  -74,  -74,  -74,
 /*   340 */   295,  -74,  -74,  691,  -74,  -74,  -74,  -74,  473,   23,
 /*   350 */   714,  -74,   23,  868,  -74,  -74,  -74,  -74,  296,  104,
 /*   360 */   -74,  136,  -74,  897,  896,  136,  658,  692,  -74,  900,
 /*   370 */   136,  657,  692,  -74,  159,  744,  -74,  905,  902,  136,
 /*   380 */   555,  886,  136,  882,  -74,   79,  956,  -74,  -74,  -74,
 /*   390 */   -74,  -74,  703,  195,  400,  361,  136,  -74,  136,  993,
 /*   400 */   703,  231,  136,  343,  429,  913,  136,  863,  957,  585,
 /*   410 */   998,  159,  835,  969,  607,  -74,  -74,  921,  924,  639,
 /*   420 */   136,  645,  136,  -74,  -74,  -74,  -74,  932,  -74,  -74,
 /*   430 */   959,  136,  938,  136,  725,  951,  136,  750,  277,  927,
 /*   440 */   972, 1027,  -18,  367,  995,  934,  935,  -18, 1000,  953,
 /*   450 */    42,  -74,  136,  943,  136,  363,  136, 1010,  159,  941,
 /*   460 */   950, 1012,  159,  941,  602,  992,  136,  984,  136,  740,
 /*   470 */   -74,  431,  248,  986,  159,  566,  159,  941,  961,  941,
 /*   480 */  1016,  136,  403,  964,  330,  136,  967,  136,  968,  136,
 /*   490 */   420,  970,  136,  420,  975,  235, 1026,  136,  863,  403,
 /*   500 */   980,  953,  136,  415,  981,  136,  363,  985, 1024,  136,
 /*   510 */   863,  984,  117,  396, 1018,  159,  601,  994,  602, 1029,
 /*   520 */  1035,  953,  136,  702, 1055,  136,  443, 1077, 1001, 1008,
 /*   530 */   322, 1009,  407,  417,  -51, 1015, 1019, 1020, 1023,   64,
 /*   540 */  1028, 1030, 1031,   64, 1033,  -74,  136, 1013, 1037, 1111,
 /*   550 */   407, 1141,  136, 1042,  -74, 1111,  136, 1043,  -74,  -74,
 /*   560 */   -74,
};
#define YY_REDUCE_USE_DFLT (-169)
static short yy_reduce_ofst[] = {
 /*     0 */   100,  591, -169,  140, -169, -169, -169,  162,  127, -169,
 /*    10 */  -169,  308, -169, -169, -169, -169, -169, -169,  227, -169,
 /*    20 */  -169, -169, -169,  365, -169,  389, -169,  563, -169,  623,
 /*    30 */  -169,  214,  628, -169, -169,   55, -169,  166,  646,  392,
 /*    40 */  -169,  597, -132, -169,  599, -169, -169,  600, -169,  618,
 /*    50 */  -169, -169, -169, -169, -169,  587,  608, -169, -169, -169,
 /*    60 */   619, -169, -169,  474, -169,  263, -169, -169,  252, -169,
 /*    70 */   629,  625, -169,  659,  -68,  650,  604,  656,  663,  649,
 /*    80 */   654, -169,  638, -169, -169, -169, -169, -169, -169,  644,
 /*    90 */  -169,  655, -169, -169, -146, -169,   -8,  720,  661, -169,
 /*   100 */   705, -169, -169,  688,  558, -169, -169,  686, -169,  693,
 /*   110 */  -169, -169, -169, -169,  688,  196,  688,  349,  688,  397,
 /*   120 */   688,  398,  688,  399,  688,  402,  688,  413,  688,  419,
 /*   130 */   688,  430,  688,  445,  688,  452,  688,  461,  688,  694,
 /*   140 */   479,  688, -169, -169,  492,  688,  506,  688,  509,  688,
 /*   150 */   517,  688,  519,  688,  525,  688, -169, -169, -169, -169,
 /*   160 */  -169, -169,  596,  688,  408,  688,  695, -155,  629, -169,
 /*   170 */  -169, -169, -169, -169,  688,  518,  688,  511,  688,  449,
 /*   180 */   688,  401,  688,  -92,  688,  751,  753, -169, -169,  526,
 /*   190 */   688,  521,  688, -169, -169, -169, -169, -169,  712, -169,
 /*   200 */  -169, -169,  716, -169, -169, -169,  719, -169, -169,  481,
 /*   210 */   688,  480,  688,  478,  688, -169, -169,  310, -169, -169,
 /*   220 */   759,  722, -169, -169, -169,  447,  688,  444,  688,  724,
 /*   230 */   -61,  629, -169, -169, -169,  760, -169,  781,  710, -169,
 /*   240 */   411,  688, -169, -121, -169,  416,  688, -169,  249,  752,
 /*   250 */  -169, -169, -169,  743, -169,  756, -169, -169, -169,  763,
 /*   260 */   780,  433, -169, -169,  766, -169, -169,  748,  733, -169,
 /*   270 */  -169,  207, -169, -169,  -96, -169,  738, -169, -169,  467,
 /*   280 */   688, -151,  629,  752, -169,  440,  774,  742, -169,  496,
 /*   290 */   284, -169, -169, -169,  686, -169, -169, -169, -169,  688,
 /*   300 */  -169, -169, -169, -169, -169,  688,  775, -169,  779,  794,
 /*   310 */   777,  782, -169,  783, -169, -169,  784, -169, -169, -169,
 /*   320 */  -169, -169, -169,  786, -169,  787, -169, -104, -169, -169,
 /*   330 */  -169,  799, -169,  796, -169, -169, -169, -169, -169, -169,
 /*   340 */  -169, -169, -169, -169, -169, -169, -169, -169,  803,  770,
 /*   350 */  -169, -169,  789, -169, -169, -169, -169, -169,  792,  795,
 /*   360 */  -169,  797, -169, -169, -169,  379, -169,  801, -169, -169,
 /*   370 */   372, -169,  807, -169,  529,  466, -169, -169, -169,  313,
 /*   380 */  -169, -169,  809,  819,  800,  324, -169, -169, -169, -169,
 /*   390 */  -169, -169,  561,  629,   43, -169,  812, -169,  813, -169,
 /*   400 */   534,  629,  820,  790,  805, -169,  824,  856,  849,  802,
 /*   410 */  -169,  532,  688, -169, -169, -169, -169, -169, -169, -169,
 /*   420 */   551, -169,  834, -169, -169, -169, -169, -169, -169, -169,
 /*   430 */  -169,  850, -169,  854,  879, -169,  304, -169,  858, -169,
 /*   440 */  -169, -169,  215,  629, -169, -169, -169,  134, -169,  860,
 /*   450 */   861, -169,  866, -169,  -14,  830,  872, -169,  500,  688,
 /*   460 */  -169, -169,  507,  688,  874, -169,  883,  894,  571, -169,
 /*   470 */  -169,  418,  629, -169,  125, -169,  527,  688, -169,  688,
 /*   480 */  -169,  888,  859, -169, -169,  890, -169,  898, -169,  899,
 /*   490 */  -140, -169,  901,  925, -169,  629, -169,  903,  933,  867,
 /*   500 */  -169,  904,  906,  939, -169, -168,  875, -169, -169,  914,
 /*   510 */   946,  926,  378,  629, -169,  -28, -169, -169,  917, -169,
 /*   520 */  -169,  920,  928,  958, -169,  930, -169, -169, -169, -169,
 /*   530 */   936, -169,  955, -169, -167, -169, -169, -169, -169,  940,
 /*   540 */  -169, -169, -169,  960, -169, -169,  954, -169, -169,  997,
 /*   550 */   979, -169,  971, -169, -169, 1004,  973, -169, -169, -169,
 /*   560 */  -169,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   568,  568,  563,  852,  852,  564,  852,  570,  852,  852,
 /*    10 */   852,  852,  650,  653,  654,  655,  656,  657,  571,  572,
 /*    20 */   589,  590,  591,  852,  852,  852,  852,  852,  852,  852,
 /*    30 */   852,  852,  852,  852,  852,  852,  582,  592,  602,  584,
 /*    40 */   601,  852,  852,  603,  649,  614,  852,  649,  615,  634,
 /*    50 */   632,  852,  635,  636,  852,  706,  649,  616,  704,  705,
 /*    60 */   649,  617,  852,  852,  735,  795,  741,  736,  852,  662,
 /*    70 */   852,  852,  663,  671,  673,  680,  718,  709,  711,  699,
 /*    80 */   713,  668,  852,  598,  852,  599,  852,  600,  714,  852,
 /*    90 */   715,  852,  716,  852,  852,  700,  852,  707,  706,  701,
 /*   100 */   852,  586,  708,  703,  852,  734,  852,  852,  737,  852,
 /*   110 */   738,  739,  740,  742,  745,  852,  746,  852,  747,  852,
 /*   120 */   748,  852,  749,  852,  750,  852,  751,  852,  752,  852,
 /*   130 */   753,  852,  754,  852,  755,  852,  756,  852,  757,  852,
 /*   140 */   852,  758,  759,  760,  852,  761,  852,  762,  852,  763,
 /*   150 */   852,  764,  852,  765,  852,  766,  767,  852,  768,  852,
 /*   160 */   771,  769,  852,  852,  852,  777,  852,  795,  852,  852,
 /*   170 */   852,  852,  852,  780,  794,  852,  772,  852,  773,  852,
 /*   180 */   774,  852,  775,  852,  852,  852,  852,  852,  785,  852,
 /*   190 */   852,  852,  786,  852,  852,  852,  843,  852,  852,  852,
 /*   200 */   844,  852,  852,  852,  845,  852,  852,  852,  846,  852,
 /*   210 */   852,  852,  852,  852,  787,  852,  779,  795,  792,  793,
 /*   220 */   688,  852,  689,  783,  770,  852,  852,  852,  778,  852,
 /*   230 */   795,  852,  782,  852,  781,  688,  784,  707,  706,  702,
 /*   240 */   852,  712,  852,  795,  710,  852,  719,  672,  683,  681,
 /*   250 */   682,  690,  691,  852,  692,  852,  693,  852,  694,  852,
 /*   260 */   688,  679,  587,  588,  852,  677,  678,  696,  698,  684,
 /*   270 */   852,  852,  852,  697,  852,  801,  706,  803,  802,  852,
 /*   280 */   695,  683,  852,  852,  852,  679,  696,  698,  685,  852,
 /*   290 */   679,  674,  675,  852,  852,  676,  669,  670,  776,  852,
 /*   300 */   733,  852,  743,  852,  744,  852,  649,  618,  852,  799,
 /*   310 */   622,  619,  623,  852,  624,  852,  852,  625,  852,  628,
 /*   320 */   629,  630,  631,  852,  626,  852,  627,  852,  852,  800,
 /*   330 */   620,  852,  621,  634,  633,  604,  852,  605,  606,  607,
 /*   340 */   852,  608,  611,  852,  609,  612,  610,  613,  593,  852,
 /*   350 */   852,  594,  852,  852,  595,  597,  596,  585,  852,  852,
 /*   360 */   639,  852,  642,  852,  852,  852,  852,  649,  643,  852,
 /*   370 */   852,  852,  649,  644,  852,  649,  645,  852,  852,  852,
 /*   380 */   852,  852,  852,  799,  622,  647,  852,  646,  648,  640,
 /*   390 */   641,  583,  852,  852,  579,  852,  852,  577,  852,  852,
 /*   400 */   852,  852,  852,  826,  852,  852,  852,  688,  831,  852,
 /*   410 */   852,  852,  852,  852,  852,  832,  833,  852,  852,  852,
 /*   420 */   852,  852,  852,  731,  732,  823,  824,  852,  825,  578,
 /*   430 */   852,  852,  852,  852,  852,  852,  852,  852,  852,  852,
 /*   440 */   852,  852,  852,  852,  852,  852,  852,  852,  852,  651,
 /*   450 */   852,  652,  852,  852,  852,  852,  852,  852,  852,  721,
 /*   460 */   852,  852,  852,  722,  852,  852,  852,  729,  852,  852,
 /*   470 */   730,  852,  852,  852,  852,  852,  852,  727,  852,  728,
 /*   480 */   852,  852,  852,  852,  852,  852,  852,  852,  852,  852,
 /*   490 */   852,  852,  852,  852,  852,  852,  852,  852,  688,  852,
 /*   500 */   852,  651,  852,  852,  852,  852,  852,  852,  852,  852,
 /*   510 */   688,  729,  852,  852,  852,  852,  852,  852,  852,  852,
 /*   520 */   852,  651,  852,  852,  852,  852,  852,  852,  852,  852,
 /*   530 */   852,  852,  852,  852,  820,  852,  852,  852,  852,  852,
 /*   540 */   852,  852,  852,  852,  852,  819,  852,  852,  852,  850,
 /*   550 */   852,  852,  852,  852,  849,  850,  852,  852,  565,  567,
 /*   560 */   562,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
   59,  /*      ABORT => ID */
   59,  /*      AFTER => ID */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*        ALL => nothing */
    0,  /*        AND => nothing */
    0,  /*         AS => nothing */
   59,  /*        ASC => ID */
   59,  /*     ATTACH => ID */
   59,  /*     BEFORE => ID */
   59,  /*      BEGIN => ID */
    0,  /*    BETWEEN => nothing */
    0,  /*     BITAND => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*      BITOR => nothing */
    0,  /*         BY => nothing */
   59,  /*    CASCADE => ID */
    0,  /*       CASE => nothing */
    0,  /*      CHECK => nothing */
   59,  /*    CLUSTER => ID */
    0,  /*    COLLATE => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*      COMMA => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*     COMMIT => nothing */
    0,  /*     CONCAT => nothing */
   59,  /*   CONFLICT => ID */
    0,  /* CONSTRAINT => nothing */
   59,  /*       COPY => ID */
    0,  /*     CREATE => nothing */
   59,  /*   DATABASE => ID */
    0,  /*    DEFAULT => nothing */
    0,  /* DEFERRABLE => nothing */
   59,  /*   DEFERRED => ID */
    0,  /*     DELETE => nothing */
   59,  /* DELIMITERS => ID */
   59,  /*       DESC => ID */
   59,  /*     DETACH => ID */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       DROP => nothing */
   59,  /*       EACH => ID */
    0,  /*       ELSE => nothing */
   59,  /*        END => ID */
    0,  /* END_OF_FILE => nothing */
    0,  /*         EQ => nothing */
    0,  /*     EXCEPT => nothing */
   59,  /*    EXPLAIN => ID */
   59,  /*       FAIL => ID */
    0,  /*      FLOAT => nothing */
   59,  /*        FOR => ID */
    0,  /*    FOREIGN => nothing */
    0,  /*       FROM => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*         GE => nothing */
   59,  /*       GLOB => ID */
    0,  /*      GROUP => nothing */
    0,  /*         GT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*         ID => nothing */
   59,  /*     IGNORE => ID */
    0,  /*    ILLEGAL => nothing */
   59,  /*  IMMEDIATE => ID */
    0,  /*         IN => nothing */
    0,  /*      INDEX => nothing */
   59,  /*  INITIALLY => ID */
    0,  /*     INSERT => nothing */
   59,  /*    INSTEAD => ID */
    0,  /*    INTEGER => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*       INTO => nothing */
    0,  /*         IS => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*       JOIN => nothing */
    0,  /*    JOIN_KW => nothing */
   59,  /*        KEY => ID */
    0,  /*         LE => nothing */
   59,  /*       LIKE => ID */
    0,  /*      LIMIT => nothing */
    0,  /*         LP => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*         LT => nothing */
   59,  /*      MATCH => ID */
    0,  /*      MINUS => nothing */
    0,  /*         NE => nothing */
    0,  /*        NOT => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*       NULL => nothing */
   59,  /*         OF => ID */
   59,  /*     OFFSET => ID */
    0,  /*         ON => nothing */
    0,  /*         OR => nothing */
    0,  /*      ORDER => nothing */
    0,  /*       PLUS => nothing */
   59,  /*     PRAGMA => ID */
    0,  /*    PRIMARY => nothing */
   59,  /*      RAISE => ID */
    0,  /* REFERENCES => nothing */
    0,  /*        REM => nothing */
   59,  /*    REPLACE => ID */
   59,  /*   RESTRICT => ID */
    0,  /*   ROLLBACK => nothing */
   59,  /*        ROW => ID */
    0,  /*         RP => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*       SEMI => nothing */
    0,  /*        SET => nothing */
    0,  /*      SLASH => nothing */
    0,  /*      SPACE => nothing */
    0,  /*       STAR => nothing */
   59,  /*  STATEMENT => ID */
    0,  /*     STRING => nothing */
    0,  /*      TABLE => nothing */
   59,  /*       TEMP => ID */
    0,  /*       THEN => nothing */
    0,  /* TRANSACTION => nothing */
   59,  /*    TRIGGER => ID */
    0,  /*     UMINUS => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*      UNION => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*      USING => nothing */
   59,  /*     VACUUM => ID */
    0,  /*     VALUES => nothing */
    0,  /*   VARIABLE => nothing */
   59,  /*       VIEW => ID */
    0,  /*       WHEN => nothing */
    0,  /*      WHERE => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqliteParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "ABORT",         "AFTER",         "AGG_FUNCTION",
  "ALL",           "AND",           "AS",            "ASC",         
  "ATTACH",        "BEFORE",        "BEGIN",         "BETWEEN",     
  "BITAND",        "BITNOT",        "BITOR",         "BY",          
  "CASCADE",       "CASE",          "CHECK",         "CLUSTER",     
  "COLLATE",       "COLUMN",        "COMMA",         "COMMENT",     
  "COMMIT",        "CONCAT",        "CONFLICT",      "CONSTRAINT",  
  "COPY",          "CREATE",        "DATABASE",      "DEFAULT",     
  "DEFERRABLE",    "DEFERRED",      "DELETE",        "DELIMITERS",  
  "DESC",          "DETACH",        "DISTINCT",      "DOT",         
  "DROP",          "EACH",          "ELSE",          "END",         
  "END_OF_FILE",   "EQ",            "EXCEPT",        "EXPLAIN",     
  "FAIL",          "FLOAT",         "FOR",           "FOREIGN",     
  "FROM",          "FUNCTION",      "GE",            "GLOB",        
  "GROUP",         "GT",            "HAVING",        "ID",          
  "IGNORE",        "ILLEGAL",       "IMMEDIATE",     "IN",          
  "INDEX",         "INITIALLY",     "INSERT",        "INSTEAD",     
  "INTEGER",       "INTERSECT",     "INTO",          "IS",          
  "ISNULL",        "JOIN",          "JOIN_KW",       "KEY",         
  "LE",            "LIKE",          "LIMIT",         "LP",          
  "LSHIFT",        "LT",            "MATCH",         "MINUS",       
  "NE",            "NOT",           "NOTNULL",       "NULL",        
  "OF",            "OFFSET",        "ON",            "OR",          
  "ORDER",         "PLUS",          "PRAGMA",        "PRIMARY",     
  "RAISE",         "REFERENCES",    "REM",           "REPLACE",     
  "RESTRICT",      "ROLLBACK",      "ROW",           "RP",          
  "RSHIFT",        "SELECT",        "SEMI",          "SET",         
  "SLASH",         "SPACE",         "STAR",          "STATEMENT",   
  "STRING",        "TABLE",         "TEMP",          "THEN",        
  "TRANSACTION",   "TRIGGER",       "UMINUS",        "UNCLOSED_STRING",
  "UNION",         "UNIQUE",        "UPDATE",        "UPLUS",       
  "USING",         "VACUUM",        "VALUES",        "VARIABLE",    
  "VIEW",          "WHEN",          "WHERE",         "as",          
  "carg",          "carglist",      "case_else",     "case_exprlist",
  "case_operand",  "ccons",         "cmd",           "cmdlist",     
  "cmdx",          "collate",       "column",        "columnid",    
  "columnlist",    "conslist",      "conslist_opt",  "create_table",
  "create_table_args",  "database_kw_opt",  "dbnm",          "defer_subclause",
  "defer_subclause_opt",  "distinct",      "ecmd",          "error",       
  "explain",       "expr",          "expritem",      "exprlist",    
  "foreach_clause",  "from",          "groupby_opt",   "having_opt",  
  "id",            "ids",           "idxitem",       "idxlist",     
  "idxlist_opt",   "init_deferred_pred_opt",  "input",         "inscollist",  
  "inscollist_opt",  "insert_cmd",    "itemlist",      "joinop",      
  "joinop2",       "likeop",        "limit_opt",     "minus_num",   
  "multiselect_op",  "nm",            "number",        "on_opt",      
  "onconf",        "oneselect",     "orconf",        "orderby_opt", 
  "plus_num",      "plus_opt",      "refact",        "refarg",      
  "refargs",       "resolvetype",   "sclp",          "selcollist",  
  "select",        "seltablist",    "seltablist_paren",  "setlist",     
  "signed",        "sortitem",      "sortlist",      "sortorder",   
  "stl_prefix",    "tcons",         "temp",          "trans_opt",   
  "trigger_cmd",   "trigger_cmd_list",  "trigger_decl",  "trigger_event",
  "trigger_time",  "type",          "typename",      "uniqueflag",  
  "using_opt",     "when_clause",   "where_opt",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= ecmd",
 /*   2 */ "cmdlist ::= cmdlist ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt onconf",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 125 */ "seltablist_paren ::= select",
 /* 126 */ "seltablist_paren ::= seltablist",
 /* 127 */ "dbnm ::=",
 /* 128 */ "dbnm ::= DOT nm",
 /* 129 */ "joinop ::= COMMA",
 /* 130 */ "joinop ::= JOIN",
 /* 131 */ "joinop ::= JOIN_KW JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm JOIN",
 /* 133 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 134 */ "on_opt ::= ON expr",
 /* 135 */ "on_opt ::=",
 /* 136 */ "using_opt ::= USING LP idxlist RP",
 /* 137 */ "using_opt ::=",
 /* 138 */ "orderby_opt ::=",
 /* 139 */ "orderby_opt ::= ORDER BY sortlist",
 /* 140 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 141 */ "sortlist ::= sortitem collate sortorder",
 /* 142 */ "sortitem ::= expr",
 /* 143 */ "sortorder ::= ASC",
 /* 144 */ "sortorder ::= DESC",
 /* 145 */ "sortorder ::=",
 /* 146 */ "collate ::=",
 /* 147 */ "collate ::= COLLATE id",
 /* 148 */ "groupby_opt ::=",
 /* 149 */ "groupby_opt ::= GROUP BY exprlist",
 /* 150 */ "having_opt ::=",
 /* 151 */ "having_opt ::= HAVING expr",
 /* 152 */ "limit_opt ::=",
 /* 153 */ "limit_opt ::= LIMIT signed",
 /* 154 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 155 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 156 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 157 */ "where_opt ::=",
 /* 158 */ "where_opt ::= WHERE expr",
 /* 159 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 160 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 161 */ "setlist ::= nm EQ expr",
 /* 162 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 163 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 164 */ "insert_cmd ::= INSERT orconf",
 /* 165 */ "insert_cmd ::= REPLACE",
 /* 166 */ "itemlist ::= itemlist COMMA expr",
 /* 167 */ "itemlist ::= expr",
 /* 168 */ "inscollist_opt ::=",
 /* 169 */ "inscollist_opt ::= LP inscollist RP",
 /* 170 */ "inscollist ::= inscollist COMMA nm",
 /* 171 */ "inscollist ::= nm",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "expr ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "expr ::= INTEGER",
 /* 179 */ "expr ::= FLOAT",
 /* 180 */ "expr ::= STRING",
 /* 181 */ "expr ::= VARIABLE",
 /* 182 */ "expr ::= ID LP exprlist RP",
 /* 183 */ "expr ::= ID LP STAR RP",
 /* 184 */ "expr ::= expr AND expr",
 /* 185 */ "expr ::= expr OR expr",
 /* 186 */ "expr ::= expr LT expr",
 /* 187 */ "expr ::= expr GT expr",
 /* 188 */ "expr ::= expr LE expr",
 /* 189 */ "expr ::= expr GE expr",
 /* 190 */ "expr ::= expr NE expr",
 /* 191 */ "expr ::= expr EQ expr",
 /* 192 */ "expr ::= expr BITAND expr",
 /* 193 */ "expr ::= expr BITOR expr",
 /* 194 */ "expr ::= expr LSHIFT expr",
 /* 195 */ "expr ::= expr RSHIFT expr",
 /* 196 */ "expr ::= expr likeop expr",
 /* 197 */ "expr ::= expr NOT likeop expr",
 /* 198 */ "likeop ::= LIKE",
 /* 199 */ "likeop ::= GLOB",
 /* 200 */ "expr ::= expr PLUS expr",
 /* 201 */ "expr ::= expr MINUS expr",
 /* 202 */ "expr ::= expr STAR expr",
 /* 203 */ "expr ::= expr SLASH expr",
 /* 204 */ "expr ::= expr REM expr",
 /* 205 */ "expr ::= expr CONCAT expr",
 /* 206 */ "expr ::= expr ISNULL",
 /* 207 */ "expr ::= expr IS NULL",
 /* 208 */ "expr ::= expr NOTNULL",
 /* 209 */ "expr ::= expr NOT NULL",
 /* 210 */ "expr ::= expr IS NOT NULL",
 /* 211 */ "expr ::= NOT expr",
 /* 212 */ "expr ::= BITNOT expr",
 /* 213 */ "expr ::= MINUS expr",
 /* 214 */ "expr ::= PLUS expr",
 /* 215 */ "expr ::= LP select RP",
 /* 216 */ "expr ::= expr BETWEEN expr AND expr",
 /* 217 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 218 */ "expr ::= expr IN LP exprlist RP",
 /* 219 */ "expr ::= expr IN LP select RP",
 /* 220 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 221 */ "expr ::= expr NOT IN LP select RP",
 /* 222 */ "expr ::= expr IN nm dbnm",
 /* 223 */ "expr ::= expr NOT IN nm dbnm",
 /* 224 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 225 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 226 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 227 */ "case_else ::= ELSE expr",
 /* 228 */ "case_else ::=",
 /* 229 */ "case_operand ::= expr",
 /* 230 */ "case_operand ::=",
 /* 231 */ "exprlist ::= exprlist COMMA expritem",
 /* 232 */ "exprlist ::= expritem",
 /* 233 */ "expritem ::= expr",
 /* 234 */ "expritem ::=",
 /* 235 */ "cmd ::= CREATE uniqueflag INDEX nm ON nm dbnm LP idxlist RP onconf",
 /* 236 */ "uniqueflag ::= UNIQUE",
 /* 237 */ "uniqueflag ::=",
 /* 238 */ "idxlist_opt ::=",
 /* 239 */ "idxlist_opt ::= LP idxlist RP",
 /* 240 */ "idxlist ::= idxlist COMMA idxitem",
 /* 241 */ "idxlist ::= idxitem",
 /* 242 */ "idxitem ::= nm sortorder",
 /* 243 */ "cmd ::= DROP INDEX nm dbnm",
 /* 244 */ "cmd ::= COPY orconf nm dbnm FROM nm USING DELIMITERS STRING",
 /* 245 */ "cmd ::= COPY orconf nm dbnm FROM nm",
 /* 246 */ "cmd ::= VACUUM",
 /* 247 */ "cmd ::= VACUUM nm",
 /* 248 */ "cmd ::= PRAGMA ids EQ nm",
 /* 249 */ "cmd ::= PRAGMA ids EQ ON",
 /* 250 */ "cmd ::= PRAGMA ids EQ plus_num",
 /* 251 */ "cmd ::= PRAGMA ids EQ minus_num",
 /* 252 */ "cmd ::= PRAGMA ids LP nm RP",
 /* 253 */ "cmd ::= PRAGMA ids",
 /* 254 */ "plus_num ::= plus_opt number",
 /* 255 */ "minus_num ::= MINUS number",
 /* 256 */ "number ::= INTEGER",
 /* 257 */ "number ::= FLOAT",
 /* 258 */ "plus_opt ::= PLUS",
 /* 259 */ "plus_opt ::=",
 /* 260 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 261 */ "trigger_decl ::= temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 262 */ "trigger_time ::= BEFORE",
 /* 263 */ "trigger_time ::= AFTER",
 /* 264 */ "trigger_time ::= INSTEAD OF",
 /* 265 */ "trigger_time ::=",
 /* 266 */ "trigger_event ::= DELETE",
 /* 267 */ "trigger_event ::= INSERT",
 /* 268 */ "trigger_event ::= UPDATE",
 /* 269 */ "trigger_event ::= UPDATE OF inscollist",
 /* 270 */ "foreach_clause ::=",
 /* 271 */ "foreach_clause ::= FOR EACH ROW",
 /* 272 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 273 */ "when_clause ::=",
 /* 274 */ "when_clause ::= WHEN expr",
 /* 275 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 276 */ "trigger_cmd_list ::=",
 /* 277 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 278 */ "trigger_cmd ::= INSERT orconf INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 279 */ "trigger_cmd ::= INSERT orconf INTO nm inscollist_opt select",
 /* 280 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 281 */ "trigger_cmd ::= select",
 /* 282 */ "expr ::= RAISE LP IGNORE RP",
 /* 283 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 284 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 285 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 286 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 287 */ "cmd ::= ATTACH database_kw_opt ids AS nm",
 /* 288 */ "database_kw_opt ::= DATABASE",
 /* 289 */ "database_kw_opt ::=",
 /* 290 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqliteParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqliteParser and sqliteParserFree.
*/
void *sqliteParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 135:
#line 701 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1295 "parse.c"
      break;
    case 157:
#line 532 "parse.y"
{sqliteExprDelete((yypminor->yy164));}
#line 1300 "parse.c"
      break;
    case 158:
#line 720 "parse.y"
{sqliteExprDelete((yypminor->yy164));}
#line 1305 "parse.c"
      break;
    case 159:
#line 718 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1310 "parse.c"
      break;
    case 161:
#line 342 "parse.y"
{sqliteSrcListDelete((yypminor->yy283));}
#line 1315 "parse.c"
      break;
    case 162:
#line 448 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1320 "parse.c"
      break;
    case 163:
#line 453 "parse.y"
{sqliteExprDelete((yypminor->yy164));}
#line 1325 "parse.c"
      break;
    case 167:
#line 743 "parse.y"
{sqliteIdListDelete((yypminor->yy246));}
#line 1330 "parse.c"
      break;
    case 168:
#line 745 "parse.y"
{sqliteIdListDelete((yypminor->yy246));}
#line 1335 "parse.c"
      break;
    case 171:
#line 511 "parse.y"
{sqliteIdListDelete((yypminor->yy246));}
#line 1340 "parse.c"
      break;
    case 172:
#line 509 "parse.y"
{sqliteIdListDelete((yypminor->yy246));}
#line 1345 "parse.c"
      break;
    case 174:
#line 503 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1350 "parse.c"
      break;
    case 183:
#line 409 "parse.y"
{sqliteExprDelete((yypminor->yy164));}
#line 1355 "parse.c"
      break;
    case 185:
#line 277 "parse.y"
{sqliteSelectDelete((yypminor->yy375));}
#line 1360 "parse.c"
      break;
    case 187:
#line 420 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1365 "parse.c"
      break;
    case 194:
#line 313 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1370 "parse.c"
      break;
    case 195:
#line 311 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1375 "parse.c"
      break;
    case 196:
#line 275 "parse.y"
{sqliteSelectDelete((yypminor->yy375));}
#line 1380 "parse.c"
      break;
    case 197:
#line 338 "parse.y"
{sqliteSrcListDelete((yypminor->yy283));}
#line 1385 "parse.c"
      break;
    case 198:
#line 389 "parse.y"
{sqliteSelectDelete((yypminor->yy375));}
#line 1390 "parse.c"
      break;
    case 199:
#line 478 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1395 "parse.c"
      break;
    case 201:
#line 424 "parse.y"
{sqliteExprDelete((yypminor->yy164));}
#line 1400 "parse.c"
      break;
    case 202:
#line 422 "parse.y"
{sqliteExprListDelete((yypminor->yy232));}
#line 1405 "parse.c"
      break;
    case 204:
#line 340 "parse.y"
{sqliteSrcListDelete((yypminor->yy283));}
#line 1410 "parse.c"
      break;
    case 208:
#line 835 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy353));}
#line 1415 "parse.c"
      break;
    case 209:
#line 827 "parse.y"
{sqliteDeleteTriggerStep((yypminor->yy353));}
#line 1420 "parse.c"
      break;
    case 211:
#line 811 "parse.y"
{sqliteIdListDelete((yypminor->yy414).b);}
#line 1425 "parse.c"
      break;
    case 216:
#line 414 "parse.y"
{sqliteIdListDelete((yypminor->yy246));}
#line 1430 "parse.c"
      break;
    case 218:
#line 472 "parse.y"
{sqliteExprDelete((yypminor->yy164));}
#line 1435 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqliteParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqliteParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqliteParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 170, 1 },
  { 139, 1 },
  { 139, 2 },
  { 154, 3 },
  { 154, 1 },
  { 140, 1 },
  { 156, 1 },
  { 156, 0 },
  { 138, 3 },
  { 207, 0 },
  { 207, 1 },
  { 207, 2 },
  { 138, 2 },
  { 138, 2 },
  { 138, 2 },
  { 138, 2 },
  { 147, 4 },
  { 206, 1 },
  { 206, 0 },
  { 148, 4 },
  { 148, 2 },
  { 144, 3 },
  { 144, 1 },
  { 142, 3 },
  { 143, 1 },
  { 164, 1 },
  { 165, 1 },
  { 165, 1 },
  { 181, 1 },
  { 181, 1 },
  { 181, 1 },
  { 213, 0 },
  { 213, 1 },
  { 213, 4 },
  { 213, 6 },
  { 214, 1 },
  { 214, 2 },
  { 200, 1 },
  { 200, 2 },
  { 200, 2 },
  { 133, 2 },
  { 133, 0 },
  { 132, 3 },
  { 132, 1 },
  { 132, 2 },
  { 132, 2 },
  { 132, 2 },
  { 132, 3 },
  { 132, 3 },
  { 132, 2 },
  { 132, 3 },
  { 132, 3 },
  { 132, 2 },
  { 137, 2 },
  { 137, 3 },
  { 137, 4 },
  { 137, 2 },
  { 137, 5 },
  { 137, 4 },
  { 137, 1 },
  { 137, 2 },
  { 192, 0 },
  { 192, 2 },
  { 191, 2 },
  { 191, 3 },
  { 191, 3 },
  { 191, 3 },
  { 190, 2 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 151, 3 },
  { 151, 2 },
  { 169, 0 },
  { 169, 2 },
  { 169, 2 },
  { 146, 0 },
  { 146, 2 },
  { 145, 3 },
  { 145, 2 },
  { 145, 1 },
  { 205, 2 },
  { 205, 6 },
  { 205, 5 },
  { 205, 3 },
  { 205, 10 },
  { 152, 0 },
  { 152, 1 },
  { 184, 0 },
  { 184, 3 },
  { 186, 0 },
  { 186, 2 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 138, 3 },
  { 138, 6 },
  { 138, 3 },
  { 138, 1 },
  { 196, 1 },
  { 196, 3 },
  { 180, 1 },
  { 180, 2 },
  { 180, 1 },
  { 180, 1 },
  { 185, 9 },
  { 153, 1 },
  { 153, 1 },
  { 153, 0 },
  { 194, 2 },
  { 194, 0 },
  { 195, 3 },
  { 195, 2 },
  { 195, 4 },
  { 131, 2 },
  { 131, 1 },
  { 131, 0 },
  { 161, 0 },
  { 161, 2 },
  { 204, 2 },
  { 204, 0 },
  { 197, 6 },
  { 197, 7 },
  { 198, 1 },
  { 198, 1 },
  { 150, 0 },
  { 150, 2 },
  { 175, 1 },
  { 175, 1 },
  { 175, 2 },
  { 175, 3 },
  { 175, 4 },
  { 183, 2 },
  { 183, 0 },
  { 216, 4 },
  { 216, 0 },
  { 187, 0 },
  { 187, 3 },
  { 202, 5 },
  { 202, 3 },
  { 201, 1 },
  { 203, 1 },
  { 203, 1 },
  { 203, 0 },
  { 141, 0 },
  { 141, 2 },
  { 162, 0 },
  { 162, 3 },
  { 163, 0 },
  { 163, 2 },
  { 178, 0 },
  { 178, 2 },
  { 178, 4 },
  { 178, 4 },
  { 138, 5 },
  { 218, 0 },
  { 218, 2 },
  { 138, 7 },
  { 199, 5 },
  { 199, 3 },
  { 138, 9 },
  { 138, 6 },
  { 173, 2 },
  { 173, 1 },
  { 174, 3 },
  { 174, 1 },
  { 172, 0 },
  { 172, 3 },
  { 171, 3 },
  { 171, 1 },
  { 157, 3 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 3 },
  { 157, 5 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 4 },
  { 157, 4 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 4 },
  { 177, 1 },
  { 177, 1 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 3 },
  { 157, 2 },
  { 157, 3 },
  { 157, 2 },
  { 157, 3 },
  { 157, 4 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 3 },
  { 157, 5 },
  { 157, 6 },
  { 157, 5 },
  { 157, 5 },
  { 157, 6 },
  { 157, 6 },
  { 157, 4 },
  { 157, 5 },
  { 157, 5 },
  { 135, 5 },
  { 135, 4 },
  { 134, 2 },
  { 134, 0 },
  { 136, 1 },
  { 136, 0 },
  { 159, 3 },
  { 159, 1 },
  { 158, 1 },
  { 158, 0 },
  { 138, 11 },
  { 215, 1 },
  { 215, 0 },
  { 168, 0 },
  { 168, 3 },
  { 167, 3 },
  { 167, 1 },
  { 166, 2 },
  { 138, 4 },
  { 138, 9 },
  { 138, 6 },
  { 138, 1 },
  { 138, 2 },
  { 138, 4 },
  { 138, 4 },
  { 138, 4 },
  { 138, 4 },
  { 138, 5 },
  { 138, 2 },
  { 188, 2 },
  { 179, 2 },
  { 182, 1 },
  { 182, 1 },
  { 189, 1 },
  { 189, 0 },
  { 138, 5 },
  { 210, 10 },
  { 212, 1 },
  { 212, 1 },
  { 212, 2 },
  { 212, 0 },
  { 211, 1 },
  { 211, 1 },
  { 211, 1 },
  { 211, 3 },
  { 160, 0 },
  { 160, 3 },
  { 160, 3 },
  { 217, 0 },
  { 217, 2 },
  { 209, 3 },
  { 209, 0 },
  { 208, 6 },
  { 208, 9 },
  { 208, 6 },
  { 208, 4 },
  { 208, 1 },
  { 157, 4 },
  { 157, 6 },
  { 157, 6 },
  { 157, 6 },
  { 138, 4 },
  { 138, 5 },
  { 149, 1 },
  { 149, 0 },
  { 138, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqliteParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for cmdlist */
        break;
      case 1:
        /* No destructor defined for ecmd */
        break;
      case 2:
        /* No destructor defined for cmdlist */
        /* No destructor defined for ecmd */
        break;
      case 3:
        /* No destructor defined for explain */
        /* No destructor defined for cmdx */
        /* No destructor defined for SEMI */
        break;
      case 4:
        /* No destructor defined for SEMI */
        break;
      case 5:
#line 77 "parse.y"
{ sqliteExec(pParse); }
#line 1959 "parse.c"
        /* No destructor defined for cmd */
        break;
      case 6:
#line 78 "parse.y"
{ sqliteBeginParse(pParse, 1); }
#line 1965 "parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
#line 79 "parse.y"
{ sqliteBeginParse(pParse, 0); }
#line 1971 "parse.c"
        break;
      case 8:
#line 84 "parse.y"
{sqliteBeginTransaction(pParse,yymsp[0].minor.yy424);}
#line 1976 "parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 9:
        break;
      case 10:
        /* No destructor defined for TRANSACTION */
        break;
      case 11:
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for nm */
        break;
      case 12:
#line 88 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1992 "parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 13:
#line 89 "parse.y"
{sqliteCommitTransaction(pParse);}
#line 1999 "parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 14:
#line 90 "parse.y"
{sqliteRollbackTransaction(pParse);}
#line 2006 "parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 15:
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 16:
#line 95 "parse.y"
{
   sqliteStartTable(pParse,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy318,yymsp[-2].minor.yy424,0);
}
#line 2019 "parse.c"
        /* No destructor defined for TABLE */
        break;
      case 17:
#line 99 "parse.y"
{yygotominor.yy424 = 1;}
#line 2025 "parse.c"
        /* No destructor defined for TEMP */
        break;
      case 18:
#line 100 "parse.y"
{yygotominor.yy424 = 0;}
#line 2031 "parse.c"
        break;
      case 19:
#line 101 "parse.y"
{
  sqliteEndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 2038 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 20:
#line 104 "parse.y"
{
  sqliteEndTable(pParse,0,yymsp[0].minor.yy375);
  sqliteSelectDelete(yymsp[0].minor.yy375);
}
#line 2049 "parse.c"
        /* No destructor defined for AS */
        break;
      case 21:
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 22:
        /* No destructor defined for column */
        break;
      case 23:
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 24:
#line 116 "parse.y"
{sqliteAddColumn(pParse,&yymsp[0].minor.yy318);}
#line 2068 "parse.c"
        break;
      case 25:
#line 122 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2073 "parse.c"
        break;
      case 26:
#line 138 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2078 "parse.c"
        break;
      case 27:
#line 139 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2083 "parse.c"
        break;
      case 28:
#line 144 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2088 "parse.c"
        break;
      case 29:
#line 145 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2093 "parse.c"
        break;
      case 30:
#line 146 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2098 "parse.c"
        break;
      case 31:
        break;
      case 32:
#line 149 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[0].minor.yy318,&yymsp[0].minor.yy318);}
#line 2105 "parse.c"
        break;
      case 33:
#line 150 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-3].minor.yy318,&yymsp[0].minor.yy0);}
#line 2110 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 34:
#line 152 "parse.y"
{sqliteAddColumnType(pParse,&yymsp[-5].minor.yy318,&yymsp[0].minor.yy0);}
#line 2117 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 35:
#line 154 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 2126 "parse.c"
        break;
      case 36:
#line 155 "parse.y"
{yygotominor.yy318 = yymsp[-1].minor.yy318;}
#line 2131 "parse.c"
        /* No destructor defined for ids */
        break;
      case 37:
#line 157 "parse.y"
{ yygotominor.yy424 = atoi(yymsp[0].minor.yy0.z); }
#line 2137 "parse.c"
        break;
      case 38:
#line 158 "parse.y"
{ yygotominor.yy424 = atoi(yymsp[0].minor.yy0.z); }
#line 2142 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 39:
#line 159 "parse.y"
{ yygotominor.yy424 = -atoi(yymsp[0].minor.yy0.z); }
#line 2148 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 40:
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 41:
        break;
      case 42:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        /* No destructor defined for ccons */
        break;
      case 43:
        /* No destructor defined for ccons */
        break;
      case 44:
#line 164 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2168 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 45:
#line 165 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2174 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 46:
#line 166 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2180 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 47:
#line 167 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2186 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 48:
#line 168 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2193 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 49:
#line 169 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2200 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 50:
#line 170 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2206 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 51:
#line 171 "parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2213 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 52:
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 53:
        /* No destructor defined for NULL */
        /* No destructor defined for onconf */
        break;
      case 54:
#line 178 "parse.y"
{sqliteAddNotNull(pParse, yymsp[0].minor.yy424);}
#line 2228 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 55:
#line 179 "parse.y"
{sqliteAddPrimaryKey(pParse,0,yymsp[0].minor.yy424);}
#line 2235 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 56:
#line 180 "parse.y"
{sqliteCreateIndex(pParse,0,0,0,yymsp[0].minor.yy424,0,0);}
#line 2243 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 57:
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(157,&yymsp[-2].minor);
        /* No destructor defined for RP */
        /* No destructor defined for onconf */
        break;
      case 58:
#line 183 "parse.y"
{sqliteCreateForeignKey(pParse,0,&yymsp[-2].minor.yy318,yymsp[-1].minor.yy246,yymsp[0].minor.yy424);}
#line 2256 "parse.c"
        /* No destructor defined for REFERENCES */
        break;
      case 59:
#line 184 "parse.y"
{sqliteDeferForeignKey(pParse,yymsp[0].minor.yy424);}
#line 2262 "parse.c"
        break;
      case 60:
#line 185 "parse.y"
{
   sqliteAddCollateType(pParse, sqliteCollateType(yymsp[0].minor.yy318.z, yymsp[0].minor.yy318.n));
}
#line 2269 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 61:
#line 195 "parse.y"
{ yygotominor.yy424 = OE_Restrict * 0x010101; }
#line 2275 "parse.c"
        break;
      case 62:
#line 196 "parse.y"
{ yygotominor.yy424 = (yymsp[-1].minor.yy424 & yymsp[0].minor.yy299.mask) | yymsp[0].minor.yy299.value; }
#line 2280 "parse.c"
        break;
      case 63:
#line 198 "parse.y"
{ yygotominor.yy299.value = 0;     yygotominor.yy299.mask = 0x000000; }
#line 2285 "parse.c"
        /* No destructor defined for MATCH */
        /* No destructor defined for nm */
        break;
      case 64:
#line 199 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424;     yygotominor.yy299.mask = 0x0000ff; }
#line 2292 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for DELETE */
        break;
      case 65:
#line 200 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<8;  yygotominor.yy299.mask = 0x00ff00; }
#line 2299 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for UPDATE */
        break;
      case 66:
#line 201 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<16; yygotominor.yy299.mask = 0xff0000; }
#line 2306 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for INSERT */
        break;
      case 67:
#line 203 "parse.y"
{ yygotominor.yy424 = OE_SetNull; }
#line 2313 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for NULL */
        break;
      case 68:
#line 204 "parse.y"
{ yygotominor.yy424 = OE_SetDflt; }
#line 2320 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for DEFAULT */
        break;
      case 69:
#line 205 "parse.y"
{ yygotominor.yy424 = OE_Cascade; }
#line 2327 "parse.c"
        /* No destructor defined for CASCADE */
        break;
      case 70:
#line 206 "parse.y"
{ yygotominor.yy424 = OE_Restrict; }
#line 2333 "parse.c"
        /* No destructor defined for RESTRICT */
        break;
      case 71:
#line 208 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2339 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for DEFERRABLE */
        break;
      case 72:
#line 209 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2346 "parse.c"
        /* No destructor defined for DEFERRABLE */
        break;
      case 73:
#line 211 "parse.y"
{yygotominor.yy424 = 0;}
#line 2352 "parse.c"
        break;
      case 74:
#line 212 "parse.y"
{yygotominor.yy424 = 1;}
#line 2357 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for DEFERRED */
        break;
      case 75:
#line 213 "parse.y"
{yygotominor.yy424 = 0;}
#line 2364 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for IMMEDIATE */
        break;
      case 76:
        break;
      case 77:
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 78:
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 79:
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 80:
        /* No destructor defined for tcons */
        break;
      case 81:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        break;
      case 82:
#line 225 "parse.y"
{sqliteAddPrimaryKey(pParse,yymsp[-2].minor.yy246,yymsp[0].minor.yy424);}
#line 2393 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 83:
#line 227 "parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-2].minor.yy246,yymsp[0].minor.yy424,0,0);}
#line 2402 "parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 84:
        /* No destructor defined for CHECK */
  yy_destructor(157,&yymsp[-1].minor);
        /* No destructor defined for onconf */
        break;
      case 85:
#line 230 "parse.y"
{
    sqliteCreateForeignKey(pParse, yymsp[-6].minor.yy246, &yymsp[-3].minor.yy318, yymsp[-2].minor.yy246, yymsp[-1].minor.yy424);
    sqliteDeferForeignKey(pParse, yymsp[0].minor.yy424);
}
#line 2418 "parse.c"
        /* No destructor defined for FOREIGN */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        /* No destructor defined for REFERENCES */
        break;
      case 86:
#line 235 "parse.y"
{yygotominor.yy424 = 0;}
#line 2428 "parse.c"
        break;
      case 87:
#line 236 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2433 "parse.c"
        break;
      case 88:
#line 244 "parse.y"
{ yygotominor.yy424 = OE_Default; }
#line 2438 "parse.c"
        break;
      case 89:
#line 245 "parse.y"
{ yygotominor.yy424 = yymsp[0].minor.yy424; }
#line 2443 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for CONFLICT */
        break;
      case 90:
#line 246 "parse.y"
{ yygotominor.yy424 = OE_Default; }
#line 2450 "parse.c"
        break;
      case 91:
#line 247 "parse.y"
{ yygotominor.yy424 = yymsp[0].minor.yy424; }
#line 2455 "parse.c"
        /* No destructor defined for OR */
        break;
      case 92:
#line 248 "parse.y"
{ yygotominor.yy424 = OE_Rollback; }
#line 2461 "parse.c"
        /* No destructor defined for ROLLBACK */
        break;
      case 93:
#line 249 "parse.y"
{ yygotominor.yy424 = OE_Abort; }
#line 2467 "parse.c"
        /* No destructor defined for ABORT */
        break;
      case 94:
#line 250 "parse.y"
{ yygotominor.yy424 = OE_Fail; }
#line 2473 "parse.c"
        /* No destructor defined for FAIL */
        break;
      case 95:
#line 251 "parse.y"
{ yygotominor.yy424 = OE_Ignore; }
#line 2479 "parse.c"
        /* No destructor defined for IGNORE */
        break;
      case 96:
#line 252 "parse.y"
{ yygotominor.yy424 = OE_Replace; }
#line 2485 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 97:
#line 256 "parse.y"
{sqliteDropTable(pParse,&yymsp[0].minor.yy318,0);}
#line 2491 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 98:
#line 260 "parse.y"
{
  sqliteCreateView(pParse, &yymsp[-5].minor.yy0, &yymsp[-2].minor.yy318, yymsp[0].minor.yy375, yymsp[-4].minor.yy424);
}
#line 2500 "parse.c"
        /* No destructor defined for VIEW */
        /* No destructor defined for AS */
        break;
      case 99:
#line 263 "parse.y"
{
  sqliteDropTable(pParse, &yymsp[0].minor.yy318, 1);
}
#line 2509 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for VIEW */
        break;
      case 100:
#line 269 "parse.y"
{
  sqliteSelect(pParse, yymsp[0].minor.yy375, SRT_Callback, 0, 0, 0, 0);
  sqliteSelectDelete(yymsp[0].minor.yy375);
}
#line 2519 "parse.c"
        break;
      case 101:
#line 279 "parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2524 "parse.c"
        break;
      case 102:
#line 280 "parse.y"
{
  if( yymsp[0].minor.yy375 ){
    yymsp[0].minor.yy375->op = yymsp[-1].minor.yy424;
    yymsp[0].minor.yy375->pPrior = yymsp[-2].minor.yy375;
  }
  yygotominor.yy375 = yymsp[0].minor.yy375;
}
#line 2535 "parse.c"
        break;
      case 103:
#line 288 "parse.y"
{yygotominor.yy424 = TK_UNION;}
#line 2540 "parse.c"
        /* No destructor defined for UNION */
        break;
      case 104:
#line 289 "parse.y"
{yygotominor.yy424 = TK_ALL;}
#line 2546 "parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 105:
#line 290 "parse.y"
{yygotominor.yy424 = TK_INTERSECT;}
#line 2553 "parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 106:
#line 291 "parse.y"
{yygotominor.yy424 = TK_EXCEPT;}
#line 2559 "parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 107:
#line 293 "parse.y"
{
  yygotominor.yy375 = sqliteSelectNew(yymsp[-6].minor.yy232,yymsp[-5].minor.yy283,yymsp[-4].minor.yy164,yymsp[-3].minor.yy232,yymsp[-2].minor.yy164,yymsp[-1].minor.yy232,yymsp[-7].minor.yy424,yymsp[0].minor.yy22.limit,yymsp[0].minor.yy22.offset);
}
#line 2567 "parse.c"
        /* No destructor defined for SELECT */
        break;
      case 108:
#line 301 "parse.y"
{yygotominor.yy424 = 1;}
#line 2573 "parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 109:
#line 302 "parse.y"
{yygotominor.yy424 = 0;}
#line 2579 "parse.c"
        /* No destructor defined for ALL */
        break;
      case 110:
#line 303 "parse.y"
{yygotominor.yy424 = 0;}
#line 2585 "parse.c"
        break;
      case 111:
#line 314 "parse.y"
{yygotominor.yy232 = yymsp[-1].minor.yy232;}
#line 2590 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 112:
#line 315 "parse.y"
{yygotominor.yy232 = 0;}
#line 2596 "parse.c"
        break;
      case 113:
#line 316 "parse.y"
{
   yygotominor.yy232 = sqliteExprListAppend(yymsp[-2].minor.yy232,yymsp[-1].minor.yy164,yymsp[0].minor.yy318.n?&yymsp[0].minor.yy318:0);
}
#line 2603 "parse.c"
        break;
      case 114:
#line 319 "parse.y"
{
  yygotominor.yy232 = sqliteExprListAppend(yymsp[-1].minor.yy232, sqliteExpr(TK_ALL, 0, 0, 0), 0);
}
#line 2610 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 115:
#line 322 "parse.y"
{
  Expr *pRight = sqliteExpr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  yygotominor.yy232 = sqliteExprListAppend(yymsp[-3].minor.yy232, sqliteExpr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2620 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for STAR */
        break;
      case 116:
#line 332 "parse.y"
{ yygotominor.yy318 = yymsp[0].minor.yy318; }
#line 2627 "parse.c"
        /* No destructor defined for AS */
        break;
      case 117:
#line 333 "parse.y"
{ yygotominor.yy318 = yymsp[0].minor.yy318; }
#line 2633 "parse.c"
        break;
      case 118:
#line 334 "parse.y"
{ yygotominor.yy318.n = 0; }
#line 2638 "parse.c"
        break;
      case 119:
#line 346 "parse.y"
{yygotominor.yy283 = sqliteMalloc(sizeof(*yygotominor.yy283));}
#line 2643 "parse.c"
        break;
      case 120:
#line 347 "parse.y"
{yygotominor.yy283 = yymsp[0].minor.yy283;}
#line 2648 "parse.c"
        /* No destructor defined for FROM */
        break;
      case 121:
#line 352 "parse.y"
{
   yygotominor.yy283 = yymsp[-1].minor.yy283;
   if( yygotominor.yy283 && yygotominor.yy283->nSrc>0 ) yygotominor.yy283->a[yygotominor.yy283->nSrc-1].jointype = yymsp[0].minor.yy424;
}
#line 2657 "parse.c"
        break;
      case 122:
#line 356 "parse.y"
{yygotominor.yy283 = 0;}
#line 2662 "parse.c"
        break;
      case 123:
#line 357 "parse.y"
{
  yygotominor.yy283 = sqliteSrcListAppend(yymsp[-5].minor.yy283,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318);
  if( yymsp[-2].minor.yy318.n ) sqliteSrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqliteExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqliteIdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2678 "parse.c"
        break;
      case 124:
#line 370 "parse.y"
{
  yygotominor.yy283 = sqliteSrcListAppend(yymsp[-6].minor.yy283,0,0);
  yygotominor.yy283->a[yygotominor.yy283->nSrc-1].pSelect = yymsp[-4].minor.yy375;
  if( yymsp[-2].minor.yy318.n ) sqliteSrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqliteExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqliteIdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2695 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 125:
#line 390 "parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2702 "parse.c"
        break;
      case 126:
#line 391 "parse.y"
{
   yygotominor.yy375 = sqliteSelectNew(0,yymsp[0].minor.yy283,0,0,0,0,0,-1,0);
}
#line 2709 "parse.c"
        break;
      case 127:
#line 396 "parse.y"
{yygotominor.yy318.z=0; yygotominor.yy318.n=0;}
#line 2714 "parse.c"
        break;
      case 128:
#line 397 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 2719 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 129:
#line 401 "parse.y"
{ yygotominor.yy424 = JT_INNER; }
#line 2725 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 130:
#line 402 "parse.y"
{ yygotominor.yy424 = JT_INNER; }
#line 2731 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 131:
#line 403 "parse.y"
{ yygotominor.yy424 = sqliteJoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2737 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 132:
#line 404 "parse.y"
{ yygotominor.yy424 = sqliteJoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy318,0); }
#line 2743 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 133:
#line 406 "parse.y"
{ yygotominor.yy424 = sqliteJoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318); }
#line 2749 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 134:
#line 410 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2755 "parse.c"
        /* No destructor defined for ON */
        break;
      case 135:
#line 411 "parse.y"
{yygotominor.yy164 = 0;}
#line 2761 "parse.c"
        break;
      case 136:
#line 415 "parse.y"
{yygotominor.yy246 = yymsp[-1].minor.yy246;}
#line 2766 "parse.c"
        /* No destructor defined for USING */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 137:
#line 416 "parse.y"
{yygotominor.yy246 = 0;}
#line 2774 "parse.c"
        break;
      case 138:
#line 426 "parse.y"
{yygotominor.yy232 = 0;}
#line 2779 "parse.c"
        break;
      case 139:
#line 427 "parse.y"
{yygotominor.yy232 = yymsp[0].minor.yy232;}
#line 2784 "parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 140:
#line 428 "parse.y"
{
  yygotominor.yy232 = sqliteExprListAppend(yymsp[-4].minor.yy232,yymsp[-2].minor.yy164,0);
  if( yygotominor.yy232 ) yygotominor.yy232->a[yygotominor.yy232->nExpr-1].sortOrder = yymsp[-1].minor.yy424+yymsp[0].minor.yy424;
}
#line 2794 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 141:
#line 432 "parse.y"
{
  yygotominor.yy232 = sqliteExprListAppend(0,yymsp[-2].minor.yy164,0);
  if( yygotominor.yy232 ) yygotominor.yy232->a[0].sortOrder = yymsp[-1].minor.yy424+yymsp[0].minor.yy424;
}
#line 2803 "parse.c"
        break;
      case 142:
#line 436 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2808 "parse.c"
        break;
      case 143:
#line 441 "parse.y"
{yygotominor.yy424 = SQLITE_SO_ASC;}
#line 2813 "parse.c"
        /* No destructor defined for ASC */
        break;
      case 144:
#line 442 "parse.y"
{yygotominor.yy424 = SQLITE_SO_DESC;}
#line 2819 "parse.c"
        /* No destructor defined for DESC */
        break;
      case 145:
#line 443 "parse.y"
{yygotominor.yy424 = SQLITE_SO_ASC;}
#line 2825 "parse.c"
        break;
      case 146:
#line 444 "parse.y"
{yygotominor.yy424 = SQLITE_SO_UNK;}
#line 2830 "parse.c"
        break;
      case 147:
#line 445 "parse.y"
{yygotominor.yy424 = sqliteCollateType(yymsp[0].minor.yy318.z, yymsp[0].minor.yy318.n);}
#line 2835 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 148:
#line 449 "parse.y"
{yygotominor.yy232 = 0;}
#line 2841 "parse.c"
        break;
      case 149:
#line 450 "parse.y"
{yygotominor.yy232 = yymsp[0].minor.yy232;}
#line 2846 "parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 150:
#line 454 "parse.y"
{yygotominor.yy164 = 0;}
#line 2853 "parse.c"
        break;
      case 151:
#line 455 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2858 "parse.c"
        /* No destructor defined for HAVING */
        break;
      case 152:
#line 458 "parse.y"
{yygotominor.yy22.limit = -1; yygotominor.yy22.offset = 0;}
#line 2864 "parse.c"
        break;
      case 153:
#line 459 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = 0;}
#line 2869 "parse.c"
        /* No destructor defined for LIMIT */
        break;
      case 154:
#line 461 "parse.y"
{yygotominor.yy22.limit = yymsp[-2].minor.yy424; yygotominor.yy22.offset = yymsp[0].minor.yy424;}
#line 2875 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for OFFSET */
        break;
      case 155:
#line 463 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = yymsp[-2].minor.yy424;}
#line 2882 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for COMMA */
        break;
      case 156:
#line 467 "parse.y"
{
   sqliteDeleteFrom(pParse, sqliteSrcListAppend(0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318), yymsp[0].minor.yy164);
}
#line 2891 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 157:
#line 474 "parse.y"
{yygotominor.yy164 = 0;}
#line 2898 "parse.c"
        break;
      case 158:
#line 475 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2903 "parse.c"
        /* No destructor defined for WHERE */
        break;
      case 159:
#line 483 "parse.y"
{sqliteUpdate(pParse,sqliteSrcListAppend(0,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318),yymsp[-1].minor.yy232,yymsp[0].minor.yy164,yymsp[-5].minor.yy424);}
#line 2909 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 160:
#line 486 "parse.y"
{yygotominor.yy232 = sqliteExprListAppend(yymsp[-4].minor.yy232,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2916 "parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 161:
#line 487 "parse.y"
{yygotominor.yy232 = sqliteExprListAppend(0,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2923 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 162:
#line 493 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-6].minor.yy318,&yymsp[-5].minor.yy318), yymsp[-1].minor.yy232, 0, yymsp[-4].minor.yy246, yymsp[-8].minor.yy424);}
#line 2929 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 163:
#line 495 "parse.y"
{sqliteInsert(pParse, sqliteSrcListAppend(0,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318), 0, yymsp[0].minor.yy375, yymsp[-1].minor.yy246, yymsp[-5].minor.yy424);}
#line 2938 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 164:
#line 498 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2944 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 165:
#line 499 "parse.y"
{yygotominor.yy424 = OE_Replace;}
#line 2950 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 166:
#line 505 "parse.y"
{yygotominor.yy232 = sqliteExprListAppend(yymsp[-2].minor.yy232,yymsp[0].minor.yy164,0);}
#line 2956 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 167:
#line 506 "parse.y"
{yygotominor.yy232 = sqliteExprListAppend(0,yymsp[0].minor.yy164,0);}
#line 2962 "parse.c"
        break;
      case 168:
#line 513 "parse.y"
{yygotominor.yy246 = 0;}
#line 2967 "parse.c"
        break;
      case 169:
#line 514 "parse.y"
{yygotominor.yy246 = yymsp[-1].minor.yy246;}
#line 2972 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 170:
#line 515 "parse.y"
{yygotominor.yy246 = sqliteIdListAppend(yymsp[-2].minor.yy246,&yymsp[0].minor.yy318);}
#line 2979 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 171:
#line 516 "parse.y"
{yygotominor.yy246 = sqliteIdListAppend(0,&yymsp[0].minor.yy318);}
#line 2985 "parse.c"
        break;
      case 172:
#line 534 "parse.y"
{yygotominor.yy164 = yymsp[-1].minor.yy164; sqliteExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2990 "parse.c"
        break;
      case 173:
#line 535 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 2995 "parse.c"
        break;
      case 174:
#line 536 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 3000 "parse.c"
        break;
      case 175:
#line 537 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 3005 "parse.c"
        break;
      case 176:
#line 538 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqliteExpr(TK_DOT, temp1, temp2, 0);
}
#line 3014 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 177:
#line 543 "parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-4].minor.yy318);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp3 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  Expr *temp4 = sqliteExpr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy164 = sqliteExpr(TK_DOT, temp1, temp4, 0);
}
#line 3026 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for DOT */
        break;
      case 178:
#line 550 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 3033 "parse.c"
        break;
      case 179:
#line 551 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 3038 "parse.c"
        break;
      case 180:
#line 552 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 3043 "parse.c"
        break;
      case 181:
#line 553 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_VARIABLE, 0, 0, &yymsp[0].minor.yy0);
  if( yygotominor.yy164 ) yygotominor.yy164->iTable = ++pParse->nVar;
}
#line 3051 "parse.c"
        break;
      case 182:
#line 557 "parse.y"
{
  yygotominor.yy164 = sqliteExprFunction(yymsp[-1].minor.yy232, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3059 "parse.c"
        /* No destructor defined for LP */
        break;
      case 183:
#line 561 "parse.y"
{
  yygotominor.yy164 = sqliteExprFunction(0, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3068 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 184:
#line 565 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_AND, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3075 "parse.c"
        /* No destructor defined for AND */
        break;
      case 185:
#line 566 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_OR, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3081 "parse.c"
        /* No destructor defined for OR */
        break;
      case 186:
#line 567 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_LT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3087 "parse.c"
        /* No destructor defined for LT */
        break;
      case 187:
#line 568 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_GT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3093 "parse.c"
        /* No destructor defined for GT */
        break;
      case 188:
#line 569 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_LE, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3099 "parse.c"
        /* No destructor defined for LE */
        break;
      case 189:
#line 570 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_GE, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3105 "parse.c"
        /* No destructor defined for GE */
        break;
      case 190:
#line 571 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_NE, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3111 "parse.c"
        /* No destructor defined for NE */
        break;
      case 191:
#line 572 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_EQ, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3117 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 192:
#line 573 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_BITAND, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3123 "parse.c"
        /* No destructor defined for BITAND */
        break;
      case 193:
#line 574 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_BITOR, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3129 "parse.c"
        /* No destructor defined for BITOR */
        break;
      case 194:
#line 575 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_LSHIFT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3135 "parse.c"
        /* No destructor defined for LSHIFT */
        break;
      case 195:
#line 576 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_RSHIFT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3141 "parse.c"
        /* No destructor defined for RSHIFT */
        break;
      case 196:
#line 577 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqliteExprListAppend(pList, yymsp[-2].minor.yy164, 0);
  yygotominor.yy164 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  sqliteExprSpan(yygotominor.yy164, &yymsp[-2].minor.yy164->span, &yymsp[0].minor.yy164->span);
}
#line 3153 "parse.c"
        break;
      case 197:
#line 584 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqliteExprListAppend(pList, yymsp[-3].minor.yy164, 0);
  yygotominor.yy164 = sqliteExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  yygotominor.yy164 = sqliteExpr(TK_NOT, yygotominor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 3165 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 198:
#line 593 "parse.y"
{yygotominor.yy424 = TK_LIKE;}
#line 3171 "parse.c"
        /* No destructor defined for LIKE */
        break;
      case 199:
#line 594 "parse.y"
{yygotominor.yy424 = TK_GLOB;}
#line 3177 "parse.c"
        /* No destructor defined for GLOB */
        break;
      case 200:
#line 595 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_PLUS, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3183 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 201:
#line 596 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_MINUS, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3189 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 202:
#line 597 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_STAR, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3195 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 203:
#line 598 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_SLASH, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3201 "parse.c"
        /* No destructor defined for SLASH */
        break;
      case 204:
#line 599 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_REM, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3207 "parse.c"
        /* No destructor defined for REM */
        break;
      case 205:
#line 600 "parse.y"
{yygotominor.yy164 = sqliteExpr(TK_CONCAT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3213 "parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 206:
#line 601 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_ISNULL, yymsp[-1].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3222 "parse.c"
        break;
      case 207:
#line 605 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_ISNULL, yymsp[-2].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3230 "parse.c"
        /* No destructor defined for IS */
        break;
      case 208:
#line 609 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_NOTNULL, yymsp[-1].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3239 "parse.c"
        break;
      case 209:
#line 613 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_NOTNULL, yymsp[-2].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3247 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 210:
#line 617 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_NOTNULL, yymsp[-3].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3256 "parse.c"
        /* No destructor defined for IS */
        /* No destructor defined for NOT */
        break;
      case 211:
#line 621 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_NOT, yymsp[0].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3266 "parse.c"
        break;
      case 212:
#line 625 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_BITNOT, yymsp[0].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3274 "parse.c"
        break;
      case 213:
#line 629 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_UMINUS, yymsp[0].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3282 "parse.c"
        break;
      case 214:
#line 633 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_UPLUS, yymsp[0].minor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3290 "parse.c"
        break;
      case 215:
#line 637 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqliteExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3299 "parse.c"
        break;
      case 216:
#line 642 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqliteExpr(TK_BETWEEN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  sqliteExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 3310 "parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 217:
#line 649 "parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqliteExpr(TK_BETWEEN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  yygotominor.yy164 = sqliteExpr(TK_NOT, yygotominor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 3324 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 218:
#line 657 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  sqliteExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3336 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 219:
#line 662 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqliteExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3347 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 220:
#line 667 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  yygotominor.yy164 = sqliteExpr(TK_NOT, yygotominor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3359 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 221:
#line 673 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  yygotominor.yy164 = sqliteExpr(TK_NOT, yygotominor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3372 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 222:
#line 679 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqliteExpr(TK_IN, yymsp[-3].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqliteSelectNew(0,pSrc,0,0,0,0,0,-1,0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 3385 "parse.c"
        /* No destructor defined for IN */
        break;
      case 223:
#line 685 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqliteExpr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqliteSelectNew(0,pSrc,0,0,0,0,0,-1,0);
  yygotominor.yy164 = sqliteExpr(TK_NOT, yygotominor.yy164, 0, 0);
  sqliteExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 3397 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        break;
      case 224:
#line 695 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_CASE, yymsp[-3].minor.yy164, yymsp[-1].minor.yy164, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-2].minor.yy232;
  sqliteExprSpan(yygotominor.yy164, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3408 "parse.c"
        break;
      case 225:
#line 702 "parse.y"
{
  yygotominor.yy232 = sqliteExprListAppend(yymsp[-4].minor.yy232, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqliteExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 3416 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 226:
#line 706 "parse.y"
{
  yygotominor.yy232 = sqliteExprListAppend(0, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqliteExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 3426 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 227:
#line 711 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 3433 "parse.c"
        /* No destructor defined for ELSE */
        break;
      case 228:
#line 712 "parse.y"
{yygotominor.yy164 = 0;}
#line 3439 "parse.c"
        break;
      case 229:
#line 714 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 3444 "parse.c"
        break;
      case 230:
#line 715 "parse.y"
{yygotominor.yy164 = 0;}
#line 3449 "parse.c"
        break;
      case 231:
#line 723 "parse.y"
{yygotominor.yy232 = sqliteExprListAppend(yymsp[-2].minor.yy232,yymsp[0].minor.yy164,0);}
#line 3454 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 232:
#line 724 "parse.y"
{yygotominor.yy232 = sqliteExprListAppend(0,yymsp[0].minor.yy164,0);}
#line 3460 "parse.c"
        break;
      case 233:
#line 725 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 3465 "parse.c"
        break;
      case 234:
#line 726 "parse.y"
{yygotominor.yy164 = 0;}
#line 3470 "parse.c"
        break;
      case 235:
#line 731 "parse.y"
{
  SrcList *pSrc = sqliteSrcListAppend(0, &yymsp[-5].minor.yy318, &yymsp[-4].minor.yy318);
  if( yymsp[-9].minor.yy424!=OE_None ) yymsp[-9].minor.yy424 = yymsp[0].minor.yy424;
  if( yymsp[-9].minor.yy424==OE_Default) yymsp[-9].minor.yy424 = OE_Abort;
  sqliteCreateIndex(pParse, &yymsp[-7].minor.yy318, pSrc, yymsp[-2].minor.yy246, yymsp[-9].minor.yy424, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 3480 "parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 236:
#line 739 "parse.y"
{ yygotominor.yy424 = OE_Abort; }
#line 3488 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 237:
#line 740 "parse.y"
{ yygotominor.yy424 = OE_None; }
#line 3494 "parse.c"
        break;
      case 238:
#line 748 "parse.y"
{yygotominor.yy246 = 0;}
#line 3499 "parse.c"
        break;
      case 239:
#line 749 "parse.y"
{yygotominor.yy246 = yymsp[-1].minor.yy246;}
#line 3504 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 240:
#line 750 "parse.y"
{yygotominor.yy246 = sqliteIdListAppend(yymsp[-2].minor.yy246,&yymsp[0].minor.yy318);}
#line 3511 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 241:
#line 751 "parse.y"
{yygotominor.yy246 = sqliteIdListAppend(0,&yymsp[0].minor.yy318);}
#line 3517 "parse.c"
        break;
      case 242:
#line 752 "parse.y"
{yygotominor.yy318 = yymsp[-1].minor.yy318;}
#line 3522 "parse.c"
        /* No destructor defined for sortorder */
        break;
      case 243:
#line 757 "parse.y"
{
  sqliteDropIndex(pParse, sqliteSrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 3530 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 244:
#line 765 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-6].minor.yy318,&yymsp[-5].minor.yy318),&yymsp[-3].minor.yy318,&yymsp[0].minor.yy0,yymsp[-7].minor.yy424);}
#line 3537 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        /* No destructor defined for USING */
        /* No destructor defined for DELIMITERS */
        break;
      case 245:
#line 767 "parse.y"
{sqliteCopy(pParse,sqliteSrcListAppend(0,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318),&yymsp[0].minor.yy318,0,yymsp[-4].minor.yy424);}
#line 3546 "parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        break;
      case 246:
#line 771 "parse.y"
{sqliteVacuum(pParse,0);}
#line 3553 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 247:
#line 772 "parse.y"
{sqliteVacuum(pParse,&yymsp[0].minor.yy318);}
#line 3559 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 248:
#line 776 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,0);}
#line 3565 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 249:
#line 777 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy0,0);}
#line 3572 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 250:
#line 778 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,0);}
#line 3579 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 251:
#line 779 "parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,1);}
#line 3586 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 252:
#line 780 "parse.y"
{sqlitePragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-1].minor.yy318,0);}
#line 3593 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 253:
#line 781 "parse.y"
{sqlitePragma(pParse,&yymsp[0].minor.yy318,&yymsp[0].minor.yy318,0);}
#line 3601 "parse.c"
        /* No destructor defined for PRAGMA */
        break;
      case 254:
#line 782 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 3607 "parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 255:
#line 783 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 3613 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 256:
#line 784 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 3619 "parse.c"
        break;
      case 257:
#line 785 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 3624 "parse.c"
        break;
      case 258:
        /* No destructor defined for PLUS */
        break;
      case 259:
        break;
      case 260:
#line 791 "parse.y"
{
  Token all;
  all.z = yymsp[-4].minor.yy0.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-4].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqliteFinishTrigger(pParse, yymsp[-1].minor.yy353, &all);
}
#line 3639 "parse.c"
        /* No destructor defined for trigger_decl */
        /* No destructor defined for BEGIN */
        break;
      case 261:
#line 799 "parse.y"
{
  SrcList *pTab = sqliteSrcListAppend(0, &yymsp[-3].minor.yy318, &yymsp[-2].minor.yy318);
  sqliteBeginTrigger(pParse, &yymsp[-7].minor.yy318, yymsp[-6].minor.yy424, yymsp[-5].minor.yy414.a, yymsp[-5].minor.yy414.b, pTab, yymsp[-1].minor.yy424, yymsp[0].minor.yy206, yymsp[-9].minor.yy424);
}
#line 3649 "parse.c"
        /* No destructor defined for TRIGGER */
        /* No destructor defined for ON */
        break;
      case 262:
#line 805 "parse.y"
{ yygotominor.yy424 = TK_BEFORE; }
#line 3656 "parse.c"
        /* No destructor defined for BEFORE */
        break;
      case 263:
#line 806 "parse.y"
{ yygotominor.yy424 = TK_AFTER;  }
#line 3662 "parse.c"
        /* No destructor defined for AFTER */
        break;
      case 264:
#line 807 "parse.y"
{ yygotominor.yy424 = TK_INSTEAD;}
#line 3668 "parse.c"
        /* No destructor defined for INSTEAD */
        /* No destructor defined for OF */
        break;
      case 265:
#line 808 "parse.y"
{ yygotominor.yy424 = TK_BEFORE; }
#line 3675 "parse.c"
        break;
      case 266:
#line 812 "parse.y"
{ yygotominor.yy414.a = TK_DELETE; yygotominor.yy414.b = 0; }
#line 3680 "parse.c"
        /* No destructor defined for DELETE */
        break;
      case 267:
#line 813 "parse.y"
{ yygotominor.yy414.a = TK_INSERT; yygotominor.yy414.b = 0; }
#line 3686 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 268:
#line 814 "parse.y"
{ yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = 0;}
#line 3692 "parse.c"
        /* No destructor defined for UPDATE */
        break;
      case 269:
#line 815 "parse.y"
{yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = yymsp[0].minor.yy246; }
#line 3698 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for OF */
        break;
      case 270:
#line 818 "parse.y"
{ yygotominor.yy424 = TK_ROW; }
#line 3705 "parse.c"
        break;
      case 271:
#line 819 "parse.y"
{ yygotominor.yy424 = TK_ROW; }
#line 3710 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for ROW */
        break;
      case 272:
#line 820 "parse.y"
{ yygotominor.yy424 = TK_STATEMENT; }
#line 3718 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for STATEMENT */
        break;
      case 273:
#line 823 "parse.y"
{ yygotominor.yy206 = 0; }
#line 3726 "parse.c"
        break;
      case 274:
#line 824 "parse.y"
{ yygotominor.yy206 = yymsp[0].minor.yy164; }
#line 3731 "parse.c"
        /* No destructor defined for WHEN */
        break;
      case 275:
#line 828 "parse.y"
{
  yymsp[-2].minor.yy353->pNext = yymsp[0].minor.yy353;
  yygotominor.yy353 = yymsp[-2].minor.yy353;
}
#line 3740 "parse.c"
        /* No destructor defined for SEMI */
        break;
      case 276:
#line 832 "parse.y"
{ yygotominor.yy353 = 0; }
#line 3746 "parse.c"
        break;
      case 277:
#line 838 "parse.y"
{ yygotominor.yy353 = sqliteTriggerUpdateStep(&yymsp[-3].minor.yy318, yymsp[-1].minor.yy232, yymsp[0].minor.yy164, yymsp[-4].minor.yy424); }
#line 3751 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 278:
#line 843 "parse.y"
{yygotominor.yy353 = sqliteTriggerInsertStep(&yymsp[-5].minor.yy318, yymsp[-4].minor.yy246, yymsp[-1].minor.yy232, 0, yymsp[-7].minor.yy424);}
#line 3758 "parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 279:
#line 846 "parse.y"
{yygotominor.yy353 = sqliteTriggerInsertStep(&yymsp[-2].minor.yy318, yymsp[-1].minor.yy246, 0, yymsp[0].minor.yy375, yymsp[-4].minor.yy424);}
#line 3768 "parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        break;
      case 280:
#line 850 "parse.y"
{yygotominor.yy353 = sqliteTriggerDeleteStep(&yymsp[-1].minor.yy318, yymsp[0].minor.yy164);}
#line 3775 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 281:
#line 853 "parse.y"
{yygotominor.yy353 = sqliteTriggerSelectStep(yymsp[0].minor.yy375); }
#line 3782 "parse.c"
        break;
      case 282:
#line 856 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy164->iColumn = OE_Ignore;
  sqliteExprSpan(yygotominor.yy164, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3791 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for IGNORE */
        break;
      case 283:
#line 861 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Rollback;
  sqliteExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3802 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for COMMA */
        break;
      case 284:
#line 866 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Abort;
  sqliteExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3814 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ABORT */
        /* No destructor defined for COMMA */
        break;
      case 285:
#line 871 "parse.y"
{
  yygotominor.yy164 = sqliteExpr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Fail;
  sqliteExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3826 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for FAIL */
        /* No destructor defined for COMMA */
        break;
      case 286:
#line 878 "parse.y"
{
  sqliteDropTrigger(pParse,sqliteSrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 3836 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TRIGGER */
        break;
      case 287:
#line 883 "parse.y"
{
  sqliteAttach(pParse, &yymsp[-2].minor.yy318, &yymsp[0].minor.yy318);
}
#line 3845 "parse.c"
        /* No destructor defined for ATTACH */
        /* No destructor defined for database_kw_opt */
        /* No destructor defined for AS */
        break;
      case 288:
        /* No destructor defined for DATABASE */
        break;
      case 289:
        break;
      case 290:
#line 891 "parse.y"
{
  sqliteDetach(pParse, &yymsp[0].minor.yy318);
}
#line 3860 "parse.c"
        /* No destructor defined for DETACH */
        /* No destructor defined for database_kw_opt */
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqliteParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqliteSetNString(&pParse->zErrMsg, 
          "near \"", -1, TOKEN.z, TOKEN.n, "\": syntax error", -1, 0);
    }else{
      sqliteSetString(&pParse->zErrMsg, "incomplete SQL statement", (char*)0);
    }
  }
  pParse->nErr++;

#line 3916 "parse.c"
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqliteParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqliteParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqliteParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqliteParserTOKENTYPE yyminor       /* The value for the token */
  sqliteParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqliteParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
