#!/usr/bin/perl

package eBay::API::XML::DataType::DuplicateInvocationDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DuplicateInvocationDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DuplicateInvocationDetailsType

=head1 DESCRIPTION

Contains properties that provide information on duplicate uses of InvocationIDs.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DuplicateInvocationDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::UUIDType;
use eBay::API::XML::DataType::Enum::InvocationStatusType;


my @gaProperties = ( [ 'DuplicateInvocationID', 'ns:UUIDType', ''
	     ,'eBay::API::XML::DataType::UUIDType', '1' ]
	, [ 'InvocationTrackingID', 'xs:string', '', '', '' ]
	, [ 'Status', 'ns:InvocationStatusType', ''
	     ,'eBay::API::XML::DataType::Enum::InvocationStatusType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDuplicateInvocationID()

The duplicate InvocationID.

#    Argument: 'ns:UUIDType'

=cut

sub setDuplicateInvocationID {
  my $self = shift;
  $self->{'DuplicateInvocationID'} = shift
}

=head2 getDuplicateInvocationID()

  Calls: AddItem
         AddLiveAuctionItem
         AddOrder
         AddSecondChanceItem
         AddToItemDescription
         PlaceOffer
         RelistItem
         ReviseLiveAuctionItem
         ReviseCheckoutStatus
         ReviseItem
  Returned: Conditionally

#    Returns: 'ns:UUIDType'

=cut

sub getDuplicateInvocationID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DuplicateInvocationID'
		,'eBay::API::XML::DataType::UUIDType');
}


=head2 setInvocationTrackingID()

The id that identifies the business item the previous API invocation 
created. For example, the ItemID of the item created by an AddItem call.

#    Argument: 'xs:string'

=cut

sub setInvocationTrackingID {
  my $self = shift;
  $self->{'InvocationTrackingID'} = shift
}

=head2 getInvocationTrackingID()

  Calls: AddItem
         AddLiveAuctionItem
         AddOrder
         AddSecondChanceItem
         AddToItemDescription
         PlaceOffer
         RelistItem
         ReviseCheckoutStatus
         ReviseItem
         ReviseLiveAuctionItem
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getInvocationTrackingID {
  my $self = shift;
  return $self->{'InvocationTrackingID'};
}


=head2 setStatus()

The status of the previous call that used the InvocationID.

#    Argument: 'ns:InvocationStatusType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: AddItem
         AddLiveAuctionItem
         AddOrder
         AddSecondChanceItem
         AddToItemDescription
         PlaceOffer
         RelistItem
         ReviseCheckoutStatus
         ReviseItem
         ReviseLiveAuctionItem
  Returned: Conditionally

#    Returns: 'ns:InvocationStatusType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
