/****************************************************************************
 * NOTE: This file has been modified for use with MSDOS/Windows and the
 * WATCOM C/C++^32 compiler.  Darryl Okahata, October 1994.
 ****************************************************************************/

/*
 * "The Road goes ever on and on, down from the door where it began."
 */

#include "INTERN.h"
#include "perl.h"

static void xs_init _((void));
static PerlInterpreter *my_perl;

/* This value may be raised by extensions for testing purposes */
int perl_destruct_level = 0; /* 0=none, 1=full, 2=full with checks */


int
main(argc, argv, env)
int argc;
char **argv;
char **env;
{
    int exitstatus;

#if defined(DOS_EXTENDER) && !defined(__WINDOWS_386__)
    /*
     * Get an estimate of where data memory starts.
     */
    initialize_dos_mem_info();
#endif
#ifdef __WATCOMC__
    env = environ;		/* Fix environment pointer -- this is
				   WATCOM C/C++ specific. */
#endif
#if defined(MSDOS)
    msdos_init(&argc, &argv);
#endif
#if defined(__WINDOWS_386__)
    _dwSetAppTitle("Perl 5.000");
    _dwSetAboutDlg("Perl 5.000",
"This is a sample port of Perl 5.000 to Windows.  It really isn't usable\n\
for much, and is intended mainly as a \"proof-of-concept\" example.");
#endif

#ifdef VMS
    getredirection(&argc,&argv);
#endif

    if (!do_undump) {
	my_perl = perl_alloc();
	if (!my_perl)
	    exit(1);
	perl_construct( my_perl );
    }

    exitstatus = perl_parse( my_perl, xs_init, argc, argv, env );
    if (exitstatus)
	exit( exitstatus );

    exitstatus = perl_run( my_perl );

    perl_destruct( my_perl, perl_destruct_level );
    perl_free( my_perl );

    exit( exitstatus );
}

/* Register any extra external extensions */

static void
xs_init()
{
    /* Do not delete this line--writemain depends on it */
    char *file = __FILE__;
    {   extern void boot_DynaLoader _((CV* cv));
        newXS("DynaLoader::boot_DynaLoader", boot_DynaLoader, file);
    }
    {   extern void boot_DB_File _((CV* cv));
        newXS("DB_File::bootstrap", boot_DB_File, file);
    }
    {   extern void boot_Fcntl _((CV* cv));
        newXS("Fcntl::bootstrap", boot_Fcntl, file);
    }
    {   extern void boot_SDBM_File _((CV* cv));
        newXS("SDBM_File::bootstrap", boot_SDBM_File, file);
    }
}
